/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google;

import org.teiid.logging.LogManager;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.google.SpreadsheetExecutionFactory;
import org.teiid.translator.google.api.GoogleSpreadsheetConnection;
import org.teiid.translator.google.api.metadata.Column;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.metadata.Worksheet;

public class GoogleMetadataProcessor
implements MetadataProcessor<GoogleSpreadsheetConnection> {
    private boolean allTypesUpdatable = true;

    public void process(MetadataFactory mf, GoogleSpreadsheetConnection conn) throws TranslatorException {
        SpreadsheetInfo ssMetadata = conn.getSpreadsheetInfo();
        for (Worksheet worksheet : ssMetadata.getWorksheets()) {
            this.addTable(mf, worksheet);
        }
    }

    private void addTable(MetadataFactory mf, Worksheet worksheet) {
        if (worksheet.getColumnCount() == 0) {
            return;
        }
        Table table = mf.addTable(worksheet.getName());
        table.setNameInSource(worksheet.getName());
        if (worksheet.isHeaderEnabled()) {
            table.setSupportsUpdate(true);
        }
        this.addColumnsToTable(mf, table, worksheet);
    }

    private void addColumnsToTable(MetadataFactory mf, Table table, Worksheet worksheet) {
        boolean updatable = true;
        for (Column column : worksheet.getColumnsAsList()) {
            String type = null;
            switch (column.getDataType()) {
                case DATE: {
                    updatable = false;
                    type = "date";
                    break;
                }
                case BOOLEAN: {
                    type = "boolean";
                    break;
                }
                case DATETIME: {
                    updatable = false;
                    type = "timestamp";
                    break;
                }
                case NUMBER: {
                    updatable = false;
                    type = "double";
                    break;
                }
                case TIMEOFDAY: {
                    updatable = false;
                    type = "time";
                    break;
                }
                default: {
                    type = "string";
                }
            }
            String name = column.getAlphaName();
            if (worksheet.isHeaderEnabled() && (name = column.getLabel()) == null) {
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)SpreadsheetExecutionFactory.UTIL.getString("missing_label", new Object[]{column.getAlphaName()}));
                continue;
            }
            org.teiid.metadata.Column c = mf.addColumn(name, type, (ColumnSet)table);
            if (table.supportsUpdate()) {
                c.setUpdatable(updatable || this.allTypesUpdatable);
            }
            c.setNameInSource(worksheet.isHeaderEnabled() ? column.getLabel() : column.getAlphaName());
            c.setNativeType(column.getDataType().name());
        }
    }

    @TranslatorProperty(display="All Types Updatable", category=TranslatorProperty.PropertyType.IMPORT, description="Allow all types to be updatable even those that may have formatting or locale inconsistencies.")
    public boolean isAllTypesUpdatable() {
        return this.allTypesUpdatable;
    }

    public void setAllTypesUpdatable(boolean allTypesUpdatable) {
        this.allTypesUpdatable = allTypesUpdatable;
    }
}

