/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google.visitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.Expression;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.UpdateSet;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.visitor.SpreadsheetCriteriaVisitor;

public class SpreadsheetUpdateVisitor
extends SpreadsheetCriteriaVisitor {
    private List<UpdateSet> changes;

    public SpreadsheetUpdateVisitor(SpreadsheetInfo info) {
        super(info);
    }

    public void visit(Update obj) {
        this.worksheetTitle = obj.getTable().getName();
        this.changes = new ArrayList<UpdateSet>();
        if (obj.getTable().getMetadataObject().getNameInSource() != null) {
            this.worksheetTitle = obj.getTable().getMetadataObject().getNameInSource();
        }
        for (SetClause s : obj.getChanges()) {
            String columnName = s.getSymbol().getMetadataObject().getNameInSource() != null ? s.getSymbol().getMetadataObject().getNameInSource() : s.getSymbol().getMetadataObject().getName();
            this.changes.add(new UpdateSet(columnName, this.getStringValue(s.getValue())));
        }
        this.translateWhere(obj.getWhere());
    }

    protected String getStringValue(Expression obj) {
        if (!(obj instanceof Literal)) {
            throw new SpreadsheetOperationException("Spreadsheet translator internal error: Expression is not allowed in the set clause");
        }
        Literal literal = (Literal)obj;
        if (literal.getValue() == null) {
            if (literal.getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
                throw new SpreadsheetOperationException("Spreadsheet translator error: String values cannot be set to null");
            }
            return "";
        }
        if (literal.getType().equals(DataTypeManager.DefaultDataClasses.DATE)) {
            return new SimpleDateFormat("MM/dd/yyyy").format(literal.getValue());
        }
        if (literal.getType().equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            return new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(literal.getValue());
        }
        if (literal.getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            return "'" + literal.getValue().toString();
        }
        return literal.getValue().toString();
    }

    public List<UpdateSet> getChanges() {
        return this.changes;
    }

    public void setChanges(List<UpdateSet> changes) {
        this.changes = changes;
    }
}

