/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.util.StringUtil;
import org.teiid.language.Argument;
import org.teiid.language.Literal;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.logging.LogManager;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.google.SpreadsheetExecutionFactory;
import org.teiid.translator.google.api.GoogleSpreadsheetConnection;
import org.teiid.translator.google.api.result.SheetRow;
import org.teiid.translator.google.visitor.SpreadsheetSQLVisitor;

public class DirectSpreadsheetQueryExecution
implements ProcedureExecution {
    private static final String WORKSHEET = "worksheet";
    private static final String QUERY = "query";
    private static final String OFFEST = "offset";
    private static final String LIMIT = "limit";
    private GoogleSpreadsheetConnection connection;
    private Iterator<SheetRow> rowIterator;
    private ExecutionContext executionContext;
    private List<Argument> arguments;
    private String query;
    private boolean returnsArray;

    public DirectSpreadsheetQueryExecution(String query, List<Argument> arguments, ExecutionContext executionContext, GoogleSpreadsheetConnection connection, boolean returnsArray) {
        this.executionContext = executionContext;
        this.connection = connection;
        this.arguments = arguments;
        this.query = query;
        this.returnsArray = returnsArray;
    }

    public void close() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)SpreadsheetExecutionFactory.UTIL.getString("close_query"));
    }

    public void cancel() throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)SpreadsheetExecutionFactory.UTIL.getString("cancel_query"));
        this.rowIterator = null;
    }

    public void execute() throws TranslatorException {
        String worksheet = null;
        Integer limit = null;
        Integer offset = null;
        String toQuery = this.query;
        List parts = StringUtil.tokenize((String)this.query, (char)';');
        for (String var : parts) {
            int index = var.indexOf(61);
            if (index == -1) continue;
            String key = var.substring(0, index).trim();
            String value = var.substring(index + 1).trim();
            if (key.equalsIgnoreCase(WORKSHEET)) {
                worksheet = value;
                continue;
            }
            if (key.equalsIgnoreCase(QUERY)) {
                StringBuilder buffer = new StringBuilder();
                SQLStringVisitor.parseNativeQueryParts((String)value, this.arguments, (StringBuilder)buffer, (SQLStringVisitor.Substitutor)new SQLStringVisitor.Substitutor(){

                    public void substitute(Argument arg, StringBuilder builder, int index) {
                        Literal argumentValue = arg.getArgumentValue();
                        SpreadsheetSQLVisitor visitor = new SpreadsheetSQLVisitor(DirectSpreadsheetQueryExecution.this.connection.getSpreadsheetInfo());
                        visitor.visit(argumentValue);
                        builder.append(visitor.getTranslatedSQL());
                    }
                });
                toQuery = buffer.toString();
                continue;
            }
            if (key.equalsIgnoreCase(LIMIT)) {
                limit = Integer.parseInt(value);
                continue;
            }
            if (!key.equalsIgnoreCase(OFFEST)) continue;
            offset = Integer.parseInt(value);
        }
        this.rowIterator = this.connection.executeQuery(worksheet, toQuery, offset, limit, this.executionContext.getBatchSize()).iterator();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.rowIterator != null && this.rowIterator.hasNext()) {
            List result = this.rowIterator.next().getRow();
            if (this.returnsArray) {
                return Arrays.asList(new Object[]{result.toArray()});
            }
            return result;
        }
        this.rowIterator = null;
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }
}

