/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google;

import java.util.Arrays;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.google.DirectSpreadsheetQueryExecution;
import org.teiid.translator.google.GoogleMetadataProcessor;
import org.teiid.translator.google.SpreadsheetQueryExecution;
import org.teiid.translator.google.SpreadsheetUpdateExecution;
import org.teiid.translator.google.api.GoogleSpreadsheetConnection;

@Translator(name="google-spreadsheet", description="A translator for Google Spreadsheet")
public class SpreadsheetExecutionFactory
extends ExecutionFactory<ConnectionFactory, GoogleSpreadsheetConnection> {
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(SpreadsheetExecutionFactory.class);

    public SpreadsheetExecutionFactory() {
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
    }

    public void start() throws TranslatorException {
        super.start();
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"Google Spreadsheet ExecutionFactory Started");
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, GoogleSpreadsheetConnection connection) throws TranslatorException {
        return new SpreadsheetQueryExecution((Select)command, connection, executionContext);
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, GoogleSpreadsheetConnection connection) throws TranslatorException {
        SpreadsheetUpdateExecution result = new SpreadsheetUpdateExecution(command, connection, executionContext, metadata);
        return result;
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, GoogleSpreadsheetConnection connection) throws TranslatorException {
        return new DirectSpreadsheetQueryExecution((String)arguments.get(0).getArgumentValue().getValue(), arguments.subList(1, arguments.size()), executionContext, connection, true);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, GoogleSpreadsheetConnection connection) throws TranslatorException {
        String nativeQuery = command.getMetadataObject().getProperty("{http://www.teiid.org/ext/relational/2012}native-query", false);
        if (nativeQuery != null) {
            return new DirectSpreadsheetQueryExecution(nativeQuery, command.getArguments(), executionContext, connection, false);
        }
        throw new TranslatorException("Missing native-query extension metadata.");
    }

    public MetadataProcessor<GoogleSpreadsheetConnection> getMetadataProcessor() {
        return new GoogleMetadataProcessor();
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsInCriteria() {
        return false;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsAggregatesCount() {
        return true;
    }

    public boolean supportsAggregatesMax() {
        return true;
    }

    public boolean supportsAggregatesMin() {
        return true;
    }

    public boolean supportsAggregatesSum() {
        return true;
    }

    public boolean supportsAggregatesAvg() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsOrderBy() {
        return false;
    }

    public boolean supportsHaving() {
        return false;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public List<String> getSupportedFunctions() {
        return Arrays.asList("year", "month", "dayofmonth", "hour", "minute", "second", "quarter", "dayofweek", "ucase", "lcase");
    }
}

