/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google;

import org.teiid.language.Command;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.google.SpreadsheetExecutionFactory;
import org.teiid.translator.google.api.GoogleSpreadsheetConnection;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.metadata.Worksheet;
import org.teiid.translator.google.api.result.UpdateResult;

public abstract class AbstractSpreadsheetExecution
implements UpdateExecution {
    protected GoogleSpreadsheetConnection connection;
    protected RuntimeMetadata metadata;
    protected ExecutionContext context;
    protected Command command;
    protected UpdateResult result;

    public AbstractSpreadsheetExecution(Command command, GoogleSpreadsheetConnection connection, ExecutionContext context, RuntimeMetadata metadata) {
        this.connection = connection;
        this.metadata = metadata;
        this.context = context;
        this.command = command;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        if (this.result.getExpectedNumberOfRows() != this.result.getActualNumberOfRows()) {
            if (this.result.getExpectedNumberOfRows() > this.result.getActualNumberOfRows()) {
                this.context.addWarning((Exception)new SpreadsheetOperationException(SpreadsheetExecutionFactory.UTIL.gs("partial_update", new Object[]{this.result.getExpectedNumberOfRows(), this.result.getActualNumberOfRows()})));
            } else {
                throw new SpreadsheetOperationException(SpreadsheetExecutionFactory.UTIL.gs("unexpected_updatecount", new Object[]{this.result.getExpectedNumberOfRows(), this.result.getActualNumberOfRows()}));
            }
        }
        return new int[]{this.result.getActualNumberOfRows()};
    }

    void checkHeaders(String worksheetTitle) throws TranslatorException {
        SpreadsheetInfo info = this.connection.getSpreadsheetInfo();
        Worksheet worksheet = info.getWorksheetByName(worksheetTitle);
        if (worksheet == null) {
            throw new SpreadsheetOperationException(SpreadsheetExecutionFactory.UTIL.gs("missing_worksheet", new Object[]{worksheetTitle}));
        }
        if (!worksheet.isHeaderEnabled()) {
            throw new TranslatorException(SpreadsheetExecutionFactory.UTIL.gs("headers_required", new Object[0]));
        }
    }

    public GoogleSpreadsheetConnection getConnection() {
        return this.connection;
    }
}

