/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google.visitor;

import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.google.SpreadsheetExecutionFactory;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.metadata.Worksheet;
import org.teiid.translator.google.visitor.SpreadsheetCriteriaVisitor;

public class SpreadsheetSQLVisitor
extends SpreadsheetCriteriaVisitor {
    private Integer limitValue = null;
    private Integer offsetValue = null;

    public SpreadsheetSQLVisitor(SpreadsheetInfo spreadsheetInfo) {
        super(spreadsheetInfo);
    }

    @Override
    public String getWorksheetTitle() {
        return this.worksheetTitle;
    }

    @Override
    protected String replaceElementName(String group, String element) {
        Worksheet worksheetSourceName = this.info.getWorksheetByName(this.worksheetTitle);
        if (worksheetSourceName == null) {
            throw new SpreadsheetOperationException(SpreadsheetExecutionFactory.UTIL.gs("missing_worksheet", new Object[]{this.worksheetTitle}));
        }
        String columnId = worksheetSourceName.getColumnID(element);
        if (columnId == null) {
            throw new SpreadsheetOperationException("Column " + element + " doesn't exist in the worksheet " + this.worksheetTitle);
        }
        return columnId;
    }

    public String getTranslatedSQL() {
        return this.buffer.toString();
    }

    public void translateSQL(LanguageObject obj) {
        this.append(obj);
    }

    public void visit(Select obj) {
        this.buffer.append("SELECT").append(" ");
        if (obj.getFrom() != null && !obj.getFrom().isEmpty()) {
            NamedTable table = (NamedTable)obj.getFrom().get(0);
            this.worksheetTitle = table.getName();
            if (table.getMetadataObject().getNameInSource() != null) {
                this.worksheetTitle = table.getMetadataObject().getNameInSource();
            }
        }
        this.append(obj.getDerivedColumns());
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((LanguageObject)obj.getWhere());
        }
        if (obj.getGroupBy() != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getGroupBy());
        }
        if (obj.getOrderBy() != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            if (obj.getLimit().getRowOffset() > 0) {
                this.offsetValue = obj.getLimit().getRowOffset();
            }
            this.limitValue = obj.getLimit().getRowLimit();
        }
    }

    public Integer getLimitValue() {
        return this.limitValue;
    }

    public Integer getOffsetValue() {
        return this.offsetValue;
    }

    @Override
    public void visit(Function function) {
        if (function.getName().equalsIgnoreCase("dayofmonth")) {
            function.setName("day");
        } else if (function.getName().equalsIgnoreCase("ucase")) {
            function.setName("upper");
        } else if (function.getName().equalsIgnoreCase("lcase")) {
            function.setName("lower");
        } else if (function.getName().equalsIgnoreCase("dayofweek")) {
            function.setName("weekday");
        }
        super.visit(function);
    }

    @Override
    public void visit(Literal obj) {
        if (obj.getValue() == null) {
            super.visit(obj);
        } else if (obj.getType() == TypeFacility.RUNTIME_TYPES.DATE) {
            this.buffer.append("date ").append('\"').append(obj.getValue()).append('\"');
        } else if (obj.getType() == TypeFacility.RUNTIME_TYPES.TIME) {
            this.buffer.append("timeofday ").append('\"').append(obj.getValue()).append('\"');
        } else if (obj.getType() == TypeFacility.RUNTIME_TYPES.TIMESTAMP) {
            String val = obj.getValue().toString();
            int i = val.lastIndexOf(46);
            if (i != -1 && i < val.length() - 4) {
                val = val.substring(0, i + 4);
            }
            this.buffer.append("datetime ").append('\"').append(val).append('\"');
        } else {
            super.visit(obj);
        }
    }

    @Override
    public void visit(Like obj) {
        if (obj.isNegated()) {
            this.buffer.append("(");
        }
        super.visit(obj);
        if (obj.isNegated()) {
            this.buffer.append(" AND ");
            this.visitNode((LanguageObject)obj.getLeftExpression());
            this.buffer.append(" IS NOT NULL)");
        }
    }

    @Override
    protected boolean isUpdate() {
        return false;
    }
}

