/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.google.GoogleMetadataProcessor;
import org.teiid.translator.google.api.GoogleSpreadsheetConnection;
import org.teiid.translator.google.api.metadata.Column;
import org.teiid.translator.google.api.metadata.SpreadsheetColumnType;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.metadata.Util;
import org.teiid.translator.google.api.metadata.Worksheet;

public class TestMetadataProcessor {
    @Test
    public void testRemoveColumns() throws Exception {
        GoogleSpreadsheetConnection conn = (GoogleSpreadsheetConnection)Mockito.mock(GoogleSpreadsheetConnection.class);
        SpreadsheetInfo people = new SpreadsheetInfo();
        Worksheet worksheet = people.createWorksheet("PeopleList");
        worksheet.setHeaderEnabled(true);
        for (int i = 1; i <= 3; ++i) {
            Column newCol = new Column();
            newCol.setAlphaName(Util.convertColumnIDtoString((int)i));
            newCol.setLabel("c" + i);
            if (i == 1) {
                newCol.setDataType(SpreadsheetColumnType.DATETIME);
            }
            worksheet.addColumn(newCol.getAlphaName(), newCol);
        }
        Column newCol = new Column();
        newCol.setAlphaName("empty");
        worksheet.addColumn(null, newCol);
        Mockito.stub((Object)conn.getSpreadsheetInfo()).toReturn((Object)people);
        MetadataFactory factory = new MetadataFactory("", (Object)1, "", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), "");
        GoogleMetadataProcessor processor = new GoogleMetadataProcessor();
        processor.process(factory, conn);
        Table t = (Table)factory.getSchema().getTables().get("PeopleList");
        Assert.assertTrue((boolean)t.supportsUpdate());
        Assert.assertEquals((long)3L, (long)t.getColumns().size());
        Assert.assertTrue((boolean)((org.teiid.metadata.Column)t.getColumns().get(0)).isUpdatable());
        processor.setAllTypesUpdatable(false);
        factory = new MetadataFactory("", (Object)1, "", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), "");
        processor.process(factory, conn);
        t = (Table)factory.getSchema().getTables().get("PeopleList");
        Assert.assertFalse((boolean)((org.teiid.metadata.Column)t.getColumns().get(0)).isUpdatable());
    }
}

