/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.language.Command;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.google.SpreadsheetExecutionFactory;
import org.teiid.translator.google.api.GoogleSpreadsheetConnection;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.result.RowsResult;
import org.teiid.translator.google.api.result.SheetRow;

public class TestNativeSpreadsheet {
    @Test
    public void testDirect() throws TranslatorException {
        SpreadsheetExecutionFactory sef = new SpreadsheetExecutionFactory();
        sef.setSupportsDirectQueryProcedure(true);
        String input = "call native('worksheet=x;query=$1 foo;limit=2', 'a')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        GoogleSpreadsheetConnection connection = (GoogleSpreadsheetConnection)Mockito.mock(GoogleSpreadsheetConnection.class);
        SpreadsheetInfo info = new SpreadsheetInfo();
        info.createWorksheet("x");
        Mockito.stub((Object)connection.getSpreadsheetInfo()).toReturn((Object)info);
        RowsResult result = (RowsResult)Mockito.mock(RowsResult.class);
        Mockito.stub((Object)result.iterator()).toReturn(Arrays.asList(new SheetRow()).iterator());
        Mockito.stub((Object)connection.executeQuery(info.getWorksheetByName("x"), "'a' foo", null, Integer.valueOf(2), 0)).toReturn((Object)result);
        ResultSetExecution execution = (ResultSetExecution)sef.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        List vals = execution.next();
        Assert.assertTrue((boolean)(vals.get(0) instanceof Object[]));
    }
}

