/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google.visitor;

import java.util.LinkedHashMap;
import java.util.Map;
import org.teiid.language.ColumnReference;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.Literal;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.visitor.SpreadsheetCriteriaVisitor;

public class SpreadsheetInsertVisitor
extends SpreadsheetCriteriaVisitor {
    private Map<String, Object> columnNameValuePair = new LinkedHashMap<String, Object>();

    public SpreadsheetInsertVisitor(SpreadsheetInfo info) {
        super(info);
    }

    public void visit(Insert obj) {
        this.setWorksheetByName(obj.getTable().getMetadataObject().getSourceName());
        ExpressionValueSource evs = (ExpressionValueSource)obj.getValueSource();
        for (int i = 0; i < evs.getValues().size(); ++i) {
            Expression e = (Expression)evs.getValues().get(i);
            if (!(e instanceof Literal)) {
                throw new SpreadsheetOperationException("Only literals are allowed in the values section");
            }
            Literal l = (Literal)e;
            if (l.getValue() == null) continue;
            ColumnReference columnReference = (ColumnReference)obj.getColumns().get(i);
            this.columnNameValuePair.put(columnReference.getMetadataObject().getSourceName(), l.getValue());
        }
    }

    public Map<String, Object> getColumnNameValuePair() {
        return this.columnNameValuePair;
    }
}

