/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.hive;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.Insert;
import org.teiid.language.Limit;
import org.teiid.metadata.AggregateAttributes;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.hive.HiveMetadataProcessor;
import org.teiid.translator.hive.HivePlugin;
import org.teiid.translator.hive.HiveSQLConversionVisitor;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCMetdataProcessor;
import org.teiid.translator.jdbc.JDBCUpdateExecution;
import org.teiid.translator.jdbc.SQLConversionVisitor;

public class BaseHiveExecutionFactory
extends JDBCExecutionFactory {
    protected ConvertModifier convert = new ConvertModifier();
    protected boolean useDatabaseMetaData;

    public JDBCUpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        if (command instanceof Insert) {
            return new JDBCUpdateExecution(command, conn, executionContext, (JDBCExecutionFactory)this);
        }
        throw new TranslatorException((BundleUtil.Event)HivePlugin.Event.TEIID24000, HivePlugin.Util.gs((BundleUtil.Event)HivePlugin.Event.TEIID24000, new Object[]{command}));
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        throw new TranslatorException((BundleUtil.Event)HivePlugin.Event.TEIID24000, HivePlugin.Util.gs((BundleUtil.Event)HivePlugin.Event.TEIID24000, new Object[]{command}));
    }

    public SQLConversionVisitor getSQLConversionVisitor() {
        return new HiveSQLConversionVisitor(this);
    }

    public boolean useAnsiJoin() {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    public boolean supportsExistsCriteria() {
        return false;
    }

    public boolean supportsInCriteriaSubquery() {
        return false;
    }

    public boolean supportsLikeCriteriaEscapeCharacter() {
        return false;
    }

    public boolean supportsQuantifiedCompareCriteriaAll() {
        return false;
    }

    public boolean supportsQuantifiedCompareCriteriaSome() {
        return false;
    }

    public boolean supportsBulkUpdate() {
        return false;
    }

    public boolean supportsBatchedUpdates() {
        return false;
    }

    public List<?> translateCommand(Command command, ExecutionContext context) {
        return null;
    }

    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        return null;
    }

    public boolean addSourceComment() {
        return false;
    }

    public boolean useAsInGroupAlias() {
        return false;
    }

    public boolean hasTimeType() {
        return false;
    }

    public String getLikeRegexString() {
        return "REGEXP";
    }

    public boolean supportsScalarSubqueries() {
        return false;
    }

    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsUnions() {
        return true;
    }

    public boolean supportsInsertWithQueryExpression() {
        return false;
    }

    public boolean supportsIntersect() {
        return false;
    }

    public boolean supportsExcept() {
        return false;
    }

    public boolean supportsCommonTableExpressions() {
        return false;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "true";
        }
        return "false";
    }

    public String translateLiteralTime(Time timeValue) {
        if (!this.hasTimeType()) {
            return this.translateLiteralTimestamp(new Timestamp(timeValue.getTime()));
        }
        return '\'' + this.formatDateValue(timeValue) + '\'';
    }

    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "cast('" + this.formatDateValue(timestampValue) + "' as timestamp)";
    }

    @Deprecated
    protected JDBCMetdataProcessor createMetadataProcessor() {
        return this.getMetadataProcessor();
    }

    public JDBCMetdataProcessor getMetadataProcessor() {
        HiveMetadataProcessor result = new HiveMetadataProcessor();
        result.setUseDatabaseMetaData(this.useDatabaseMetaData);
        return result;
    }

    public Object retrieveValue(ResultSet results, int columnIndex, Class<?> expectedType) throws SQLException {
        if (expectedType.equals(Timestamp.class)) {
            return results.getTimestamp(columnIndex);
        }
        if (expectedType.equals(Date.class)) {
            return results.getDate(columnIndex);
        }
        if (expectedType.equals(Time.class)) {
            return results.getTime(columnIndex);
        }
        try {
            return super.retrieveValue(results, columnIndex, expectedType);
        }
        catch (SQLException e) {
            return super.retrieveValue(results, columnIndex, TypeFacility.RUNTIME_TYPES.OBJECT);
        }
    }

    public Object retrieveValue(CallableStatement results, int parameterIndex, Class<?> expectedType) throws SQLException {
        if (expectedType.equals(Timestamp.class)) {
            return results.getTimestamp(parameterIndex);
        }
        if (expectedType.equals(Date.class)) {
            return results.getDate(parameterIndex);
        }
        if (expectedType.equals(Time.class)) {
            return results.getTime(parameterIndex);
        }
        try {
            return super.retrieveValue(results, parameterIndex, expectedType);
        }
        catch (SQLException e) {
            return super.retrieveValue(results, parameterIndex, TypeFacility.RUNTIME_TYPES.OBJECT);
        }
    }

    public void bindValue(PreparedStatement stmt, Object param, Class<?> paramType, int i) throws SQLException {
        if (paramType.equals(Timestamp.class)) {
            stmt.setTimestamp(i, (Timestamp)param);
        }
        if (paramType.equals(Date.class)) {
            stmt.setDate(i, (Date)param);
        }
        if (paramType.equals(Time.class)) {
            stmt.setTime(i, (Time)param);
        }
        super.bindValue(stmt, param, paramType, i);
    }

    protected FunctionMethod addAggregatePushDownFunction(String qualifier, String name, String returnType, String ... paramTypes) {
        FunctionMethod method = this.addPushDownFunction(qualifier, name, returnType, paramTypes);
        AggregateAttributes attr = new AggregateAttributes();
        attr.setAnalytic(true);
        method.setAggregateAttributes(attr);
        return method;
    }

    public boolean supportsHaving() {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) {
        if (!super.supportsConvert(fromType, toType)) {
            return false;
        }
        return this.convert.hasTypeMapping(toType);
    }

    @TranslatorProperty(display="Use DatabaseMetaData", description="Use DatabaseMetaData (typical JDBC logic) for importing")
    public boolean isUseDatabaseMetaData() {
        return this.useDatabaseMetaData;
    }

    public void setUseDatabaseMetaData(boolean useDatabaseMetaData) {
        this.useDatabaseMetaData = useDatabaseMetaData;
    }

    public boolean requiresLeftLinearJoin() {
        return false;
    }

    public boolean supportsOrderByUnrelated() {
        return false;
    }
}

