/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.hive;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.jdbc.JDBCMetdataProcessor;

public class HiveMetadataProcessor
extends JDBCMetdataProcessor
implements MetadataProcessor<Connection> {
    private boolean trimColumnNames;
    private boolean useDatabaseMetaData;

    public HiveMetadataProcessor() {
        this.setImportKeys(false);
        this.setQuoteString("`");
    }

    public void process(MetadataFactory metadataFactory, Connection conn) throws TranslatorException {
        try {
            this.getConnectorMetadata(conn, metadataFactory);
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void getConnectorMetadata(Connection conn, MetadataFactory metadataFactory) throws SQLException {
        if (this.useDatabaseMetaData) {
            super.getConnectorMetadata(conn, metadataFactory);
            return;
        }
        List<String> tables = this.getTables(conn);
        for (String table : tables) {
            if (this.shouldExclude(table)) continue;
            this.addTable(table, conn, metadataFactory);
        }
    }

    private List<String> getTables(Connection conn) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW TABLES");
        while (rs.next()) {
            tables.add(rs.getString(1));
        }
        rs.close();
        return tables;
    }

    private String getRuntimeType(String type) {
        if (type.equalsIgnoreCase("int")) {
            return "integer";
        }
        if (type.equalsIgnoreCase("tinyint")) {
            return "byte";
        }
        if (type.equalsIgnoreCase("smallint")) {
            return "short";
        }
        if (type.equalsIgnoreCase("bigint")) {
            return "long";
        }
        if (type.equalsIgnoreCase("string")) {
            return "string";
        }
        if (type.equalsIgnoreCase("float")) {
            return "float";
        }
        if (type.equalsIgnoreCase("double")) {
            return "double";
        }
        if (type.equalsIgnoreCase("boolean")) {
            return "boolean";
        }
        if (StringUtil.startsWithIgnoreCase((String)type, (String)"decimal")) {
            return "bigdecimal";
        }
        if (type.equalsIgnoreCase("timestamp")) {
            return "timestamp";
        }
        if (type.equalsIgnoreCase("date")) {
            return "date";
        }
        if (type.equalsIgnoreCase("BINARY")) {
            return "varbinary";
        }
        if (type.equalsIgnoreCase("varchar")) {
            return "string";
        }
        return "string";
    }

    private void addTable(String tableName, Connection conn, MetadataFactory metadataFactory) throws SQLException {
        Table table = this.addTable(metadataFactory, null, null, tableName, null, tableName);
        if (table == null) {
            return;
        }
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("DESCRIBE " + tableName);
        while (rs.next()) {
            String type;
            String name = rs.getString(1);
            if (this.trimColumnNames) {
                name = name.trim();
            }
            if ((type = rs.getString(2)) != null) {
                type = type.trim();
            }
            String runtimeType = this.getRuntimeType(type);
            Column column = metadataFactory.addColumn(name, runtimeType, (ColumnSet)table);
            column.setNameInSource(this.quoteName(name));
            column.setUpdatable(true);
        }
        rs.close();
    }

    public void setTrimColumnNames(boolean trimColumnNames) {
        this.trimColumnNames = trimColumnNames;
    }

    @TranslatorProperty(display="Trim Columns", category=TranslatorProperty.PropertyType.IMPORT, description="Trim column names read from the database")
    public boolean isTrimColumnNames() {
        return this.trimColumnNames;
    }

    @TranslatorProperty(display="Use DatabaseMetaData", category=TranslatorProperty.PropertyType.IMPORT, description="Use DatabaseMetaData (typical JDBC logic) for importing")
    public boolean isUseDatabaseMetaData() {
        return this.useDatabaseMetaData;
    }

    public void setUseDatabaseMetaData(boolean useDatabaseMetaData) {
        this.useDatabaseMetaData = useDatabaseMetaData;
    }
}

