/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.hive;

import java.sql.Connection;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.AggregateFunction;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.DerivedColumn;
import org.teiid.language.DerivedTable;
import org.teiid.language.Expression;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.OrderBy;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.SortSpecification;
import org.teiid.language.TableReference;
import org.teiid.language.WithItem;
import org.teiid.metadata.AggregateAttributes;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.hive.BaseHiveExecutionFactory;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.util.Version;

@Translator(name="impala", description="A translator for Coludera's Impala based database on HDFS")
public class ImpalaExecutionFactory
extends BaseHiveExecutionFactory {
    public static String IMPALA = "impala";
    public static final Version TWO_2 = Version.getVersion((String)"2.2");
    public static final Version TWO_0 = Version.getVersion((String)"2.0");
    public static final Version ONE_2_1 = Version.getVersion((String)"1.2.1");

    public void start() throws TranslatorException {
        super.start();
        this.convert.addTypeMapping("tinyint", new int[]{3});
        this.convert.addTypeMapping("smallint", new int[]{4});
        this.convert.addTypeMapping("int", new int[]{5});
        this.convert.addTypeMapping("bigint", new int[]{7, 6});
        this.convert.addTypeMapping("boolean", new int[]{2});
        this.convert.addTypeMapping("double", new int[]{9});
        this.convert.addTypeMapping("float", new int[]{8});
        this.convert.addTypeMapping("string", new int[]{0});
        this.convert.addTypeMapping("timestamp", new int[]{13});
        this.registerFunctionModifier("convert", (FunctionModifier)this.convert);
        this.registerFunctionModifier("lcase", (FunctionModifier)new AliasModifier("lower"));
        this.registerFunctionModifier("ucase", (FunctionModifier)new AliasModifier("upper"));
        this.registerFunctionModifier("substring", (FunctionModifier)new AliasModifier("substr"));
        this.registerFunctionModifier("curdate", (FunctionModifier)new AliasModifier("unix_timestamp"));
        this.registerFunctionModifier("ifnull", (FunctionModifier)new AliasModifier("isnull"));
        this.registerFunctionModifier("string_agg", (FunctionModifier)new AliasModifier("group_concat"));
        this.addPushDownFunction(IMPALA, "lower", "string", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "upper", "string", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "positive", "integer", new String[]{"integer"});
        this.addPushDownFunction(IMPALA, "positive", "double", new String[]{"double"});
        this.addPushDownFunction(IMPALA, "negitive", "integer", new String[]{"integer"});
        this.addPushDownFunction(IMPALA, "negitive", "double", new String[]{"double"});
        this.addPushDownFunction(IMPALA, "ln", "double", new String[]{"double"});
        this.addPushDownFunction(IMPALA, "reverse", "string", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "space", "string", new String[]{"integer"});
        this.addPushDownFunction(IMPALA, "hex", "string", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "unhex", "string", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "bin", "string", new String[]{"long"});
        this.addPushDownFunction(IMPALA, "add_months", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "adddate", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "date_add", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "date_part", "integer", new String[]{"string", "timestamp"});
        this.addPushDownFunction(IMPALA, "date_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "datediff", "integer", new String[]{"string", "string"});
        this.addPushDownFunction(IMPALA, "day", "integer", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "dayofyear", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(IMPALA, "days_add", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "days_add", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "days_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "days_sub", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "extract", "integer", new String[]{"timestamp", "string"});
        this.addPushDownFunction(IMPALA, "from_unixtime", "string", new String[]{"long"});
        this.addPushDownFunction(IMPALA, "from_unixtime", "string", new String[]{"long", "string"});
        this.addPushDownFunction(IMPALA, "from_utc_timestamp", "timestamp", new String[]{"timestamp", "string"});
        this.addPushDownFunction(IMPALA, "hour", "integer", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "hours_add", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "hours_add", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "hours_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "hours_sub", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "microseconds_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "microseconds_sub", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "milliseconds_add", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "milliseconds_add", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "milliseconds_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "milliseconds_sub", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "minute", "integer", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "minutes_add", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "minutes_add", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "minutes_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "minutes_sub", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "month", "integer", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "months_add", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "months_add", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "months_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "months_sub", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "nanoseconds_add", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "nanoseconds_add", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "nanoseconds_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "nanoseconds_sub", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "second", "integer", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "seconds_add", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "seconds_add", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "seconds_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "seconds_sub", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "subdate", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "to_date", "string", new String[]{"timestamp"});
        this.addPushDownFunction(IMPALA, "to_utc_timestamp", "timestamp", new String[]{"timestamp", "string"});
        this.addPushDownFunction(IMPALA, "trunc", "timestamp", new String[]{"timestamp", "string"});
        this.addPushDownFunction(IMPALA, "unix_timestamp", "integer", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "unix_timestamp", "integer", new String[]{"string", "string"});
        this.addPushDownFunction(IMPALA, "unix_timestamp", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(IMPALA, "weekofyear", "integer", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "weeks_add", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "weeks_add", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "weeks_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "weeks_sub", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "years_add", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "years_add", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "years_sub", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(IMPALA, "years_sub", "timestamp", new String[]{"timestamp", "long"});
        this.addPushDownFunction(IMPALA, "conv", "string", new String[]{"long", "integer", "integer"});
        this.addPushDownFunction(IMPALA, "greatest", "string", new String[]{"string", "string"});
        this.addPushDownFunction(IMPALA, "greatest", "timestamp", new String[]{"timestamp", "timestamp"});
        this.addPushDownFunction(IMPALA, "greatest", "long", new String[]{"long", "long"});
        this.addPushDownFunction(IMPALA, "least", "string", new String[]{"string", "string"});
        this.addPushDownFunction(IMPALA, "least", "timestamp", new String[]{"timestamp", "timestamp"});
        this.addPushDownFunction(IMPALA, "least", "long", new String[]{"long", "long"});
        this.addPushDownFunction(IMPALA, "log2", "string", new String[]{"double"});
        this.addPushDownFunction(IMPALA, "pow", "double", new String[]{"double"});
        this.addPushDownFunction(IMPALA, "quotient", "integer", new String[]{"integer", "integer"});
        this.addPushDownFunction(IMPALA, "radians", "double", new String[]{"double"});
        this.addPushDownFunction(IMPALA, "sign", "integer", new String[]{"double"});
        this.addPushDownFunction(IMPALA, "parse_url", "string", new String[]{"string", "string"});
        this.addPushDownFunction(IMPALA, "regexp_extract", "string", new String[]{"string", "string", "integer"});
        this.addPushDownFunction(IMPALA, "regexp_replace", "string", new String[]{"string", "string", "string"});
        this.addPushDownFunction(IMPALA, "group_concat", "string", new String[]{"string", "string"}).setAggregateAttributes(new AggregateAttributes());
        this.addPushDownFunction(IMPALA, "concat_ws", "string", new String[]{"string", "string"}).setVarArgs(true);
        this.addPushDownFunction(IMPALA, "concat", "string", new String[]{"string"}).setVarArgs(true);
        this.addPushDownFunction(IMPALA, "initcap", "string", new String[]{"string"});
        this.addPushDownFunction(IMPALA, "instr", "integer", new String[]{"string", "string"});
        this.addPushDownFunction(IMPALA, "find_in_set", "integer", new String[]{"string", "string"});
    }

    public void initCapabilities(Connection connection) throws TranslatorException {
        super.initCapabilities(connection);
        if (this.getVersion().compareTo(TWO_0) >= 0) {
            this.convert.addTypeMapping("decimal", new int[]{10});
            this.convert.addTypeMapping("char(1)", new int[]{1});
            this.convert.addTypeMapping("varchar", new int[]{0});
        }
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("ascii");
        supportedFunctions.add("atan");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("concat");
        supportedFunctions.add("cos");
        supportedFunctions.add("convert");
        supportedFunctions.add("curdate");
        supportedFunctions.add("degrees");
        supportedFunctions.add("dayname");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofweek");
        if (this.getVersion().compareTo(TWO_2) >= 0) {
            supportedFunctions.add("from_unixtime");
            supportedFunctions.add("unix_timestamp");
        }
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("hour");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("lcase");
        supportedFunctions.add("lpad");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("minute");
        supportedFunctions.add("mod");
        supportedFunctions.add("month");
        supportedFunctions.add("now");
        supportedFunctions.add("power");
        supportedFunctions.add("pi");
        supportedFunctions.add("radians");
        supportedFunctions.add("rand");
        supportedFunctions.add("repeat");
        supportedFunctions.add("round");
        supportedFunctions.add("rpad");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("second");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("substring");
        supportedFunctions.add("tan");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        supportedFunctions.add("year");
        return supportedFunctions;
    }

    @Override
    public boolean supportsCommonTableExpressions() {
        return true;
    }

    public boolean supportsElementaryOlapOperations() {
        return this.getVersion().compareTo(TWO_0) >= 0;
    }

    @Override
    public boolean supportsHaving() {
        return true;
    }

    @Override
    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return this.getVersion().compareTo(ONE_2_1) >= 0;
    }

    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.HIGH;
    }

    public boolean supportsOrderByNullOrdering() {
        return true;
    }

    public ExecutionFactory.SupportedJoinCriteria getSupportedJoinCriteria() {
        return ExecutionFactory.SupportedJoinCriteria.ANY;
    }

    @Override
    public boolean requiresLeftLinearJoin() {
        return true;
    }

    @Override
    public List<?> translateCommand(Command command, ExecutionContext context) {
        if (command instanceof Select) {
            Select select = (Select)command;
            if (select.getLimit() != null && select.getLimit().getRowOffset() != 0 && select.getOrderBy() == null) {
                select.setOrderBy(new OrderBy(Arrays.asList(new SortSpecification(SortSpecification.Ordering.ASC, (Expression)new Literal((Object)1, DataTypeManager.DefaultDataClasses.INTEGER)))));
            }
            if (select.getGroupBy() == null && select.getHaving() == null) {
                boolean rewrite = false;
                String distinctVal = null;
                for (DerivedColumn col : select.getDerivedColumns()) {
                    if (!(col.getExpression() instanceof AggregateFunction) || !((AggregateFunction)col.getExpression()).isDistinct()) continue;
                    if (distinctVal == null) {
                        distinctVal = ((AggregateFunction)col.getExpression()).getParameters().toString();
                        continue;
                    }
                    if (((AggregateFunction)col.getExpression()).getParameters().toString().equals(distinctVal)) continue;
                    rewrite = true;
                    break;
                }
                if (rewrite) {
                    Select top = new Select();
                    top.setWith(select.getWith());
                    top.setDerivedColumns(new ArrayList());
                    top.setFrom(new ArrayList());
                    Select viewSelect = new Select();
                    viewSelect.setFrom(select.getFrom());
                    viewSelect.setDerivedColumns(new ArrayList());
                    viewSelect.setWhere(select.getWhere());
                    distinctVal = null;
                    int viewCount = 0;
                    NamedTable view = new NamedTable("v" + viewCount++, null, null);
                    for (int i = 0; i < select.getDerivedColumns().size(); ++i) {
                        DerivedColumn col = (DerivedColumn)select.getDerivedColumns().get(i);
                        if (col.getExpression() instanceof AggregateFunction && ((AggregateFunction)col.getExpression()).isDistinct()) {
                            if (distinctVal == null) {
                                distinctVal = ((AggregateFunction)col.getExpression()).getParameters().toString();
                            } else if (!((AggregateFunction)col.getExpression()).getParameters().toString().equals(distinctVal)) {
                                DerivedTable dt = new DerivedTable((QueryExpression)viewSelect, view.getName());
                                if (top.getFrom().isEmpty()) {
                                    top.getFrom().add(dt);
                                } else {
                                    Join join = new Join((TableReference)top.getFrom().remove(0), (TableReference)dt, Join.JoinType.CROSS_JOIN, null);
                                    top.getFrom().add(join);
                                }
                                view = new NamedTable("v" + viewCount++, null, null);
                                viewSelect = new Select();
                                viewSelect.setFrom(select.getFrom());
                                viewSelect.setDerivedColumns(new ArrayList());
                                viewSelect.setWhere(select.getWhere());
                                distinctVal = ((AggregateFunction)col.getExpression()).getParameters().toString();
                            }
                        }
                        col.setAlias("c" + i);
                        top.getDerivedColumns().add(new DerivedColumn(null, (Expression)new ColumnReference(view, col.getAlias(), null, col.getExpression().getType())));
                        viewSelect.getDerivedColumns().add(col);
                    }
                    DerivedTable dt = new DerivedTable((QueryExpression)viewSelect, view.getName());
                    Join join = new Join((TableReference)top.getFrom().remove(0), (TableReference)dt, Join.JoinType.CROSS_JOIN, null);
                    top.getFrom().add(join);
                    return Arrays.asList(top);
                }
            }
        }
        return super.translateCommand(command, context);
    }

    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        if (obj instanceof WithItem) {
            WithItem item = (WithItem)obj;
            List cols = item.getColumns();
            item.setColumns(null);
            Select select = item.getSubquery().getProjectedQuery();
            List selectClause = select.getDerivedColumns();
            for (int i = 0; i < cols.size(); ++i) {
                ((DerivedColumn)selectClause.get(i)).setAlias(((ColumnReference)cols.get(i)).getName());
            }
        }
        return super.translate(obj, context);
    }

    protected boolean usesDatabaseVersion() {
        return true;
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        if (limit.getRowOffset() > 0) {
            return Arrays.asList("LIMIT ", limit.getRowLimit(), " OFFSET ", limit.getRowOffset());
        }
        return null;
    }

    public String translateLiteralDate(Date dateValue) {
        return '\'' + this.formatDateValue(dateValue) + '\'';
    }

    public boolean supportsGroupByMultipleDistinctAggregates() {
        return false;
    }

    public boolean supportsStringAgg() {
        return true;
    }
}

