/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.hive;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Function;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.hive.BaseHiveExecutionFactory;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.ModFunctionModifier;
import org.teiid.util.Version;

@Translator(name="hive", description="A translator for hive based database on HDFS")
public class HiveExecutionFactory
extends BaseHiveExecutionFactory {
    public static final Version V_3 = Version.getVersion((String)"3.0");
    public static String HIVE = "hive";

    public HiveExecutionFactory() {
        this.setSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria.EQUI);
        this.setSupportsOrderBy(false);
    }

    public void start() throws TranslatorException {
        super.start();
        this.convert.addTypeMapping("tinyint", new int[]{3});
        this.convert.addTypeMapping("smallint", new int[]{4});
        this.convert.addTypeMapping("int", new int[]{5});
        this.convert.addTypeMapping("bigint", new int[]{7, 6});
        this.convert.addTypeMapping("boolean", new int[]{2});
        this.convert.addTypeMapping("double", new int[]{9});
        this.convert.addTypeMapping("float", new int[]{8});
        this.convert.addTypeMapping("string", new int[]{0});
        this.convert.addTypeMapping("timestamp", new int[]{13});
        this.convert.addTypeMapping("binary", new int[]{15, 19});
        this.convert.addTypeMapping("decimal", new int[]{10});
        this.convert.addTypeMapping("date", new int[]{11});
        this.registerFunctionModifier("convert", (FunctionModifier)this.convert);
        this.registerFunctionModifier("bitand", (FunctionModifier)new AliasModifier("&"));
        this.registerFunctionModifier("bitnot", (FunctionModifier)new AliasModifier("~"));
        this.registerFunctionModifier("bitor", (FunctionModifier)new AliasModifier("|"));
        this.registerFunctionModifier("bitxor", (FunctionModifier)new AliasModifier("^"));
        this.registerFunctionModifier("curdate", (FunctionModifier)new AliasModifier("unix_timestamp"));
        this.registerFunctionModifier("ifnull", (FunctionModifier)new AliasModifier("coalesce"));
        this.registerFunctionModifier("mod", (FunctionModifier)new ModFunctionModifier("%", this.getLanguageFactory(), Arrays.asList(TypeFacility.RUNTIME_TYPES.BIG_INTEGER, TypeFacility.RUNTIME_TYPES.BIG_DECIMAL)));
        this.registerFunctionModifier("array_get", new FunctionModifier(){

            public List<?> translate(Function function) {
                return Arrays.asList(function.getParameters().get(0), Character.valueOf('['), function.getParameters().get(1), Character.valueOf(']'));
            }
        });
        this.addPushDownFunction(HIVE, "lower", "string", new String[]{"string"});
        this.addPushDownFunction(HIVE, "upper", "string", new String[]{"string"});
        this.addPushDownFunction(HIVE, "positive", "integer", new String[]{"double"});
        this.addPushDownFunction(HIVE, "positive", "double", new String[]{"double"});
        this.addPushDownFunction(HIVE, "negitive", "integer", new String[]{"double"});
        this.addPushDownFunction(HIVE, "negitive", "double", new String[]{"double"});
        this.addPushDownFunction(HIVE, "ln", "double", new String[]{"double"});
        this.addPushDownFunction(HIVE, "reverse", "string", new String[]{"string"});
        this.addPushDownFunction(HIVE, "space", "integer", new String[]{"string"});
        this.addPushDownFunction(HIVE, "split", "object", new String[]{"string", "string"});
        this.addPushDownFunction(HIVE, "hex", "string", new String[]{"string"});
        this.addPushDownFunction(HIVE, "unhex", "string", new String[]{"string"});
        this.addPushDownFunction(HIVE, "bin", "string", new String[]{"long"});
        this.addPushDownFunction(HIVE, "day", "integer", new String[]{"date"});
        this.addPushDownFunction(HIVE, "datediff", "integer", new String[]{"string", "string"});
        this.addPushDownFunction(HIVE, "date_add", "integer", new String[]{"string", "integer"});
        this.addPushDownFunction(HIVE, "date_sub", "integer", new String[]{"string", "integer"});
        this.addPushDownFunction(HIVE, "from_unixtime", "string", new String[]{"long"});
        this.addPushDownFunction(HIVE, "from_unixtime", "string", new String[]{"long", "string"});
        this.addPushDownFunction(HIVE, "unix_timestamp", "long", new String[]{"string"});
        this.addPushDownFunction(HIVE, "unix_timestamp", "long", new String[]{"string", "string"});
        this.addPushDownFunction(HIVE, "to_date", "string", new String[]{"string"});
        this.addPushDownFunction(HIVE, "from_utc_timestamp", "timestamp", new String[]{"timestamp", "string"});
        this.addPushDownFunction(HIVE, "to_utc_timestamp", "timestamp", new String[]{"timestamp", "string"});
        this.addAggregatePushDownFunction(HIVE, "LEAD", "object", "object");
        this.addAggregatePushDownFunction(HIVE, "LEAD", "object", "object", "integer");
        this.addAggregatePushDownFunction(HIVE, "LEAD", "object", "object", "integer", "object");
        this.addAggregatePushDownFunction(HIVE, "LAG", "object", "object");
        this.addAggregatePushDownFunction(HIVE, "LAG", "object", "object", "integer");
        this.addAggregatePushDownFunction(HIVE, "LAG", "object", "object", "integer", "object");
        this.addAggregatePushDownFunction(HIVE, "FIRST_VALUE", "object", "object");
        this.addAggregatePushDownFunction(HIVE, "LAST_VALUE", "object", "object");
        this.addAggregatePushDownFunction(HIVE, "PERCENT_RANK", "float", new String[0]);
        this.addAggregatePushDownFunction(HIVE, "CUME_DIST", "float", new String[0]);
        this.addAggregatePushDownFunction(HIVE, "NTILE", "long", "integer");
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("array_get");
        supportedFunctions.add("asin");
        supportedFunctions.add("ascii");
        supportedFunctions.add("atan");
        supportedFunctions.add("bitand");
        supportedFunctions.add("bitnot");
        supportedFunctions.add("bitor");
        supportedFunctions.add("bitxor");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("concat");
        supportedFunctions.add("cos");
        supportedFunctions.add("convert");
        supportedFunctions.add("curdate");
        supportedFunctions.add("curtime");
        supportedFunctions.add("degrees");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("from_unixtime");
        supportedFunctions.add("unix_timestamp");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("hour");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("lcase");
        supportedFunctions.add("locate");
        supportedFunctions.add("lpad");
        supportedFunctions.add("length");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("minute");
        supportedFunctions.add("mod");
        supportedFunctions.add("power");
        supportedFunctions.add("second");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("radians");
        supportedFunctions.add("round");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("rpad");
        supportedFunctions.add("month");
        supportedFunctions.add("pi");
        supportedFunctions.add("sin");
        supportedFunctions.add("substring");
        supportedFunctions.add("tan");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        supportedFunctions.add("year");
        return supportedFunctions;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public boolean supportsElementaryOlapOperations() {
        return true;
    }

    public boolean supportsGroupByRollup() {
        return true;
    }

    public ExecutionFactory.SupportedJoinCriteria getSupportedJoinCriteria() {
        return ExecutionFactory.SupportedJoinCriteria.EQUI;
    }

    public boolean useParensForJoins() {
        return false;
    }

    public String translateLiteralDate(Date dateValue) {
        return "DATE '" + this.formatDateValue(dateValue) + '\'';
    }

    @Override
    public boolean requiresLeftLinearJoin() {
        return true;
    }

    public boolean supportsIsDistinctCriteria() {
        return this.getVersion().compareTo(V_3) >= 0;
    }

    protected boolean usesDatabaseVersion() {
        return true;
    }
}

