/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.hive;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.cdk.CommandBuilder;
import org.teiid.language.Command;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.hive.HiveExecutionFactory;
import org.teiid.translator.hive.HiveMetadataProcessor;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.TranslatedCommand;

public class TestHiveExecutionFactory {
    private static HiveExecutionFactory hiveTranslator;
    private static final LanguageFactory LANG_FACTORY;
    private static TransformationMetadata bqt;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        hiveTranslator = new HiveExecutionFactory();
        hiveTranslator.setUseBindVariables(false);
        hiveTranslator.start();
        bqt = TestHiveExecutionFactory.exampleBQT();
    }

    private void helpTest(Expression srcExpression, String tgtType, String expectedExpression) throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", Arrays.asList(srcExpression, LANG_FACTORY.createLiteral((Object)tgtType, String.class)), TypeFacility.getDataTypeClass((String)tgtType));
        SQLConversionVisitor sqlVisitor = hiveTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)func);
        Assert.assertEquals((String)("Error converting from " + srcExpression.getType() + " to " + tgtType), (Object)expectedExpression, (Object)sqlVisitor.toString());
    }

    private void helpTestVisitor(QueryMetadataInterface metadata, String input, String expectedOutput) throws TranslatorException {
        CommandBuilder commandBuilder = new CommandBuilder(metadata);
        Command obj = commandBuilder.getCommand(input);
        TranslatedCommand tc = new TranslatedCommand((ExecutionContext)Mockito.mock(ExecutionContext.class), (JDBCExecutionFactory)hiveTranslator);
        tc.translateCommand(obj);
        Assert.assertEquals((String)"Did not get correct sql", (Object)expectedOutput, (Object)tc.getSql());
    }

    @Test
    public void testConvertions() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "boolean", "cast(true AS boolean)");
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Byte.parseByte("123"), Byte.class), "byte", "cast(123 AS tinyint)");
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(12345), Integer.class), "integer", "cast(12345 AS int)");
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Short.parseShort("1234"), Short.class), "short", "cast(1234 AS smallint)");
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("123451266182"), BigInteger.class), "biginteger", "cast(123451266182 AS bigint)");
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new String("foo-bar"), String.class), "string", "cast('foo-bar' AS string)");
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "string", "cast(true AS string)");
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(12345), Integer.class), "boolean", "cast(12345 AS boolean)");
    }

    @Test
    public void testFunction() throws Exception {
        String input = "SELECT MOD(A.intkey,2) FROM BQT1.SMALLA A";
        String output = "SELECT (A.IntKey % 2) FROM SmallA A";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testTimeLiterals() throws Exception {
        String input = "SELECT {ts '1999-01-01 11:11:11'}, {d '2000-02-02'}, {t '00:00:00'} FROM BQT1.SMALLA A";
        String output = "SELECT cast('1999-01-01 11:11:11.0' as timestamp), DATE '2000-02-02', cast('1970-01-01 00:00:00.0' as timestamp) FROM SmallA A";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testTimeLiteralsINClause() throws Exception {
        String input = "SELECT intkey FROM BQT1.SMALLA A WHERE A.TimestampValue IN ({ts '1999-01-01 11:11:11'},{ts '1999-02-22 22:22:22'})";
        String output = "SELECT A.IntKey FROM SmallA A WHERE A.TimestampValue IN (cast('1999-01-01 11:11:11.0' as timestamp), cast('1999-02-22 22:22:22.0' as timestamp))";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
        input = "SELECT intkey FROM BQT1.SMALLA A WHERE A.DateValue IN ({d '1999-01-01'}, {d '1999-02-22'})";
        output = "SELECT A.IntKey FROM SmallA A WHERE A.DateValue IN (DATE '1999-01-01', DATE '1999-02-22')";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
        input = "SELECT intkey FROM BQT1.SMALLA A WHERE A.DateValue IN (convert('1999-01-01',date), convert('1999-02-22', date))";
        output = "SELECT A.IntKey FROM SmallA A WHERE A.DateValue IN (DATE '1999-01-01', DATE '1999-02-22')";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testEqualityJoinCriteria() throws Exception {
        String input = "SELECT A.intkey FROM BQT1.SMALLA A JOIN BQT1.SmallB B on A.intkey=B.intkey";
        String output = "SELECT A.IntKey FROM SmallA A  JOIN SmallB B ON A.IntKey = B.IntKey";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testFourWayJoin() throws Exception {
        String input = "SELECT A.intkey FROM BQT1.SMALLA A JOIN BQT1.SmallB B on A.intkey=B.intkey JOIN BQT1.SMALLA C on A.intkey=C.intkey JOIN BQT1.SMALLB D on A.intkey=D.intkey";
        String output = "SELECT A.IntKey FROM SmallA A  JOIN SmallB B ON A.IntKey = B.IntKey  JOIN SmallA C ON A.IntKey = C.IntKey  JOIN SmallB D ON A.IntKey = D.IntKey";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testThreeWayJoin() throws Exception {
        String input = "SELECT A.intkey FROM BQT1.SMALLA A JOIN BQT1.SmallB B on A.intkey=B.intkey JOIN BQT1.SMALLA C on A.intkey=C.intkey";
        String output = "SELECT A.IntKey FROM SmallA A  JOIN SmallB B ON A.IntKey = B.IntKey  JOIN SmallA C ON A.IntKey = C.IntKey";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testCrossJoinCriteria() throws Exception {
        String input = "SELECT A.intkey FROM BQT1.SMALLA A Cross join BQT1.SmallB B";
        String output = "SELECT A.IntKey FROM SmallA A CROSS JOIN SmallB B";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testMustHaveAliasOnView() throws Exception {
        String input = "SELECT intkey FROM (select intkey from BQT1.SmallA) as X";
        String output = "SELECT X.intkey FROM (SELECT SmallA.IntKey FROM SmallA) X";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testUnionAllRewrite() throws Exception {
        String input = "SELECT intkey, stringkey FROM BQT1.SmallA union all SELECT intkey, stringkey FROM BQT1.Smallb";
        String output = "SELECT intkey, stringkey FROM (SELECT SmallA.IntKey, SmallA.StringKey FROM SmallA UNION ALL SELECT SmallB.IntKey, SmallB.StringKey FROM SmallB) X__";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testUnionAllRewriteNested() throws Exception {
        String input = "SELECT intkey, stringkey FROM BQT1.SmallA union all SELECT intkey, stringkey FROM BQT1.Smallb union all SELECT intkey, stringkey FROM BQT1.Smallb";
        String output = "SELECT intkey, stringkey FROM (SELECT SmallA.IntKey, SmallA.StringKey FROM SmallA UNION ALL SELECT SmallB.IntKey, SmallB.StringKey FROM SmallB UNION ALL SELECT SmallB.IntKey, SmallB.StringKey FROM SmallB) X__";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testUnionAllRewriteNested1() throws Exception {
        String input = "SELECT intkey, stringkey FROM BQT1.SmallA union all (SELECT intkey, stringkey FROM BQT1.Smallb union SELECT intkey, stringkey FROM BQT1.Smallb)";
        String output = "SELECT intkey, stringkey FROM (SELECT SmallA.IntKey, SmallA.StringKey FROM SmallA UNION ALL (SELECT DISTINCT intkey, stringkey FROM (SELECT SmallB.IntKey, SmallB.StringKey FROM SmallB UNION ALL SELECT SmallB.IntKey, SmallB.StringKey FROM SmallB) X__)) X__";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testUnionAllExprRewrite() throws Exception {
        String input = "SELECT count(*) as key, stringkey FROM BQT1.SmallA union all SELECT intkey, stringkey FROM BQT1.Smallb";
        String output = "SELECT key, stringkey FROM (SELECT COUNT(*) AS key, SmallA.StringKey FROM SmallA UNION ALL SELECT SmallB.IntKey, SmallB.StringKey FROM SmallB) X__";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testUnionRewrite() throws Exception {
        String input = "SELECT intkey, stringkey FROM BQT1.SmallA union SELECT intkey, stringkey FROM BQT1.Smallb";
        String output = "SELECT DISTINCT intkey, stringkey FROM (SELECT SmallA.IntKey, SmallA.StringKey FROM SmallA UNION ALL SELECT SmallB.IntKey, SmallB.StringKey FROM SmallB) X__";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    @Test
    public void testGroupByOrderBy() throws Exception {
        String input = "SELECT intkey FROM BQT1.SmallA group by intkey order by intkey";
        String output = "SELECT SmallA.IntKey FROM SmallA GROUP BY SmallA.IntKey ORDER BY IntKey";
        this.helpTestVisitor((QueryMetadataInterface)bqt, input, output);
    }

    public static TransformationMetadata exampleBQT() {
        MetadataStore metadataStore = new MetadataStore();
        Schema bqt1 = RealMetadataFactory.createPhysicalModel((String)"BQT1", (MetadataStore)metadataStore);
        Table bqt1SmallA = RealMetadataFactory.createPhysicalGroup((String)"SmallA", (Schema)bqt1);
        Table bqt1SmallB = RealMetadataFactory.createPhysicalGroup((String)"SmallB", (Schema)bqt1);
        String[] elemNames = new String[]{"IntKey", "StringKey", "IntNum", "StringNum", "FloatNum", "LongNum", "DoubleNum", "ByteNum", "DateValue", "TimeValue", "TimestampValue", "BooleanValue", "CharValue", "ShortValue", "BigIntegerValue", "BigDecimalValue", "ObjectValue"};
        String[] nativeTypes = new String[]{"integer", "string", "integer", "string", "float", "biginteger", "double", "byte", "date", "string", "timestamp", "boolean", "string", "short", "biginteger", "biginteger", "string"};
        String[] runtimeTypes = new String[]{"integer", "string", "integer", "string", "float", "long", "double", "byte", "date", "time", "timestamp", "boolean", "char", "short", "biginteger", "bigdecimal", "object"};
        List bqt1SmallAe = RealMetadataFactory.createElements((ColumnSet)bqt1SmallA, (String[])elemNames, (String[])nativeTypes);
        List bqt1SmallBe = RealMetadataFactory.createElements((ColumnSet)bqt1SmallB, (String[])elemNames, (String[])nativeTypes);
        Schema vqt = RealMetadataFactory.createVirtualModel((String)"VQT", (MetadataStore)metadataStore);
        QueryNode vqtn1 = new QueryNode("SELECT * FROM BQT1.SmallA");
        Table vqtg1 = RealMetadataFactory.createUpdatableVirtualGroup((String)"SmallA", (Schema)vqt, (QueryNode)vqtn1);
        RealMetadataFactory.createElements((ColumnSet)vqtg1, (String[])elemNames, (String[])runtimeTypes);
        return RealMetadataFactory.createTransformationMetadata((MetadataStore)metadataStore, (String)"bqt", (FunctionTree[])new FunctionTree[0]);
    }

    @Test
    public void testExcludeTables() throws Exception {
        HiveMetadataProcessor hmp = new HiveMetadataProcessor();
        hmp.setExcludeTables("x");
        Connection c = (Connection)Mockito.mock(Connection.class);
        MetadataFactory mf = (MetadataFactory)Mockito.mock(MetadataFactory.class);
        Statement stmt = (Statement)Mockito.mock(Statement.class);
        Mockito.stub((Object)c.createStatement()).toReturn((Object)stmt);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.stub((Object)stmt.executeQuery("SHOW TABLES")).toReturn((Object)rs);
        Mockito.stub((Object)rs.next()).toReturn((Object)true).toReturn((Object)false);
        Mockito.stub((Object)rs.getString(1)).toReturn((Object)"x");
        hmp.process(mf, c);
        ((MetadataFactory)Mockito.verify((Object)mf, (VerificationMode)Mockito.times((int)0))).addTable("x");
    }

    @Test
    public void testQuoting() throws Exception {
        HiveMetadataProcessor hmp = new HiveMetadataProcessor();
        Connection c = (Connection)Mockito.mock(Connection.class);
        MetadataFactory mf = (MetadataFactory)Mockito.mock(MetadataFactory.class);
        Table table = new Table();
        Mockito.stub((Object)mf.addTable("x")).toReturn((Object)table);
        Column col = new Column();
        col.setName("y");
        Mockito.stub((Object)mf.addColumn("y", "string", (ColumnSet)table)).toReturn((Object)col);
        Statement stmt = (Statement)Mockito.mock(Statement.class);
        Mockito.stub((Object)c.createStatement()).toReturn((Object)stmt);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.stub((Object)stmt.executeQuery("SHOW TABLES")).toReturn((Object)rs);
        Mockito.stub((Object)rs.next()).toReturn((Object)true).toReturn((Object)false);
        Mockito.stub((Object)rs.getString(1)).toReturn((Object)"x");
        ResultSet rs1 = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.stub((Object)stmt.executeQuery("DESCRIBE x")).toReturn((Object)rs1);
        Mockito.stub((Object)rs1.next()).toReturn((Object)true).toReturn((Object)false);
        Mockito.stub((Object)rs1.getString(1)).toReturn((Object)"y");
        Mockito.stub((Object)rs1.getString(2)).toReturn((Object)"string");
        hmp.process(mf, c);
        Assert.assertEquals((Object)"`x`", (Object)table.getNameInSource());
        Assert.assertEquals((Object)"`y`", (Object)col.getNameInSource());
    }

    @Test
    public void testStringLiteral() {
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Command obj = commandBuilder.getCommand("select pm1.g1.e2 from pm1.g1 where pm1.g1.e1 = 'a''b\\c'");
        SQLConversionVisitor sqlVisitor = hiveTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT g1.e2 FROM g1 WHERE g1.e1 = 'a\\'b\\\\c'", (Object)sqlVisitor.toString());
    }

    static {
        LANG_FACTORY = new LanguageFactory();
    }
}

