/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.hive;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.cdk.CommandBuilder;
import org.teiid.language.Command;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.Select;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.hive.ImpalaExecutionFactory;
import org.teiid.translator.hive.TestHiveExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.TranslationHelper;

public class TestImpalaExecutionFactory {
    private static ImpalaExecutionFactory impalaTranslator;
    private static final LanguageFactory LANG_FACTORY;
    private static TransformationMetadata bqt;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        impalaTranslator = new ImpalaExecutionFactory();
        impalaTranslator.setUseBindVariables(false);
        impalaTranslator.start();
        bqt = TestHiveExecutionFactory.exampleBQT();
    }

    private void helpTest(Expression srcExpression, String tgtType, String expectedExpression) throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", Arrays.asList(srcExpression, LANG_FACTORY.createLiteral((Object)tgtType, String.class)), TypeFacility.getDataTypeClass((String)tgtType));
        SQLConversionVisitor sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)func);
        Assert.assertEquals((String)("Error converting from " + srcExpression.getType() + " to " + tgtType), (Object)expectedExpression, (Object)sqlVisitor.toString());
    }

    @Test
    public void testConvertions() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(12345), Integer.class), "double", "cast(12345 AS double)");
    }

    @Test
    public void testConversionSupport() {
        Assert.assertFalse((boolean)impalaTranslator.supportsConvert(13, 12));
        Assert.assertTrue((boolean)impalaTranslator.supportsConvert(0, 13));
    }

    @Test
    public void testJoin() {
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Command obj = commandBuilder.getCommand("select pm1.g1.e1 from pm1.g1 inner join pm1.g2 inner join pm1.g3 on pm1.g2.e2 = pm1.g3.e2 on pm1.g1.e1 = pm1.g2.e1");
        SQLConversionVisitor sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT g1.e1 FROM g2  JOIN g3 ON g2.e2 = g3.e2  JOIN g1 ON g1.e1 = g2.e1", (Object)sqlVisitor.toString());
    }

    @Test
    public void testStringLiteral() {
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Command obj = commandBuilder.getCommand("select pm1.g1.e2 from pm1.g1 where pm1.g1.e1 = 'a''b\\c'");
        SQLConversionVisitor sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT g1.e2 FROM g1 WHERE g1.e1 = 'a\\'b\\\\c'", (Object)sqlVisitor.toString());
    }

    @Test
    public void testMultipleDistinctAggregates() {
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Command obj = commandBuilder.getCommand("select count(distinct pm1.g1.e1), 1, count(distinct pm1.g1.e2), avg(distinct pm1.g1.e4) from pm1.g1");
        SQLConversionVisitor sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT v0.c0, v0.c1, v1.c2, v2.c3 FROM (SELECT COUNT(DISTINCT g1.e1) AS c0, 1 AS c1 FROM g1) v0 CROSS JOIN (SELECT COUNT(DISTINCT g1.e2) AS c2 FROM g1) v1 CROSS JOIN (SELECT AVG(DISTINCT g1.e4) AS c3 FROM g1) v2", (Object)sqlVisitor.toString());
        obj = commandBuilder.getCommand("select count(distinct pm1.g1.e1), 1, count(distinct pm1.g1.e2), avg(distinct pm1.g1.e4) from pm1.g1 where pm1.g1.e3 = true");
        sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT v0.c0, v0.c1, v1.c2, v2.c3 FROM (SELECT COUNT(DISTINCT g1.e1) AS c0, 1 AS c1 FROM g1 WHERE g1.e3 = true) v0 CROSS JOIN (SELECT COUNT(DISTINCT g1.e2) AS c2 FROM g1 WHERE g1.e3 = true) v1 CROSS JOIN (SELECT AVG(DISTINCT g1.e4) AS c3 FROM g1 WHERE g1.e3 = true) v2", (Object)sqlVisitor.toString());
    }

    @Test
    public void testOffset() {
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Command obj = commandBuilder.getCommand("select pm1.g1.e2 from pm1.g1 limit 1, 2");
        SQLConversionVisitor sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT g1.e2 FROM g1 ORDER BY 1 LIMIT 2 OFFSET 1", (Object)sqlVisitor.toString());
        obj = commandBuilder.getCommand("select pm1.g1.e2, pm1.g1.e1 from pm1.g1 order by e1 limit 1, 100");
        sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT g1.e2, g1.e1 FROM g1 ORDER BY e1 LIMIT 100 OFFSET 1", (Object)sqlVisitor.toString());
    }

    @Test
    public void testOrderedUnion() {
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand("SELECT g_1.StringNum AS c_0 FROM bqt1.SmallA AS g_1 WHERE g_1.IntKey <= 50 UNION ALL SELECT g_0.StringNum AS c_0 FROM bqt1.SmallB AS g_0 WHERE g_0.IntKey > 50 ORDER BY c_0 limit 10");
        SQLConversionVisitor sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT c_0 FROM (SELECT g_1.StringNum AS c_0 FROM SmallA g_1 WHERE g_1.IntKey <= 50 UNION ALL SELECT g_0.StringNum AS c_0 FROM SmallB g_0 WHERE g_0.IntKey > 50) X__ ORDER BY c_0 LIMIT 10", (Object)sqlVisitor.toString());
    }

    @Test
    public void testDistinctAggregate() {
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand("SELECT distinct max(StringNum) FROM bqt1.SmallA group by stringkey");
        SQLConversionVisitor sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT DISTINCT c_0 FROM (SELECT MAX(SmallA.StringNum) AS c_0 FROM SmallA GROUP BY SmallA.StringKey) X__", (Object)sqlVisitor.toString());
    }

    @Test
    public void testWith() {
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Select obj = (Select)commandBuilder.getCommand("with x as /*+ no_inline */ (SELECT max(StringNum) as a FROM bqt1.SmallA group by stringkey) select * from x");
        SQLConversionVisitor sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"WITH x AS (SELECT MAX(SmallA.StringNum) AS a FROM SmallA GROUP BY SmallA.StringKey) SELECT x.a FROM x", (Object)sqlVisitor.toString());
    }

    @Test
    public void testPredicateFunctions() {
        Select obj = (Select)TranslationHelper.helpTranslate((String)"/bqt.vdb", (List)impalaTranslator.getPushDownFunctions(), (String)"select stringnum FROM bqt1.SmallA where ilike(stringkey, 'a_') and not(ilike(stringkey, '_b'))");
        SQLConversionVisitor sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT SmallA.StringNum FROM SmallA WHERE (SmallA.StringKey ilike 'a_') AND NOT((SmallA.StringKey ilike '_b'))", (Object)sqlVisitor.toString());
    }

    @Test
    public void testLikeRegex() {
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Select obj = (Select)commandBuilder.getCommand("SELECT max(StringNum) as a FROM bqt1.SmallA where stringkey like_regex '^[1-9]$'");
        SQLConversionVisitor sqlVisitor = impalaTranslator.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)obj);
        Assert.assertEquals((Object)"SELECT MAX(SmallA.StringNum) AS a FROM SmallA WHERE SmallA.StringKey REGEXP '^[1-9]$'", (Object)sqlVisitor.toString());
    }

    static {
        LANG_FACTORY = new LanguageFactory();
    }
}

