/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.hive;

import java.util.List;
import org.teiid.core.util.StringUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.OrderBy;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.SetQuery;
import org.teiid.language.SortSpecification;
import org.teiid.language.TableReference;
import org.teiid.language.WindowFrame;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.hive.BaseHiveExecutionFactory;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;

public class HiveSQLConversionVisitor
extends SQLConversionVisitor {
    BaseHiveExecutionFactory baseHiveExecutionFactory;

    public HiveSQLConversionVisitor(BaseHiveExecutionFactory hef) {
        super((JDBCExecutionFactory)hef);
        this.baseHiveExecutionFactory = hef;
    }

    public void visit(Join obj) {
        TableReference leftItem = obj.getLeftItem();
        TableReference rightItem = obj.getRightItem();
        Join.JoinType joinType = obj.getJoinType();
        if (this.baseHiveExecutionFactory.requiresLeftLinearJoin() && rightItem instanceof Join) {
            if (leftItem instanceof Join) {
                throw new AssertionError((Object)("A left linear join structure is required: " + obj));
            }
            TableReference tr = leftItem;
            leftItem = rightItem;
            rightItem = tr;
            if (joinType == Join.JoinType.RIGHT_OUTER_JOIN) {
                joinType = Join.JoinType.LEFT_OUTER_JOIN;
            } else if (joinType == Join.JoinType.LEFT_OUTER_JOIN) {
                joinType = Join.JoinType.RIGHT_OUTER_JOIN;
            }
        }
        if (this.useParensForJoins() && leftItem instanceof Join) {
            this.buffer.append("(");
            this.append((LanguageObject)leftItem);
            this.buffer.append(")");
        } else {
            this.append((LanguageObject)leftItem);
        }
        this.buffer.append(" ");
        switch (joinType) {
            case CROSS_JOIN: {
                this.buffer.append("CROSS");
                break;
            }
            case FULL_OUTER_JOIN: {
                this.buffer.append("FULL").append(" ").append("OUTER");
                break;
            }
            case INNER_JOIN: {
                break;
            }
            case LEFT_OUTER_JOIN: {
                this.buffer.append("LEFT").append(" ").append("OUTER");
                break;
            }
            case RIGHT_OUTER_JOIN: {
                this.buffer.append("RIGHT").append(" ").append("OUTER");
                break;
            }
            default: {
                this.buffer.append("<undefined>");
            }
        }
        this.buffer.append(" ").append("JOIN").append(" ");
        if (rightItem instanceof Join && (this.useParensForJoins() || obj.getJoinType() == Join.JoinType.CROSS_JOIN)) {
            this.buffer.append("(");
            this.append((LanguageObject)rightItem);
            this.buffer.append(")");
        } else {
            this.append((LanguageObject)rightItem);
        }
        Condition condition = obj.getCondition();
        if (condition != null) {
            this.buffer.append(" ").append("ON").append(" ");
            this.append((LanguageObject)condition);
        }
    }

    public void addColumns(List<DerivedColumn> items) {
        if (items != null && items.size() != 0) {
            this.addColumn(items.get(0));
            for (int i = 1; i < items.size(); ++i) {
                this.buffer.append(",").append(" ");
                this.addColumn(items.get(i));
            }
        }
    }

    private void addColumn(DerivedColumn dc) {
        if (dc.getAlias() != null) {
            this.buffer.append(dc.getAlias());
        } else {
            Expression expr = dc.getExpression();
            if (expr instanceof ColumnReference) {
                this.buffer.append(((ColumnReference)expr).getName());
            } else {
                this.append((LanguageObject)expr);
            }
        }
    }

    public void visit(SetQuery obj) {
        if (obj.getWith() != null) {
            this.append((LanguageObject)obj.getWith());
        }
        Select select = obj.getProjectedQuery();
        this.startInlineView(select, !obj.isAll());
        this.appendSetChild(obj, obj.getLeftQuery(), false);
        this.appendSetOp(obj);
        this.appendSetChild(obj, obj.getRightQuery(), true);
        this.endInlineView((QueryExpression)obj);
    }

    protected String getLikeRegexString() {
        return "REGEXP";
    }

    private void endInlineView(QueryExpression obj) {
        Limit limit;
        this.buffer.append(")");
        this.buffer.append(" ");
        this.buffer.append("X__");
        OrderBy orderBy = obj.getOrderBy();
        if (orderBy != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)orderBy);
        }
        if ((limit = obj.getLimit()) != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)limit);
        }
    }

    private void startInlineView(Select select, boolean distinct) {
        this.buffer.append("SELECT").append(" ");
        if (distinct) {
            this.buffer.append("DISTINCT").append(" ");
        }
        this.addColumns(select.getDerivedColumns());
        this.buffer.append(" ");
        this.buffer.append("FROM").append(" ");
        this.buffer.append("(");
    }

    private void appendSetOp(SetQuery obj) {
        this.buffer.append(" ");
        this.appendSetOperation(obj.getOperation());
        this.buffer.append(" ");
        this.buffer.append("ALL");
        this.buffer.append(" ");
    }

    private void appendSetChild(SetQuery obj, QueryExpression child, boolean right) {
        if (child instanceof Select || this.shouldNestSetChild(obj, child, right)) {
            this.appendSetQuery(obj, child, right);
        } else {
            SetQuery setQuery = (SetQuery)child;
            this.append((LanguageObject)setQuery.getLeftQuery());
            this.appendSetOp(setQuery);
            this.appendSetChild(setQuery, setQuery.getRightQuery(), true);
        }
    }

    public void visit(Select obj) {
        if (obj.getOrderBy() != null) {
            for (SortSpecification spec : obj.getOrderBy().getSortSpecifications()) {
                if (!(spec.getExpression() instanceof ColumnReference)) continue;
                ColumnReference cr = (ColumnReference)spec.getExpression();
                cr.setTable(null);
            }
        }
        if (obj.isDistinct() && obj.getGroupBy() != null) {
            if (obj.getWith() != null) {
                this.append((LanguageObject)obj.getWith());
            }
            if (obj.getOrderBy() == null) {
                DerivedColumn dc;
                int i;
                boolean needsAliasing = false;
                List derivedColumns = obj.getDerivedColumns();
                for (i = 0; i < derivedColumns.size(); ++i) {
                    dc = (DerivedColumn)derivedColumns.get(i);
                    if (dc.getAlias() != null) continue;
                    needsAliasing = true;
                    break;
                }
                if (needsAliasing) {
                    for (i = 0; i < derivedColumns.size(); ++i) {
                        dc = (DerivedColumn)derivedColumns.get(i);
                        dc.setAlias("c_" + i);
                    }
                }
            }
            this.startInlineView(obj, obj.isDistinct());
            obj.setDistinct(false);
            super.visit(obj);
            this.endInlineView((QueryExpression)obj);
            return;
        }
        super.visit(obj);
    }

    protected void translateSQLType(Class<?> type, Object obj, StringBuilder valuesbuffer) {
        if (obj != null && type == TypeFacility.RUNTIME_TYPES.STRING) {
            String val = obj.toString();
            valuesbuffer.append("'").append(StringUtil.replaceAll((String)StringUtil.replaceAll((String)val, (String)"\\", (String)"\\\\"), (String)"'", (String)"\\'")).append("'");
        } else {
            super.translateSQLType(type, obj, valuesbuffer);
        }
    }

    public void visit(Comparison obj) {
        if (this.baseHiveExecutionFactory.rewriteBooleanFunctions() && obj.getLeftExpression() instanceof Function && obj.getRightExpression() instanceof Literal && obj.getLeftExpression().getType() == TypeFacility.RUNTIME_TYPES.BOOLEAN) {
            Literal l = (Literal)obj.getRightExpression();
            Boolean val = (Boolean)l.getValue();
            Function leftExpression = (Function)obj.getLeftExpression();
            if (Boolean.FALSE.equals(val) && obj.getOperator() == Comparison.Operator.EQ || Boolean.TRUE.equals(val) && obj.getOperator() == Comparison.Operator.NE) {
                this.buffer.append("NOT");
                this.buffer.append("(");
                this.visit(leftExpression);
                this.buffer.append(")");
                return;
            }
            if (Boolean.TRUE.equals(val) && obj.getOperator() == Comparison.Operator.EQ || Boolean.FALSE.equals(val) && obj.getOperator() == Comparison.Operator.NE) {
                this.visit(leftExpression);
                return;
            }
        }
        super.visit(obj);
    }

    public void visit(WindowFrame windowFrame) {
        if (windowFrame.getEnd() == null) {
            windowFrame.setEnd(new WindowFrame.FrameBound(WindowFrame.BoundMode.CURRENT_ROW));
        }
        super.visit(windowFrame);
    }
}

