/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.LocateFunctionModifier;
import org.teiid.translator.jdbc.SQLConversionVisitor;

public class TestLocateFunctionModifier {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();

    public void helpTestLocate(Expression[] args, String expectedStr) throws Exception {
        this.helpTestLocate(LocateFunctionModifier.LOCATE, false, args, expectedStr);
    }

    public void helpTestLocate(final String locateFunctionName, final boolean parameterOrder, Expression[] args, String expectedStr) throws Exception {
        Expression param1 = null;
        Expression param2 = null;
        Expression param3 = null;
        if (args.length > 0) {
            param1 = args[0];
        }
        if (args.length > 1) {
            param2 = args[1];
        }
        if (args.length > 2) {
            param3 = args[2];
        }
        Function func = null;
        func = param3 != null ? LANG_FACTORY.createFunction("locate", Arrays.asList(param1, param2, param3), Integer.class) : LANG_FACTORY.createFunction("locate", Arrays.asList(param1, param2), Integer.class);
        JDBCExecutionFactory trans = new JDBCExecutionFactory(){

            public void start() throws TranslatorException {
                super.start();
                this.registerFunctionModifier("locate", (FunctionModifier)new LocateFunctionModifier(this.getLanguageFactory(), locateFunctionName, parameterOrder));
            }
        };
        trans.setUseBindVariables(false);
        trans.start();
        SQLConversionVisitor sqlVisitor = trans.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)func);
        Assert.assertEquals((String)"Modified function does not match", (Object)expectedStr, (Object)sqlVisitor.toString());
    }

    @Test
    public void testModifySimple() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a", String.class), LANG_FACTORY.createLiteral((Object)"abcdefg", String.class)};
        this.helpTestLocate(args, "LOCATE('a', 'abcdefg')");
    }

    @Test
    public void testModifySimple2() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a", String.class), LANG_FACTORY.createLiteral((Object)"abcdefg", String.class)};
        this.helpTestLocate("locate", false, args, "locate('a', 'abcdefg')");
    }

    @Test
    public void testModifySimple3() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a", String.class), LANG_FACTORY.createLiteral((Object)"abcdefg", String.class)};
        this.helpTestLocate("INSTR", true, args, "INSTR('abcdefg', 'a')");
    }

    @Test
    public void testModifySimple4() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a", String.class), LANG_FACTORY.createLiteral((Object)"abcdefg", String.class)};
        this.helpTestLocate("locate", false, args, "locate('a', 'abcdefg')");
    }

    @Test
    public void testModifyWithStartIndex() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a", String.class), LANG_FACTORY.createLiteral((Object)"abcdefg", String.class), LANG_FACTORY.createLiteral((Object)1, Integer.class)};
        this.helpTestLocate("INSTR", true, args, "INSTR('abcdefg', 'a', 1)");
    }

    @Test
    public void testModifyWithStartIndex2() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a", String.class), LANG_FACTORY.createLiteral((Object)"abcdefg", String.class), LANG_FACTORY.createLiteral((Object)4, Integer.class)};
        this.helpTestLocate(args, "LOCATE('a', 'abcdefg', 4)");
    }

    @Test
    public void testModifyWithStartIndex3() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a", String.class), LANG_FACTORY.createLiteral((Object)"abcdefg", String.class), LANG_FACTORY.createLiteral((Object)-5, Integer.class)};
        this.helpTestLocate(args, "LOCATE('a', 'abcdefg', 1)");
    }

    @Test
    public void testModifyWithStartIndex4() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a", String.class), LANG_FACTORY.createLiteral((Object)"abcdefg", String.class), LANG_FACTORY.createLiteral(null, Integer.class)};
        this.helpTestLocate(args, "LOCATE('a', 'abcdefg', NULL)");
    }

    @Test
    public void testModifyWithElementStartIndex() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a", String.class), LANG_FACTORY.createLiteral((Object)"abcdefg", String.class), LANG_FACTORY.createColumnReference("e1", null, null, Integer.class)};
        this.helpTestLocate("INSTR", true, args, "INSTR('abcdefg', 'a', CASE WHEN e1 < 1 THEN 1 ELSE e1 END)");
    }

    @Test
    public void testModifyWithElementStartIndex2() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a", String.class), LANG_FACTORY.createLiteral((Object)"abcdefg", String.class), LANG_FACTORY.createColumnReference("e1", null, null, Integer.class)};
        this.helpTestLocate(args, "LOCATE('a', 'abcdefg', CASE WHEN e1 < 1 THEN 1 ELSE e1 END)");
    }
}

