/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.JDBCQueryExecution;
import org.teiid.translator.jdbc.TranslatedCommand;

public class JDBCProcedureExecution
extends JDBCQueryExecution
implements ProcedureExecution {
    public JDBCProcedureExecution(Command command, Connection connection, ExecutionContext context, JDBCExecutionFactory env) {
        super(command, connection, context, env);
    }

    @Override
    public void execute() throws TranslatorException {
        Call procedure = (Call)this.command;
        this.columnDataTypes = procedure.getResultSetColumnTypes();
        TranslatedCommand translatedComm = this.translateCommand((Command)procedure);
        String sql = translatedComm.getSql();
        try {
            CallableStatement cstmt = this.getCallableStatement(sql);
            this.results = this.executionFactory.executeStoredProcedure(cstmt, translatedComm.getPreparedValues(), procedure.getReturnType());
            this.addStatementWarnings();
        }
        catch (SQLException e) {
            throw new TranslatorException((BundleUtil.Event)JDBCPlugin.Event.TEIID11004, (Throwable)e, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11004, new Object[]{sql}));
        }
    }

    @Override
    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.results == null) {
            return null;
        }
        return super.next();
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        try {
            Call proc = (Call)this.command;
            ArrayList<Object> result = new ArrayList<Object>();
            int paramIndex = 1;
            if (proc.getReturnType() != null) {
                if (proc.getReturnParameter() != null) {
                    this.addParameterValue(result, paramIndex, proc.getReturnType());
                }
                ++paramIndex;
            }
            for (Argument parameter : proc.getArguments()) {
                switch (parameter.getDirection()) {
                    case IN: {
                        ++paramIndex;
                        break;
                    }
                    case INOUT: 
                    case OUT: {
                        this.addParameterValue(result, paramIndex++, parameter.getType());
                    }
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new TranslatorException((BundleUtil.Event)JDBCPlugin.Event.TEIID11005, (Throwable)e);
        }
    }

    private void addParameterValue(List<Object> result, int paramIndex, Class<?> type) throws SQLException {
        Object value = this.executionFactory.retrieveValue((CallableStatement)this.statement, paramIndex, type);
        result.add(value);
    }
}

