/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.ingres;

import java.util.Arrays;
import java.util.List;
import org.teiid.language.Limit;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.ingres.IngresExecutionFactory;

@Translator(name="ingres93", description="A translator for Ingres 9.3 or later Database")
public class Ingres93ExecutionFactory
extends IngresExecutionFactory {
    @Override
    public void start() throws TranslatorException {
        super.start();
        this.convert.addTypeMapping("ansidate", 11);
        this.convert.addTypeMapping("timestamp(9) with time zone", 13);
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        if (limit.getRowOffset() > 0) {
            return Arrays.asList("OFFSET ", limit.getRowOffset(), " FETCH FIRST ", limit.getRowLimit(), " ROWS ONLY");
        }
        return super.translateLimit(limit, context);
    }

    public boolean supportsRowOffset() {
        return true;
    }
}

