/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.datamgr.FakeExecutionContextImpl;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Command;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.InsertValueSource;
import org.teiid.language.Literal;
import org.teiid.language.Parameter;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorBatchException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCUpdateExecution;
import org.teiid.translator.jdbc.TranslationHelper;

public class TestJDBCUpdateExecution {
    @Test
    public void testInsertIteratorUpdate() throws Exception {
        Insert command = (Insert)TranslationHelper.helpTranslate("/bqt.vdb", "insert into BQT1.SmallA (IntKey, IntNum) values (1, 2)");
        Parameter param = new Parameter();
        param.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        param.setValueIndex(0);
        List values = ((ExpressionValueSource)command.getValueSource()).getValues();
        values.set(0, param);
        param = new Parameter();
        param.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        param.setValueIndex(1);
        values.set(1, param);
        command.setParameterValues(Arrays.asList(Arrays.asList(1, 2), Arrays.asList(1, 2)).iterator());
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement p = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.stub((Object)p.executeBatch()).toReturn((Object)new int[]{1, 1});
        Mockito.stub((Object)connection.prepareStatement("INSERT INTO SmallA (IntKey, IntNum) VALUES (?, ?)")).toReturn((Object)p);
        JDBCExecutionFactory config = new JDBCExecutionFactory();
        JDBCUpdateExecution updateExecution = new JDBCUpdateExecution((Command)command, connection, (ExecutionContext)new FakeExecutionContextImpl(), config);
        updateExecution.execute();
        ((PreparedStatement)Mockito.verify((Object)p, (VerificationMode)Mockito.times((int)2))).addBatch();
    }

    @Test
    public void testAutoGeneretionKeys() throws Exception {
        Insert command = (Insert)TranslationHelper.helpTranslate("create foreign table SmallA (IntKey integer primary key, IntNum integer)", "insert into SmallA (IntKey, IntNum) values (1, 2)");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Statement s = (Statement)Mockito.mock(Statement.class);
        Mockito.stub((Object)connection.createStatement()).toReturn((Object)s);
        JDBCExecutionFactory config = new JDBCExecutionFactory(){

            public boolean supportsGeneratedKeys() {
                return true;
            }

            public boolean useColumnNamesForGeneratedKeys() {
                return true;
            }
        };
        ResultSet r = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData rs = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.stub((Object)r.getMetaData()).toReturn((Object)rs);
        Mockito.stub((Object)s.getGeneratedKeys()).toReturn((Object)r);
        FakeExecutionContextImpl context = new FakeExecutionContextImpl();
        ((CommandContext)context.getCommandContext()).setReturnAutoGeneratedKeys(true);
        JDBCUpdateExecution updateExecution = new JDBCUpdateExecution((Command)command, connection, (ExecutionContext)context, config);
        updateExecution.execute();
        ((Statement)Mockito.verify((Object)s, (VerificationMode)Mockito.times((int)1))).getGeneratedKeys();
        ((Statement)Mockito.verify((Object)s, (VerificationMode)Mockito.times((int)1))).executeUpdate("INSERT INTO SmallA (IntKey, IntNum) VALUES (1, 2)", new String[]{"IntKey"});
        config = new JDBCExecutionFactory(){

            public boolean supportsGeneratedKeys() {
                return true;
            }
        };
        s = (Statement)Mockito.mock(Statement.class);
        Mockito.stub((Object)connection.createStatement()).toReturn((Object)s);
        Mockito.stub((Object)s.getGeneratedKeys()).toReturn((Object)r);
        updateExecution = new JDBCUpdateExecution((Command)command, connection, (ExecutionContext)context, config);
        updateExecution.execute();
        ((Statement)Mockito.verify((Object)s, (VerificationMode)Mockito.times((int)1))).getGeneratedKeys();
        ((Statement)Mockito.verify((Object)s, (VerificationMode)Mockito.times((int)1))).executeUpdate("INSERT INTO SmallA (IntKey, IntNum) VALUES (1, 2)", 1);
    }

    @Test
    public void testAutoGeneretionKeysPrepared() throws Exception {
        Insert command = (Insert)TranslationHelper.helpTranslate("create foreign table SmallA (IntKey integer primary key, IntNum integer)", "insert into SmallA (IntKey, IntNum) values (1, 2)");
        ((Literal)((ExpressionValueSource)command.getValueSource()).getValues().get(0)).setBindEligible(true);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement s = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.stub((Object)connection.prepareStatement("INSERT INTO SmallA (IntKey, IntNum) VALUES (?, 2)", new String[]{"IntKey"})).toReturn((Object)s);
        JDBCExecutionFactory config = new JDBCExecutionFactory(){

            public boolean supportsGeneratedKeys() {
                return true;
            }

            public boolean useColumnNamesForGeneratedKeys() {
                return true;
            }
        };
        ResultSet r = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.stub((Object)r.next()).toReturn((Object)true).toReturn((Object)false);
        ResultSetMetaData rs = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.stub((Object)r.getMetaData()).toReturn((Object)rs);
        Mockito.stub((Object)s.getGeneratedKeys()).toReturn((Object)r);
        FakeExecutionContextImpl context = new FakeExecutionContextImpl();
        ((CommandContext)context.getCommandContext()).setReturnAutoGeneratedKeys(true);
        JDBCUpdateExecution updateExecution = new JDBCUpdateExecution((Command)command, connection, (ExecutionContext)context, config);
        updateExecution.execute();
        ((PreparedStatement)Mockito.verify((Object)s, (VerificationMode)Mockito.times((int)1))).getGeneratedKeys();
        ((PreparedStatement)Mockito.verify((Object)s, (VerificationMode)Mockito.times((int)1))).executeUpdate();
        config = new JDBCExecutionFactory(){

            public boolean supportsGeneratedKeys() {
                return true;
            }
        };
        Assert.assertEquals((Object)0, ((List)context.getCommandContext().getGeneratedKeys().getKeyIterator().next()).get(0));
    }

    @Test
    public void testBulkUpdate() throws Exception {
        Insert command = (Insert)TranslationHelper.helpTranslate("/bqt.vdb", "insert into BQT1.SmallA (IntKey) values (1)");
        Parameter param = new Parameter();
        param.setType(Integer.class);
        param.setValueIndex(0);
        ExpressionValueSource evs = new ExpressionValueSource(Arrays.asList(param));
        command.setValueSource((InsertValueSource)evs);
        ArrayList<List<Integer>> vals = new ArrayList<List<Integer>>();
        for (int i = 0; i < 8; ++i) {
            vals.add(Arrays.asList(i));
        }
        command.setParameterValues(vals.iterator());
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement p = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.stub((Object)p.executeBatch()).toReturn((Object)new int[]{1, 1});
        Mockito.stub((Object)connection.prepareStatement("INSERT INTO SmallA (IntKey) VALUES (?)")).toReturn((Object)p);
        JDBCExecutionFactory config = new JDBCExecutionFactory();
        config.setMaxPreparedInsertBatchSize(2);
        ResultSet r = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData rs = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.stub((Object)r.getMetaData()).toReturn((Object)rs);
        Mockito.stub((Object)p.getGeneratedKeys()).toReturn((Object)r);
        FakeExecutionContextImpl context = new FakeExecutionContextImpl();
        ((CommandContext)context.getCommandContext()).setReturnAutoGeneratedKeys(true);
        JDBCUpdateExecution updateExecution = new JDBCUpdateExecution((Command)command, connection, (ExecutionContext)context, config);
        updateExecution.execute();
        Assert.assertArrayEquals((int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1}, (int[])updateExecution.getUpdateCounts());
    }

    @Test
    public void testBatchedUpdate() throws Exception {
        Insert command = (Insert)TranslationHelper.helpTranslate("/bqt.vdb", "insert into BQT1.SmallA (IntKey) values (1)");
        Insert command1 = (Insert)TranslationHelper.helpTranslate("/bqt.vdb", "insert into BQT1.SmallA (StringKey) values ('1')");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Statement s = (Statement)Mockito.mock(Statement.class);
        Mockito.stub((Object)s.executeBatch()).toReturn((Object)new int[]{1, 1});
        Mockito.stub((Object)connection.createStatement()).toReturn((Object)s);
        JDBCExecutionFactory config = new JDBCExecutionFactory();
        ResultSet r = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData rs = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.stub((Object)r.getMetaData()).toReturn((Object)rs);
        Mockito.stub((Object)s.getGeneratedKeys()).toReturn((Object)r);
        FakeExecutionContextImpl context = new FakeExecutionContextImpl();
        ((CommandContext)context.getCommandContext()).setReturnAutoGeneratedKeys(true);
        JDBCUpdateExecution updateExecution = new JDBCUpdateExecution((Command)new BatchedUpdates(Arrays.asList(command, command1)), connection, (ExecutionContext)context, config);
        updateExecution.execute();
        Assert.assertArrayEquals((int[])new int[]{1, 1}, (int[])updateExecution.getUpdateCounts());
    }

    @Test
    public void testBatchedUpdateFailed() throws Exception {
        Insert command = (Insert)TranslationHelper.helpTranslate("/bqt.vdb", "insert into BQT1.SmallA (IntKey) values (1)");
        Insert command1 = (Insert)TranslationHelper.helpTranslate("/bqt.vdb", "insert into BQT1.SmallA (StringKey) values ('1')");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Statement s = (Statement)Mockito.mock(Statement.class);
        Mockito.stub((Object)s.executeBatch()).toThrow((Throwable)new BatchUpdateException(new int[]{-3}));
        Mockito.stub((Object)connection.createStatement()).toReturn((Object)s);
        JDBCExecutionFactory config = new JDBCExecutionFactory();
        ResultSet r = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData rs = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.stub((Object)r.getMetaData()).toReturn((Object)rs);
        Mockito.stub((Object)s.getGeneratedKeys()).toReturn((Object)r);
        FakeExecutionContextImpl context = new FakeExecutionContextImpl();
        JDBCUpdateExecution updateExecution = new JDBCUpdateExecution((Command)new BatchedUpdates(Arrays.asList(command, command1)), connection, (ExecutionContext)context, config);
        try {
            updateExecution.execute();
            Assert.fail();
        }
        catch (TranslatorBatchException e) {
            int[] counts = e.getUpdateCounts();
            Assert.assertArrayEquals((int[])new int[]{-3}, (int[])counts);
        }
    }

    @Test
    public void testPreparedBatchedUpdateFailed() throws Exception {
        int[] counts;
        Insert command = (Insert)TranslationHelper.helpTranslate("/bqt.vdb", "insert into BQT1.SmallA (IntKey) values (1)");
        Parameter param = new Parameter();
        param.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        param.setValueIndex(0);
        List values = ((ExpressionValueSource)command.getValueSource()).getValues();
        values.set(0, param);
        command.setParameterValues(Arrays.asList(Arrays.asList(1), Arrays.asList(1)).iterator());
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement s = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.stub((Object)s.executeBatch()).toThrow((Throwable)new BatchUpdateException(new int[]{1, -3}));
        Mockito.stub((Object)connection.prepareStatement("INSERT INTO SmallA (IntKey) VALUES (?)")).toReturn((Object)s);
        JDBCExecutionFactory config = new JDBCExecutionFactory();
        ResultSet r = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData rs = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.stub((Object)r.getMetaData()).toReturn((Object)rs);
        FakeExecutionContextImpl context = new FakeExecutionContextImpl();
        JDBCUpdateExecution updateExecution = new JDBCUpdateExecution((Command)command, connection, (ExecutionContext)context, config);
        try {
            updateExecution.execute();
            Assert.fail();
        }
        catch (TranslatorBatchException e) {
            counts = e.getUpdateCounts();
            Assert.assertArrayEquals((int[])new int[]{1, -3}, (int[])counts);
        }
        connection = (Connection)Mockito.mock(Connection.class);
        updateExecution = new JDBCUpdateExecution((Command)command, connection, (ExecutionContext)context, config);
        command.setParameterValues(Arrays.asList(Arrays.asList(1), Arrays.asList(1)).iterator());
        s = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.stub((Object)connection.prepareStatement("INSERT INTO SmallA (IntKey) VALUES (?)")).toReturn((Object)s);
        Mockito.stub((Object)s.executeBatch()).toReturn((Object)new int[]{1}).toThrow((Throwable)new BatchUpdateException(new int[]{-3}));
        updateExecution.setMaxPreparedInsertBatchSize(1);
        try {
            updateExecution.execute();
            Assert.fail();
        }
        catch (TranslatorBatchException e) {
            counts = e.getUpdateCounts();
            Assert.assertArrayEquals((int[])new int[]{1, -3}, (int[])counts);
        }
        connection = (Connection)Mockito.mock(Connection.class);
        updateExecution = new JDBCUpdateExecution((Command)command, connection, (ExecutionContext)context, config);
        command.setParameterValues(Arrays.asList(Arrays.asList(1), Arrays.asList(1)).iterator());
        s = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.stub((Object)connection.prepareStatement("INSERT INTO SmallA (IntKey) VALUES (?)")).toReturn((Object)s);
        Mockito.stub((Object)s.executeBatch()).toThrow((Throwable)new BatchUpdateException(new int[]{1}));
        try {
            updateExecution.execute();
            Assert.fail();
        }
        catch (TranslatorBatchException e) {
            counts = e.getUpdateCounts();
            Assert.assertArrayEquals((int[])new int[]{1}, (int[])counts);
        }
    }
}

