/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.postgresql;

import java.sql.Connection;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.SimpleMock;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.postgresql.PostgreSQLExecutionFactory;
import org.teiid.util.Version;

public class TestPostgreSQLTranslator {
    private static PostgreSQLExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setupOnce() throws Exception {
        TRANSLATOR = new PostgreSQLExecutionFactory();
        TRANSLATOR.setUseBindVariables(false);
        TRANSLATOR.setDatabaseVersion(Version.DEFAULT_VERSION);
        TRANSLATOR.start();
        TRANSLATOR.setPostGisVersion("1.0");
        TRANSLATOR.initCapabilities((Connection)SimpleMock.createSimpleMock(Connection.class));
    }

    public String getTestVDB() {
        return "/PartsSupplier.vdb";
    }

    private String getTestBQTVDB() {
        return "/bqt.vdb";
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput) throws TranslatorException {
        TranslationHelper.helpTestVisitor(vdb, input, expectedOutput, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testStartWithoutVersion() throws TranslatorException {
        new PostgreSQLExecutionFactory().start();
    }

    @Test
    public void testConversion1() throws Exception {
        String input = "SELECT char(convert(PART_WEIGHT, integer) + 100) FROM PARTS";
        String output = "SELECT chr((cast(PARTS.PART_WEIGHT AS integer) + 100)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion2() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, long) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS bigint) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion3() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, short) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS smallint) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion4() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, float) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS real) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion5() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, double) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS float8) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion6() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, biginteger) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS numeric(38)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion7() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, bigdecimal) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS decimal) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion8() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, boolean) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS boolean) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion8a() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, boolean), long) FROM PARTS";
        String output = "SELECT cast(cast(PARTS.PART_WEIGHT AS boolean) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion9() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, date) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS date) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion10() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, time) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS time) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion11() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, timestamp) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS timestamp) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion12() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, time), string) FROM PARTS";
        String output = "SELECT to_char(cast(PARTS.PART_WEIGHT AS time), 'HH24:MI:SS') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion13() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, timestamp), string) FROM PARTS";
        String output = "SELECT to_char(cast(PARTS.PART_WEIGHT AS timestamp), 'YYYY-MM-DD HH24:MI:SS.US') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion14() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, date), string) FROM PARTS";
        String output = "SELECT to_char(cast(PARTS.PART_WEIGHT AS date), 'YYYY-MM-DD') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion15() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, timestamp), date) FROM PARTS";
        String output = "SELECT cast(cast(PARTS.PART_WEIGHT AS timestamp) AS date) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion16() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, timestamp), time) FROM PARTS";
        String output = "SELECT cast(date_trunc('second', cast(PARTS.PART_WEIGHT AS timestamp)) AS time) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion17() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, time), timestamp) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS time) + TIMESTAMP '1970-01-01' FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion18() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, date), timestamp) FROM PARTS";
        String output = "SELECT cast(cast(PARTS.PART_WEIGHT AS date) AS timestamp) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion19() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, boolean), string) FROM PARTS";
        String output = "SELECT CASE WHEN cast(PARTS.PART_WEIGHT AS boolean) THEN 'true' WHEN not(cast(PARTS.PART_WEIGHT AS boolean)) THEN 'false' END FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testLog() throws Exception {
        String input = "SELECT log(convert(PART_WEIGHT, double)) FROM PARTS";
        String output = "SELECT ln(cast(PARTS.PART_WEIGHT AS float8)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
        input = "SELECT log10(convert(PART_WEIGHT, double)) FROM PARTS";
        output = "SELECT log(cast(PARTS.PART_WEIGHT AS float8)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testLeft() throws Exception {
        String input = "SELECT left(PART_WEIGHT, 2) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_WEIGHT from 1 for 2) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testDayOfWeek() throws Exception {
        String input = "SELECT dayofweek(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT CAST((EXTRACT(DOW FROM cast(PARTS.PART_WEIGHT AS timestamp)) + 1) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testDayOfMonth() throws Exception {
        String input = "SELECT dayofmonth(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT CAST(EXTRACT(DAY FROM cast(PARTS.PART_WEIGHT AS timestamp)) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testDayOfYear() throws Exception {
        String input = "SELECT dayofyear(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT CAST(EXTRACT(DOY FROM cast(PARTS.PART_WEIGHT AS timestamp)) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testHour() throws Exception {
        String input = "SELECT hour(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT CAST(EXTRACT(HOUR FROM cast(PARTS.PART_WEIGHT AS timestamp)) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testMinute() throws Exception {
        String input = "SELECT minute(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT CAST(EXTRACT(MINUTE FROM cast(PARTS.PART_WEIGHT AS timestamp)) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testMonth() throws Exception {
        String input = "SELECT month(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT CAST(EXTRACT(MONTH FROM cast(PARTS.PART_WEIGHT AS timestamp)) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testQuarter() throws Exception {
        String input = "SELECT quarter(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT CAST(EXTRACT(QUARTER FROM cast(PARTS.PART_WEIGHT AS timestamp)) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testSecond() throws Exception {
        String input = "SELECT second(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT CAST(EXTRACT(SECOND FROM cast(PARTS.PART_WEIGHT AS timestamp)) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testWeek() throws Exception {
        String input = "SELECT week(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT CAST(EXTRACT(WEEK FROM cast(PARTS.PART_WEIGHT AS timestamp)) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testYear() throws Exception {
        String input = "SELECT year(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT CAST(EXTRACT(YEAR FROM cast(PARTS.PART_WEIGHT AS timestamp)) AS integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testDayName() throws Exception {
        String input = "SELECT dayname(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT rtrim(TO_CHAR(cast(PARTS.PART_WEIGHT AS timestamp), 'Day')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testMonthName() throws Exception {
        String input = "SELECT monthname(convert(PART_WEIGHT, timestamp)) FROM PARTS";
        String output = "SELECT rtrim(TO_CHAR(cast(PARTS.PART_WEIGHT AS timestamp), 'Month')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testIfnull() throws Exception {
        String input = "SELECT ifnull(PART_WEIGHT, 'otherString') FROM PARTS";
        String output = "SELECT coalesce(PARTS.PART_WEIGHT, 'otherString') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testSubstring1() throws Exception {
        String input = "SELECT substring(PART_WEIGHT, 1) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_WEIGHT from 1) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testSubstring2() throws Exception {
        String input = "SELECT substring(PART_WEIGHT, 1, 5) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_WEIGHT from 1 for 5) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testSubstringExpressionIndex() throws Exception {
        String input = "SELECT substring(PART_WEIGHT, cast(part_id as integer), 5) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_WEIGHT from case sign(cast(PARTS.PART_ID AS integer)) when -1 then cast(null as int4) when 0 then 1 else cast(PARTS.PART_ID AS integer) end for 5) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testSubstringZeroIndex() throws Exception {
        String input = "SELECT substring(PART_WEIGHT, 0, 5) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_WEIGHT from 1 for 5) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testBooleanAggregate() throws Exception {
        String input = "SELECT MIN(convert(PART_WEIGHT, boolean)) FROM PARTS";
        String output = "SELECT bool_and(cast(PARTS.PART_WEIGHT AS boolean)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testRowLimit2() throws Exception {
        String input = "select intkey from bqt1.smalla limit 100";
        String output = "SELECT SmallA.IntKey FROM SmallA LIMIT 100";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testRowLimit3() throws Exception {
        String input = "select intkey from bqt1.smalla limit 50, 100";
        String output = "SELECT SmallA.IntKey FROM SmallA LIMIT 100 OFFSET 50";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testBitFunctions() throws Exception {
        String input = "select bitand(intkey, intnum), bitnot(intkey), bitor(intnum, intkey), bitxor(intnum, intkey) from bqt1.smalla";
        String output = "SELECT (SmallA.IntKey & SmallA.IntNum), ~(SmallA.IntKey), (SmallA.IntNum | SmallA.IntKey), (SmallA.IntNum # SmallA.IntKey) FROM SmallA";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testLocate() throws Exception {
        String input = "SELECT locate(INTNUM, 'chimp', 1) FROM BQT1.SMALLA";
        String output = "SELECT position(cast(SmallA.IntNum AS varchar(4000)) in 'chimp') FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate2() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp') FROM BQT1.SMALLA";
        String output = "SELECT position(SmallA.StringNum in 'chimp') FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate3() throws Exception {
        String input = "SELECT locate(INTNUM, '234567890', 1) FROM BQT1.SMALLA WHERE INTKEY = 26";
        String output = "SELECT position(cast(SmallA.IntNum AS varchar(4000)) in '234567890') FROM SmallA WHERE SmallA.IntKey = 26";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate4() throws Exception {
        String input = "SELECT locate('c', 'chimp', 1) FROM BQT1.SMALLA";
        String output = "SELECT 1 FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate5() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', -5) FROM BQT1.SMALLA";
        String output = "SELECT position(SmallA.StringNum in 'chimp') FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate5a() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', 2) FROM BQT1.SMALLA";
        String output = "SELECT (position(SmallA.StringNum in substring('chimp' from 2)) + 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate6() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', INTNUM) FROM BQT1.SMALLA";
        String output = "SELECT (position(SmallA.StringNum in substring('chimp' from CASE WHEN SmallA.IntNum < 1 THEN 1 ELSE SmallA.IntNum END)) + CASE WHEN SmallA.IntNum < 1 THEN 1 ELSE SmallA.IntNum END - 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate7() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', LOCATE(STRINGNUM, 'chimp') + 1) FROM BQT1.SMALLA";
        String output = "SELECT (position(SmallA.StringNum in substring('chimp' from CASE WHEN (position(SmallA.StringNum in 'chimp') + 1) < 1 THEN 1 ELSE (position(SmallA.StringNum in 'chimp') + 1) END)) + CASE WHEN (position(SmallA.StringNum in 'chimp') + 1) < 1 THEN 1 ELSE (position(SmallA.StringNum in 'chimp') + 1) END - 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testAggregate() throws Exception {
        String input = "SELECT count(*), max(booleanvalue), max(intnum) FROM BQT1.SMALLA";
        String output = "SELECT COUNT(*), bool_or(SmallA.BooleanValue), MAX(SmallA.IntNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testArrayFunctions() throws Exception {
        String input = "SELECT array_get(objectvalue, 3), array_length(objectvalue) FROM BQT1.SMALLA";
        String output = "SELECT SmallA.ObjectValue[3], array_length(SmallA.ObjectValue, 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLikeRegex() throws Exception {
        String input = "SELECT intkey FROM BQT1.SMALLA where stringkey like_regex 'ab.*c+' and stringkey not like_regex 'ab{3,5}c'";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE SmallA.StringKey ~ 'ab.*c+' AND SmallA.StringKey !~ 'ab{3,5}c'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTempTable() throws Exception {
        Assert.assertEquals((Object)"create temporary table foo (COL1 int4, COL2 varchar(100)) on commit drop", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)TRANSLATOR, true));
        Assert.assertEquals((Object)"create temporary table foo (COL1 int4, COL2 varchar(100)) ON COMMIT PRESERVE ROWS", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)TRANSLATOR, false));
    }

    @Test
    public void testFormatTimestampFrac() throws Exception {
        String input = "SELECT formattimestamp(now(), 'SSS'), formattimestamp(now(), 'SSSSSSS') FROM PARTS";
        String output = "SELECT TO_CHAR(now(), 'MS'), TO_CHAR(now(), 'US') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testRecursiveCTE() throws Exception {
        String input = "WITH p(n) as (select part_name as n from parts union select n from p) SELECT * FROM P";
        String output = "WITH RECURSIVE p (n) AS (SELECT PARTS.PART_NAME AS n FROM PARTS UNION SELECT p.n FROM p) SELECT P.n FROM P";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testGeometryFunctions() throws Exception {
        PostgreSQLExecutionFactory pgef = new PostgreSQLExecutionFactory();
        pgef.setPostGisVersion("1.5");
        pgef.setDatabaseVersion(Version.DEFAULT_VERSION);
        pgef.start();
        Assert.assertTrue((boolean)pgef.getSupportedFunctions().contains("st_asbinary"));
        Assert.assertFalse((boolean)pgef.getSupportedFunctions().contains("st_geomfromgeojson"));
    }

    @Test
    public void testBooleanConversion() throws Exception {
        String input = "SELECT cast(bigdecimalvalue as boolean), cast(doublenum as boolean) from bqt1.smalla";
        String output = "SELECT SmallA.BigDecimalValue <> 0, cast(SmallA.DoubleNum AS boolean) FROM SmallA";
        this.helpTestVisitor("/bqt.vdb", input, output);
    }

    @Test
    public void testSelectStringLiteral() throws Exception {
        String input = "SELECT 'a' FROM PARTS";
        String output = "SELECT cast('a' AS bpchar) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testRound() throws Exception {
        String input = "SELECT round(bigdecimalvalue, 2), round(doublenum, 3), round(doublenum, 0) from bqt1.smalla";
        String output = "SELECT round(SmallA.BigDecimalValue, 2), round(cast(SmallA.DoubleNum AS decimal), 3), round(SmallA.DoubleNum) FROM SmallA";
        this.helpTestVisitor("/bqt.vdb", input, output);
    }

    @Test
    public void testBinaryLiteral() throws TranslatorException {
        this.helpTestVisitor("/bqt.vdb", "SELECT X'abcd1234'", "SELECT cast(E'\\\\xABCD1234' AS bytea)");
    }

    @Test
    public void testBooleanExpressionComparision() throws TranslatorException {
        this.helpTestVisitor("/bqt.vdb", "SELECT intkey from bqt1.smalla where (intkey < 10) = true", "SELECT SmallA.IntKey FROM SmallA WHERE (SmallA.IntKey < 10) = TRUE");
        this.helpTestVisitor("/bqt.vdb", "select SmallA.StringKey from BQT1.SmallA where ((BooleanValue=true) and (IntKey=1)) = true", "SELECT SmallA.StringKey FROM SmallA WHERE (SmallA.BooleanValue = TRUE AND SmallA.IntKey = 1) = TRUE");
    }
}

