/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.mockito.Mockito;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.metadata.FunctionMetadataReader;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslatedCommand;

public class TranslationHelper {
    public static final String PARTS_VDB = "/PartsSupplier.vdb";
    public static final String BQT_VDB = "/bqt.vdb";

    public static Command helpTranslate(String vdbFileName, String sql) {
        return TranslationHelper.helpTranslate(vdbFileName, null, null, sql);
    }

    public static TranslationUtility getTranslationUtility(String vdbFileName, String udf) {
        TranslationUtility util = null;
        if (PARTS_VDB.equals(vdbFileName)) {
            util = new TranslationUtility("PartsSupplier.vdb", TranslationHelper.class.getResource(vdbFileName));
        } else if (BQT_VDB.equals(vdbFileName)) {
            util = FakeTranslationFactory.getInstance().getBQTTranslationUtility();
        } else {
            try {
                util = new TranslationUtility((QueryMetadataInterface)RealMetadataFactory.fromDDL((String)vdbFileName, (String)"vdb", (String)"test"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (udf != null) {
            TranslationHelper.loadUDFs(udf, util);
        }
        return util;
    }

    public static void loadUDFs(String udf, TranslationUtility util) {
        try {
            List methods = FunctionMetadataReader.loadFunctionMethods((InputStream)TranslationHelper.class.getResource(udf).openStream());
            util.addUDF("foo", (Collection)methods);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException("failed to load UDF");
        }
        catch (XMLStreamException e) {
            throw new TeiidRuntimeException("failed to load UDF");
        }
    }

    public static Command helpTranslate(String vdbFileName, String udf, List<FunctionMethod> pushdowns, String sql) {
        TranslationUtility util = TranslationHelper.getTranslationUtility(vdbFileName, null);
        if (pushdowns != null) {
            util.addUDF("SYS", pushdowns);
        }
        if (udf != null) {
            ArrayList methods = new ArrayList();
            try {
                methods.addAll(FunctionMetadataReader.loadFunctionMethods((InputStream)TranslationHelper.class.getResource(udf).openStream()));
            }
            catch (XMLStreamException e) {
                throw new TeiidRuntimeException("failed to load UDF");
            }
            catch (IOException e) {
                throw new TeiidRuntimeException("failed to load UDF");
            }
            util.addUDF("foo", methods);
        }
        return util.parseCommand(sql);
    }

    public static TranslatedCommand helpTestVisitor(String vdb, String input, String expectedOutput, JDBCExecutionFactory translator) throws TranslatorException {
        return TranslationHelper.helpTestVisitor(vdb, null, input, expectedOutput, translator);
    }

    public static TranslatedCommand helpTestVisitor(String vdb, String udf, String input, String expectedOutput, JDBCExecutionFactory translator) throws TranslatorException {
        Command obj = TranslationHelper.helpTranslate(vdb, udf, translator.getPushDownFunctions(), input);
        return TranslationHelper.helpTestVisitor(expectedOutput, translator, obj);
    }

    public static TranslatedCommand helpTestVisitor(String expectedOutput, JDBCExecutionFactory translator, Command obj) throws TranslatorException {
        TranslatedCommand tc = new TranslatedCommand((ExecutionContext)Mockito.mock(ExecutionContext.class), translator);
        tc.translateCommand(obj);
        Assert.assertEquals((String)"Did not get correct sql", (Object)expectedOutput, (Object)tc.getSql());
        return tc;
    }

    public static String helpTestTempTable(JDBCExecutionFactory transaltor, boolean transactional) throws QueryMetadataException, TeiidComponentException {
        ArrayList<ColumnReference> cols = new ArrayList<ColumnReference>();
        cols.add(new ColumnReference(null, "COL1", RealMetadataFactory.exampleBQTCached().getElementID("BQT1.SMALLA.INTKEY"), TypeFacility.RUNTIME_TYPES.INTEGER));
        cols.add(new ColumnReference(null, "COL2", RealMetadataFactory.exampleBQTCached().getElementID("BQT1.SMALLA.STRINGKEY"), TypeFacility.RUNTIME_TYPES.STRING));
        return transaltor.getCreateTempTableSQL("foo", cols, transactional);
    }
}

