/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.h2;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.ModFunctionModifier;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.hsql.AddDiffModifier;
import org.teiid.translator.jdbc.oracle.ConcatFunctionModifier;
import org.teiid.translator.jdbc.postgresql.PostgreSQLExecutionFactory;

@Translator(name="h2", description="A translator for open source H2 Database")
public class H2ExecutionFactory
extends JDBCExecutionFactory {
    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("parsetimestamp", new AliasModifier("parsedatetime"));
        this.registerFunctionModifier("formattimestamp", new AliasModifier("formatdatetime"));
        this.registerFunctionModifier("dayofmonth", new AliasModifier("day_of_month"));
        this.registerFunctionModifier("dayofweek", new AliasModifier("day_of_week"));
        this.registerFunctionModifier("week", new AliasModifier("iso_week"));
        this.registerFunctionModifier("dayofyear", new AliasModifier("day_of_year"));
        this.registerFunctionModifier("unescape", new AliasModifier("stringdecode"));
        this.registerFunctionModifier("mod", new ModFunctionModifier("mod", this.getLanguageFactory()));
        this.registerFunctionModifier("concat", new ConcatFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("timestampadd", new AddDiffModifier(true, this.getLanguageFactory()));
        this.registerFunctionModifier("timestampdiff", new AddDiffModifier(false, this.getLanguageFactory()));
        ConvertModifier convert = new ConvertModifier();
        convert.addTypeMapping("boolean", 2);
        convert.addTypeMapping("tinyint", 3);
        convert.addTypeMapping("smallint", 4);
        convert.addTypeMapping("int", 5);
        convert.addTypeMapping("bigint", 6);
        convert.addTypeMapping("real", 8);
        convert.addTypeMapping("double", 9);
        convert.addTypeMapping("decimal", 10);
        convert.addTypeMapping("decimal(38,0)", 7);
        convert.addTypeMapping("date", 11);
        convert.addTypeMapping("time", 12);
        convert.addTypeMapping("timestamp", 13);
        convert.addTypeMapping("char(1)", 1);
        convert.addTypeMapping("varchar", 0);
        this.registerFunctionModifier("convert", convert);
        this.addPushDownFunction("h2", "timestampdiff", "integer", new String[]{"string", "timestamp", "timestamp"});
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "DATE '" + this.formatDateValue(dateValue) + "'";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "TIME '" + this.formatDateValue(timeValue) + "'";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "TIMESTAMP '" + this.formatDateValue(timestampValue) + "'";
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("bitand");
        supportedFunctions.add("bitor");
        supportedFunctions.add("bitxor");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("cos");
        supportedFunctions.add("cot");
        supportedFunctions.add("degrees");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("mod");
        supportedFunctions.add("pi");
        supportedFunctions.add("power");
        supportedFunctions.add("radians");
        supportedFunctions.add("round");
        supportedFunctions.add("sign");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add("ascii");
        supportedFunctions.add("char");
        supportedFunctions.add("concat");
        supportedFunctions.add("insert");
        supportedFunctions.add("lcase");
        supportedFunctions.add("left");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("lpad");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("repeat");
        supportedFunctions.add("replace");
        supportedFunctions.add("right");
        supportedFunctions.add("rpad");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("substring");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        supportedFunctions.add("unescape");
        supportedFunctions.add("dayname");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("formattimestamp");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("month");
        supportedFunctions.add("monthname");
        supportedFunctions.add("parsetimestamp");
        supportedFunctions.add("quarter");
        supportedFunctions.add("second");
        supportedFunctions.add("timestampadd");
        supportedFunctions.add("week");
        supportedFunctions.add("year");
        supportedFunctions.add("convert");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("array_get");
        supportedFunctions.add("array_length");
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public boolean supportsLikeRegex() {
        return true;
    }

    @Override
    public String getLikeRegexString() {
        return "REGEXP";
    }

    public boolean supportsArrayType() {
        return true;
    }

    @Override
    public boolean supportsInsertWithQueryExpression() {
        return true;
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        Like like;
        if (obj instanceof Like && (like = (Like)obj).getEscapeCharacter() == null && like.getMode() != Like.MatchMode.REGEX) {
            return PostgreSQLExecutionFactory.addDefaultEscape(like);
        }
        return super.translate(obj, context);
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public String getHibernateDialectClassName() {
        return "org.hibernate.dialect.H2Dialect";
    }

    @Override
    public boolean tempTableRequiresTransaction() {
        return true;
    }

    @Override
    public boolean useParensForJoins() {
        return true;
    }

    @Override
    public SQLConversionVisitor getSQLConversionVisitor() {
        return new SQLConversionVisitor(this){

            protected boolean useParensForLHSJoins() {
                return false;
            }

            protected String getUpsertKeyword() {
                return "MERGE";
            }
        };
    }

    public boolean supportsUpsert() {
        return true;
    }
}

