/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.io.Reader;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.GeometryInputSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BinaryType;
import org.teiid.language.AggregateFunction;
import org.teiid.language.Argument;
import org.teiid.language.Array;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Function;
import org.teiid.language.In;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.OrderBy;
import org.teiid.language.Parameter;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.SetQuery;
import org.teiid.language.TableReference;
import org.teiid.language.With;
import org.teiid.language.WithItem;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.AggregateAttributes;
import org.teiid.metadata.Column;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.ExtractFunctionModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCMetdataProcessor;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.LocateFunctionModifier;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.TemplateFunctionModifier;
import org.teiid.translator.jdbc.oracle.ConcatFunctionModifier;
import org.teiid.translator.jdbc.oracle.DayWeekQuarterFunctionModifier;
import org.teiid.translator.jdbc.oracle.LeftOrRightFunctionModifier;
import org.teiid.translator.jdbc.oracle.Log10FunctionModifier;
import org.teiid.translator.jdbc.oracle.MonthOrDayNameFunctionModifier;
import org.teiid.translator.jdbc.oracle.OracleFormatFunctionModifier;
import org.teiid.translator.jdbc.oracle.OracleMetadataProcessor;
import org.teiid.translator.jdbc.oracle.OracleSpatialFunctionModifier;
import org.teiid.util.Version;

@Translator(name="oracle", description="A translator for Oracle 9i Database or later")
public class OracleExecutionFactory
extends JDBCExecutionFactory {
    private static final String TRUNC = "TRUNC";
    private static final String LISTAGG = "LISTAGG";
    public static final Version NINE_0 = Version.getVersion((String)"9.0");
    public static final Version NINE_2 = Version.getVersion((String)"9.2");
    public static final Version ELEVEN_2_0_4 = Version.getVersion((String)"11.2.0.4");
    public static final Version ELEVEN_2 = Version.getVersion((String)"11.2");
    public static final Version TWELVE = Version.getVersion((String)"12");
    private static final String TIME_FORMAT = "HH24:MI:SS";
    private static final String DATE_FORMAT = "YYYY-MM-DD";
    private static final String DATETIME_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    private static final String TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF";
    public static final String HINT_PREFIX = "/*+";
    public static final String HINT_SUFFIX = "*/";
    public static final String DUAL = "DUAL";
    public static final String ROWNUM = "ROWNUM";
    public static final String SEQUENCE = ":SEQUENCE=";
    public static final String RELATE = "sdo_relate";
    public static final String NEAREST_NEIGHBOR = "sdo_nn";
    public static final String FILTER = "sdo_filter";
    public static final String WITHIN_DISTANCE = "sdo_within_distance";
    public static final String NEAREST_NEIGHBOR_DISTANCE = "sdo_nn_distance";
    public static final String ORACLE_SDO = "Oracle-SDO";
    public static final String ORACLE = "Oracle";
    private static final Set<String> STRING_BOOLEAN_FUNCTIONS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    static int CURSOR_TYPE;
    static final String REF_CURSOR = "REF CURSOR";
    static int FIXED_CHAR_TYPE;
    private boolean oracleSuppliedDriver = true;
    private OracleFormatFunctionModifier parseModifier = new OracleFormatFunctionModifier("TO_TIMESTAMP(", true);

    public OracleExecutionFactory() {
        this.setUseBindingsForDependentJoin(false);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("char", new AliasModifier("chr"));
        this.registerFunctionModifier("lcase", new AliasModifier("lower"));
        this.registerFunctionModifier("ucase", new AliasModifier("upper"));
        this.registerFunctionModifier("ifnull", new AliasModifier("nvl"));
        this.registerFunctionModifier("log", new AliasModifier("ln"));
        this.registerFunctionModifier("ceiling", new AliasModifier("ceil"));
        this.registerFunctionModifier("log10", new Log10FunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("hour", new DateAwareExtract());
        this.registerFunctionModifier("year", new ExtractFunctionModifier());
        this.registerFunctionModifier("minute", new DateAwareExtract());
        this.registerFunctionModifier("second", new DateAwareExtract());
        this.registerFunctionModifier("month", new ExtractFunctionModifier());
        this.registerFunctionModifier("dayofmonth", new ExtractFunctionModifier());
        this.registerFunctionModifier("monthname", new MonthOrDayNameFunctionModifier(this.getLanguageFactory(), "Month"));
        this.registerFunctionModifier("dayname", new MonthOrDayNameFunctionModifier(this.getLanguageFactory(), "Day"));
        this.registerFunctionModifier("week", new DayWeekQuarterFunctionModifier("IW"));
        this.registerFunctionModifier("quarter", new DayWeekQuarterFunctionModifier("Q"));
        this.registerFunctionModifier("dayofweek", new DayWeekQuarterFunctionModifier("D"));
        this.registerFunctionModifier("dayofyear", new DayWeekQuarterFunctionModifier("DDD"));
        this.registerFunctionModifier("locate", new LocateFunctionModifier(this.getLanguageFactory(), "INSTR", true));
        this.registerFunctionModifier("substring", new AliasModifier("substr"));
        this.registerFunctionModifier("left", new LeftOrRightFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("concat", new ConcatFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("concat2", new AliasModifier("||"));
        this.registerFunctionModifier("cot", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                function.setName("tan");
                return Arrays.asList(OracleExecutionFactory.this.getLanguageFactory().createFunction("/", new Expression[]{new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER), function}, TypeFacility.RUNTIME_TYPES.DOUBLE));
            }
        });
        this.registerFunctionModifier(RELATE, new OracleSpatialFunctionModifier());
        this.registerFunctionModifier(NEAREST_NEIGHBOR, new OracleSpatialFunctionModifier());
        this.registerFunctionModifier(FILTER, new OracleSpatialFunctionModifier());
        this.registerFunctionModifier(WITHIN_DISTANCE, new OracleSpatialFunctionModifier());
        this.registerFunctionModifier("parsetimestamp", this.parseModifier);
        this.registerFunctionModifier("formattimestamp", new OracleFormatFunctionModifier("TO_CHAR(", false));
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.addTypeMapping("char(1)", 1);
        convertModifier.addTypeMapping("date", 11, 12);
        convertModifier.addTypeMapping("timestamp", 13);
        convertModifier.addConvert(13, 12, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("case when ", function.getParameters().get(0), " is null then null else to_date('1970-01-01 ' || to_char(", function.getParameters().get(0), ", 'HH24:MI:SS'), 'YYYY-MM-DD HH24:MI:SS') end");
            }
        });
        convertModifier.addConvert(13, 11, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("trunc(cast(", function.getParameters().get(0), " AS date))");
            }
        });
        convertModifier.addConvert(11, 0, new ConvertModifier.FormatModifier("to_char", DATE_FORMAT));
        convertModifier.addConvert(12, 0, new ConvertModifier.FormatModifier("to_char", TIME_FORMAT));
        convertModifier.addConvert(13, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Expression ex = (Expression)function.getParameters().get(0);
                String format = OracleExecutionFactory.TIMESTAMP_FORMAT;
                if (ex instanceof ColumnReference && "date".equalsIgnoreCase(((ColumnReference)ex).getMetadataObject().getNativeType())) {
                    format = OracleExecutionFactory.DATETIME_FORMAT;
                } else if (!(ex instanceof Literal) && !(ex instanceof Function)) {
                    ex = ConvertModifier.createConvertFunction(OracleExecutionFactory.this.getLanguageFactory(), (Expression)function.getParameters().get(0), "timestamp");
                }
                return Arrays.asList("to_char(", ex, ", '", format, "')");
            }
        });
        convertModifier.addConvert(0, 11, new ConvertModifier.FormatModifier("to_date", DATE_FORMAT));
        convertModifier.addConvert(0, 12, new ConvertModifier.FormatModifier("to_date", TIME_FORMAT));
        convertModifier.addConvert(0, 13, new ConvertModifier.FormatModifier("to_timestamp", TIMESTAMP_FORMAT));
        convertModifier.addConvert(16, 0, new TemplateFunctionModifier("DBMS_LOB.substr(", 0, ", 4000)"));
        convertModifier.addTypeConversion(new ConvertModifier.FormatModifier("to_char"), 0);
        convertModifier.addTypeConversion(new ConvertModifier.FormatModifier("to_number"), 8, 9, 10);
        convertModifier.addTypeConversion(new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                if (Number.class.isAssignableFrom(((Expression)function.getParameters().get(0)).getType())) {
                    return Arrays.asList("trunc(", function.getParameters().get(0), ")");
                }
                return Arrays.asList("trunc(to_number(", function.getParameters().get(0), "))");
            }
        }, 3, 4, 5, 6, 7);
        convertModifier.addNumericBooleanConversions();
        convertModifier.setWideningNumericImplicit(true);
        this.registerFunctionModifier("convert", convertModifier);
        this.addPushDownFunction(ORACLE, TRUNC, "timestamp", new String[]{"timestamp", "string"});
        this.addPushDownFunction(ORACLE, TRUNC, "timestamp", new String[]{"timestamp"});
        this.addPushDownFunction(ORACLE, TRUNC, "bigdecimal", new String[]{"bigdecimal", "bigdecimal"});
        this.addPushDownFunction(ORACLE, TRUNC, "bigdecimal", new String[]{"bigdecimal"});
        this.addPushDownFunction(ORACLE_SDO, RELATE, "string", new String[]{"string", "string", "string"});
        this.addPushDownFunction(ORACLE_SDO, RELATE, "string", new String[]{"object", "object", "string"});
        this.addPushDownFunction(ORACLE_SDO, RELATE, "string", new String[]{"string", "object", "string"});
        this.addPushDownFunction(ORACLE_SDO, RELATE, "string", new String[]{"object", "string", "string"});
        this.addPushDownFunction(ORACLE_SDO, NEAREST_NEIGHBOR, "string", new String[]{"string", "object", "string", "integer"});
        this.addPushDownFunction(ORACLE_SDO, NEAREST_NEIGHBOR, "string", new String[]{"object", "object", "string", "integer"});
        this.addPushDownFunction(ORACLE_SDO, NEAREST_NEIGHBOR, "string", new String[]{"object", "string", "string", "integer"});
        this.addPushDownFunction(ORACLE_SDO, NEAREST_NEIGHBOR_DISTANCE, "integer", new String[]{"integer"});
        this.addPushDownFunction(ORACLE_SDO, WITHIN_DISTANCE, "string", new String[]{"object", "object", "string"});
        this.addPushDownFunction(ORACLE_SDO, WITHIN_DISTANCE, "string", new String[]{"string", "object", "string"});
        this.addPushDownFunction(ORACLE_SDO, WITHIN_DISTANCE, "string", new String[]{"object", "string", "string"});
        this.addPushDownFunction(ORACLE_SDO, FILTER, "string", new String[]{"object", "string", "string"});
        this.addPushDownFunction(ORACLE_SDO, FILTER, "string", new String[]{"object", "object", "string"});
        this.addPushDownFunction(ORACLE_SDO, FILTER, "string", new String[]{"string", "object", "string"});
        this.registerFunctionModifier("st_asbinary", new AliasModifier("SDO_UTIL.TO_WKBGEOMETRY"));
        this.registerFunctionModifier("st_astext", new AliasModifier("SDO_UTIL.TO_WKTGEOMETRY"));
        this.registerFunctionModifier("st_asgml", new AliasModifier("SDO_UTIL.TO_GMLGEOMETRY"));
        this.registerFunctionModifier("st_geomfromwkb", new AliasModifier("SDO_GEOMETRY"){

            @Override
            public List<?> translate(Function function) {
                Expression ex = (Expression)function.getParameters().get(0);
                if (ex instanceof Parameter || ex instanceof Literal) {
                    function.getParameters().set(0, new Function("TO_BLOB", Arrays.asList(ex), TypeFacility.RUNTIME_TYPES.BLOB));
                }
                return super.translate(function);
            }
        });
        this.registerFunctionModifier("st_geomfromtext", new AliasModifier("SDO_GEOMETRY"){

            @Override
            public List<?> translate(Function function) {
                Expression ex = (Expression)function.getParameters().get(0);
                if (ex instanceof Parameter || ex instanceof Literal) {
                    function.getParameters().set(0, new Function("TO_CLOB", Arrays.asList(ex), TypeFacility.RUNTIME_TYPES.CLOB));
                }
                return super.translate(function);
            }
        });
        this.registerFunctionModifier("st_distance", new TemplateFunctionModifier("SDO_GEOM.SDO_DISTANCE(", 0, ", ", 1, ", 0.005)"));
        this.registerFunctionModifier("st_disjoint", new TemplateFunctionModifier("CASE SDO_GEOM.RELATE(", 0, ", 'disjoint', ", 1, ", 0.005) WHEN 'DISJOINT' THEN 'TRUE' ELSE 'FALSE' END"));
        this.registerFunctionModifier("st_contains", new AliasModifier("SDO_CONTAINS"));
        this.registerFunctionModifier("st_intersects", new AliasModifier("SDO_ANYINTERACT"));
        this.registerFunctionModifier("st_overlaps", new AliasModifier("SDO_OVERLAPBDYINTERSECT"));
        this.registerFunctionModifier("st_crosses", new AliasModifier("SDO_OVERLAPBDYDISJOINT"));
        this.registerFunctionModifier("st_touches", new AliasModifier("SDO_TOUCH"));
        this.registerFunctionModifier("st_equals", new AliasModifier("SDO_EQUALS"));
        this.registerFunctionModifier("st_srid", new TemplateFunctionModifier("nvl(", 0, ".sdo_srid, 0)"));
    }

    @Override
    public void initCapabilities(Connection connection) throws TranslatorException {
        super.initCapabilities(connection);
        if (this.getVersion().compareTo(ELEVEN_2) >= 0) {
            AggregateAttributes aa = new AggregateAttributes();
            aa.setAllowsOrderBy(true);
            this.addPushDownFunction(ORACLE, LISTAGG, "string", new String[]{"string", "string"}).setAggregateAttributes(aa);
            this.addPushDownFunction(ORACLE, LISTAGG, "string", new String[]{"string"}).setAggregateAttributes(aa);
        }
    }

    public void handleInsertSequences(Insert insert) throws TranslatorException {
        if (!(insert.getValueSource() instanceof ExpressionValueSource)) {
            return;
        }
        ExpressionValueSource values = (ExpressionValueSource)insert.getValueSource();
        if (insert.getTable().getMetadataObject() == null) {
            return;
        }
        List allElements = insert.getTable().getMetadataObject().getColumns();
        if (allElements.size() == values.getValues().size()) {
            return;
        }
        int index = 0;
        List elements = insert.getColumns();
        for (Column element : allElements) {
            String name;
            int seqIndex;
            if (!element.isAutoIncremented() || (seqIndex = (name = element.getNameInSource()).indexOf(SEQUENCE)) == -1) continue;
            boolean found = false;
            while (index < elements.size()) {
                if (element.equals((Object)((ColumnReference)elements.get(index)).getMetadataObject())) {
                    found = true;
                    break;
                }
                ++index;
            }
            if (found) continue;
            String sequence = name.substring(seqIndex + SEQUENCE.length());
            int delimiterIndex = sequence.indexOf(".");
            if (delimiterIndex == -1) {
                throw new TranslatorException((BundleUtil.Event)JDBCPlugin.Event.TEIID11017, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11017, new Object[]{SEQUENCE, name}));
            }
            String sequenceGroupName = sequence.substring(0, delimiterIndex);
            String sequenceElementName = sequence.substring(delimiterIndex + 1);
            NamedTable sequenceGroup = this.getLanguageFactory().createNamedTable(sequenceGroupName, null, null);
            ColumnReference sequenceElement = this.getLanguageFactory().createColumnReference(sequenceElementName, sequenceGroup, null, element.getJavaType());
            insert.getColumns().add(index, this.getLanguageFactory().createColumnReference(element.getName(), insert.getTable(), element, element.getJavaType()));
            values.getValues().add(index, sequenceElement);
        }
    }

    @Override
    public List<?> translateCommand(Command command, ExecutionContext context) {
        Select select;
        TableReference tr;
        if (command instanceof Insert) {
            try {
                this.handleInsertSequences((Insert)command);
            }
            catch (TranslatorException e) {
                throw new RuntimeException(e);
            }
        }
        if (!(command instanceof QueryExpression)) {
            return null;
        }
        QueryExpression queryCommand = (QueryExpression)command;
        if (queryCommand.getLimit() == null) {
            return null;
        }
        Limit limit = queryCommand.getLimit();
        queryCommand.setLimit(null);
        if (command instanceof Select && (tr = (TableReference)(select = (Select)command).getFrom().get(0)) instanceof NamedTable && this.isDual((NamedTable)tr)) {
            if (limit.getRowOffset() > 0 || limit.getRowLimit() == 0) {
                select.setWhere((Condition)new Comparison((Expression)new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER), (Expression)new Literal((Object)0, TypeFacility.RUNTIME_TYPES.INTEGER), Comparison.Operator.EQ));
                return null;
            }
            return null;
        }
        ArrayList<Object> parts = new ArrayList<Object>();
        if (queryCommand.getWith() != null) {
            With with = queryCommand.getWith();
            queryCommand.setWith(null);
            parts.add(with);
        }
        parts.add("SELECT ");
        boolean allAliased = true;
        for (DerivedColumn selectSymbol : queryCommand.getProjectedQuery().getDerivedColumns()) {
            if (selectSymbol.getAlias() != null) continue;
            allAliased = false;
            break;
        }
        if (allAliased) {
            String[] columnNames = queryCommand.getColumnNames();
            for (int i = 0; i < columnNames.length; ++i) {
                if (i > 0) {
                    parts.add(", ");
                }
                parts.add(columnNames[i]);
            }
        } else {
            parts.add("*");
        }
        if (limit.getRowOffset() > 0) {
            parts.add(" FROM (SELECT VIEW_FOR_LIMIT.*, ROWNUM ROWNUM_ FROM (");
        } else {
            parts.add(" FROM (");
        }
        parts.add(queryCommand);
        if (limit.getRowOffset() > 0) {
            if (limit.getRowLimit() != Integer.MAX_VALUE) {
                parts.add(") VIEW_FOR_LIMIT WHERE ROWNUM <= ");
                parts.add((long)limit.getRowLimit() + (long)limit.getRowOffset());
            } else {
                parts.add(") VIEW_FOR_LIMIT");
            }
            parts.add(") WHERE ROWNUM_ > ");
            parts.add(limit.getRowOffset());
        } else {
            parts.add(") WHERE ROWNUM <= ");
            parts.add(limit.getRowLimit());
        }
        return parts;
    }

    private boolean isDual(NamedTable table) {
        String groupName = null;
        Table groupID = table.getMetadataObject();
        groupName = groupID != null ? SQLStringVisitor.getRecordName((AbstractMetadataRecord)groupID) : table.getName();
        return DUAL.equalsIgnoreCase(groupName);
    }

    @Override
    public boolean useAsInGroupAlias() {
        return false;
    }

    @Override
    public String getSetOperationString(SetQuery.Operation operation) {
        if (operation == SetQuery.Operation.EXCEPT) {
            return "MINUS";
        }
        return super.getSetOperationString(operation);
    }

    @Override
    public String getSourceComment(ExecutionContext context, Command command) {
        String payloadString;
        Serializable payload;
        String comment = super.getSourceComment(context, command);
        boolean usingPayloadComment = false;
        if (context != null && (payload = context.getCommandPayload()) instanceof String && (payloadString = (String)((Object)payload)).startsWith(HINT_PREFIX)) {
            int i = payloadString.indexOf(HINT_SUFFIX);
            if (i > 0 && payloadString.substring(i + 2).trim().length() == 0) {
                comment = comment + payloadString + " ";
                usingPayloadComment = true;
            } else {
                String msg = JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11003, new Object[]{"Execution Payload", payloadString});
                context.addWarning((Exception)((Object)new TranslatorException(msg)));
                LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)msg);
            }
        }
        if (!usingPayloadComment && context != null) {
            String hint = context.getSourceHint();
            if (context.getGeneralHint() != null) {
                hint = hint != null ? hint + " " + context.getGeneralHint() : context.getGeneralHint();
            }
            if (hint != null) {
                if (!hint.contains(HINT_PREFIX)) {
                    comment = comment + "/*+ " + hint + ' ' + HINT_SUFFIX + ' ';
                } else {
                    String msg = JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11003, new Object[]{"Source Hint", hint});
                    context.addWarning((Exception)((Object)new TranslatorException(msg)));
                    LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)msg);
                }
            }
        }
        if (command instanceof Select) {
            Collection col = CollectorVisitor.collectObjects(Function.class, (LanguageObject)command);
            for (Function func : col) {
                if (!func.getName().equalsIgnoreCase(RELATE)) continue;
                return comment + "/*+ ORDERED */ ";
            }
        }
        return comment;
    }

    @Override
    public String replaceElementName(String group, String element) {
        int useIndex = element.indexOf(SEQUENCE);
        if (useIndex >= 0) {
            String name = element.substring(0, useIndex);
            if (group != null) {
                return group + "." + name;
            }
            return name;
        }
        if (group != null && DUAL.equalsIgnoreCase(group) || element.equalsIgnoreCase(ROWNUM)) {
            return element;
        }
        return null;
    }

    @Override
    public boolean hasTimeType() {
        return false;
    }

    @Override
    public void bindValue(PreparedStatement stmt, Object param, Class<?> paramType, int i) throws SQLException {
        if (paramType == FixedCharType.class) {
            stmt.setObject(i, param, FIXED_CHAR_TYPE);
            return;
        }
        super.bindValue(stmt, param, paramType, i);
    }

    @Override
    public boolean useStreamsForLobs() {
        return true;
    }

    @Override
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.HIGH;
    }

    public boolean supportsOrderByNullOrdering() {
        return true;
    }

    @Override
    public SQLConversionVisitor getSQLConversionVisitor() {
        return new SQLConversionVisitor(this){

            public void visit(Select select) {
                if (select.getFrom() == null || select.getFrom().isEmpty()) {
                    select.setFrom(Arrays.asList(new NamedTable(OracleExecutionFactory.DUAL, null, null)));
                }
                super.visit(select);
            }

            @Override
            public void visit(Comparison obj) {
                if (this.isFixedChar(obj.getLeftExpression())) {
                    if (obj.getRightExpression() instanceof Literal) {
                        Literal l = (Literal)obj.getRightExpression();
                        l.setType(FixedCharType.class);
                    } else if (obj.getRightExpression() instanceof Parameter) {
                        Parameter p = (Parameter)obj.getRightExpression();
                        p.setType(FixedCharType.class);
                    }
                }
                if (obj.getLeftExpression().getType() == TypeFacility.RUNTIME_TYPES.BOOLEAN && obj.getLeftExpression() instanceof Function && obj.getRightExpression() instanceof Literal) {
                    Function f = (Function)obj.getLeftExpression();
                    if (STRING_BOOLEAN_FUNCTIONS.contains(f.getName())) {
                        Boolean b = (Boolean)((Literal)obj.getRightExpression()).getValue();
                        obj.setRightExpression((Expression)new Literal(b != null ? (b.booleanValue() ? "TRUE" : "FALSE") : null, TypeFacility.RUNTIME_TYPES.STRING));
                    }
                }
                super.visit(obj);
            }

            protected void appendRightComparison(Comparison obj) {
                if (obj.getRightExpression() instanceof Array) {
                    this.buffer.append("(");
                    super.appendRightComparison(obj);
                    this.buffer.append(")");
                } else {
                    super.appendRightComparison(obj);
                }
            }

            private boolean isFixedChar(Expression obj) {
                if (!OracleExecutionFactory.this.isOracleSuppliedDriver() || !(obj instanceof ColumnReference)) {
                    return false;
                }
                ColumnReference cr = (ColumnReference)obj;
                return cr.getType() == TypeFacility.RUNTIME_TYPES.STRING && cr.getMetadataObject() != null && ("CHAR".equalsIgnoreCase(cr.getMetadataObject().getNativeType()) || "NCHAR".equalsIgnoreCase(cr.getMetadataObject().getNativeType()));
            }

            @Override
            public void visit(In obj) {
                if (this.isFixedChar(obj.getLeftExpression())) {
                    for (Expression exp : obj.getRightExpressions()) {
                        if (exp instanceof Literal) {
                            Literal l = (Literal)exp;
                            l.setType(FixedCharType.class);
                            continue;
                        }
                        if (!(exp instanceof Parameter)) continue;
                        Parameter p = (Parameter)exp;
                        p.setType(FixedCharType.class);
                    }
                }
                super.visit(obj);
            }

            public void visit(NamedTable table) {
                this.stripDualAlias(table);
                super.visit(table);
            }

            private void stripDualAlias(NamedTable table) {
                if (table.getCorrelationName() != null && OracleExecutionFactory.this.isDual(table)) {
                    table.setCorrelationName(null);
                }
            }

            public void visit(ColumnReference obj) {
                if (obj.getTable() != null) {
                    this.stripDualAlias(obj.getTable());
                }
                super.visit(obj);
            }

            @Override
            public void visit(Call call) {
                if (OracleExecutionFactory.this.oracleSuppliedDriver && call.getResultSetColumnTypes().length > 0 && call.getMetadataObject() != null) {
                    if (call.getReturnType() == null && call.getMetadataObject().getProperty("{http://www.teiid.org/ext/relational/2012}native-query", false) == null) {
                        if (!this.setOutCursorType(call)) {
                            call.setReturnType(RefCursorType.class);
                        }
                    } else {
                        ProcedureParameter param;
                        if (call.getMetadataObject() != null && (param = call.getReturnParameter()) != null && OracleExecutionFactory.REF_CURSOR.equalsIgnoreCase(param.getNativeType())) {
                            call.setReturnType(RefCursorType.class);
                        }
                        this.setOutCursorType(call);
                    }
                }
                super.visit(call);
            }

            private boolean setOutCursorType(Call call) {
                boolean set = false;
                for (Argument arg : call.getArguments()) {
                    ProcedureParameter param;
                    if (arg.getDirection() != Argument.Direction.OUT || (param = arg.getMetadataObject()) == null || !OracleExecutionFactory.REF_CURSOR.equalsIgnoreCase(param.getNativeType())) continue;
                    arg.setType(RefCursorType.class);
                    set = true;
                }
                return set;
            }

            @Override
            public void visit(Like obj) {
                if (obj.getMode() == Like.MatchMode.REGEX) {
                    if (obj.isNegated()) {
                        this.buffer.append("NOT(");
                    }
                    this.buffer.append("REGEXP_LIKE(");
                    this.append((LanguageObject)obj.getLeftExpression());
                    this.buffer.append(", ");
                    this.append((LanguageObject)obj.getRightExpression());
                    this.buffer.append(")");
                    if (obj.isNegated()) {
                        this.buffer.append(")");
                    }
                } else {
                    super.visit(obj);
                }
            }

            public void visit(WithItem obj) {
                if (obj.getColumns() != null) {
                    List cols = obj.getColumns();
                    if (!obj.isRecusive()) {
                        obj.setColumns(null);
                        Select select = obj.getSubquery().getProjectedQuery();
                        List selectClause = select.getDerivedColumns();
                        for (int i = 0; i < cols.size(); ++i) {
                            ((DerivedColumn)selectClause.get(i)).setAlias(((ColumnReference)cols.get(i)).getName());
                        }
                    }
                }
                super.visit(obj);
            }
        };
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("COS");
        supportedFunctions.add("cot");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("CEILING");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("POWER");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("ASCII");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("concat2");
        supportedFunctions.add("||");
        supportedFunctions.add("INITCAP");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LOCATE");
        supportedFunctions.add("LOWER");
        supportedFunctions.add("LPAD");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("REPLACE");
        supportedFunctions.add("RPAD");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("TRANSLATE");
        supportedFunctions.add("trim");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("UPPER");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("DAY");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("WEEK");
        supportedFunctions.add("formattimestamp");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        supportedFunctions.add("COALESCE");
        supportedFunctions.add("round");
        supportedFunctions.add(RELATE);
        supportedFunctions.add(NEAREST_NEIGHBOR);
        supportedFunctions.add(NEAREST_NEIGHBOR_DISTANCE);
        supportedFunctions.add(WITHIN_DISTANCE);
        supportedFunctions.add(FILTER);
        supportedFunctions.add("st_asbinary");
        supportedFunctions.add("st_geomfromwkb");
        supportedFunctions.add("st_geomfromtext");
        supportedFunctions.add("st_astext");
        supportedFunctions.add("st_asgml");
        supportedFunctions.add("st_contains");
        supportedFunctions.add("st_crosses");
        supportedFunctions.add("st_disjoint");
        supportedFunctions.add("st_distance");
        supportedFunctions.add("st_intersects");
        supportedFunctions.add("st_overlaps");
        supportedFunctions.add("st_touches");
        supportedFunctions.add("st_srid");
        supportedFunctions.add("st_equals");
        return supportedFunctions;
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        if (timestampValue.getNanos() == 0) {
            String val = this.formatDateValue(timestampValue);
            val = val.substring(0, val.length() - 2);
            return "to_date('" + val + "', '" + DATETIME_FORMAT + "')";
        }
        return super.translateLiteralTimestamp(timestampValue);
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public boolean supportsElementaryOlapOperations() {
        return true;
    }

    public boolean supportsLikeRegex() {
        return true;
    }

    public void setOracleSuppliedDriver(boolean oracleNative) {
        this.oracleSuppliedDriver = oracleNative;
    }

    @TranslatorProperty(display="Oracle Supplied Driver", description="True if the driver is an Oracle supplied driver", advanced=true)
    public boolean isOracleSuppliedDriver() {
        return this.oracleSuppliedDriver;
    }

    @Override
    protected void registerSpecificTypeOfOutParameter(CallableStatement statement, Class<?> runtimeType, int index) throws SQLException {
        if (this.oracleSuppliedDriver) {
            if (runtimeType == RefCursorType.class) {
                statement.registerOutParameter(index, CURSOR_TYPE);
                return;
            }
            if (runtimeType == TypeFacility.RUNTIME_TYPES.OBJECT) {
                // empty if block
            }
        }
        super.registerSpecificTypeOfOutParameter(statement, runtimeType, index);
    }

    @Override
    public ResultSet executeStoredProcedure(CallableStatement statement, List<Argument> preparedValues, Class<?> returnType) throws SQLException {
        ResultSet rs = super.executeStoredProcedure(statement, preparedValues, returnType);
        if (!this.oracleSuppliedDriver || rs != null) {
            return rs;
        }
        if (returnType == RefCursorType.class) {
            return (ResultSet)statement.getObject(1);
        }
        for (int i = 0; i < preparedValues.size(); ++i) {
            Argument arg = preparedValues.get(i);
            if (arg.getType() != RefCursorType.class) continue;
            return (ResultSet)statement.getObject(i + (returnType == null ? 1 : 2));
        }
        return null;
    }

    public boolean supportsOnlyFormatLiterals() {
        return true;
    }

    public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
        if (format == ExecutionFactory.Format.NUMBER) {
            return false;
        }
        return this.parseModifier.supportsLiteral(literal);
    }

    public boolean supportsArrayType() {
        return true;
    }

    @Override
    @Deprecated
    protected JDBCMetdataProcessor createMetadataProcessor() {
        return (JDBCMetdataProcessor)this.getMetadataProcessor();
    }

    @Override
    public MetadataProcessor<Connection> getMetadataProcessor() {
        return new OracleMetadataProcessor();
    }

    public boolean supportsCommonTableExpressions() {
        return this.getVersion().compareTo(NINE_2) >= 0;
    }

    public boolean supportsRecursiveCommonTableExpressions() {
        return this.getVersion().compareTo(ELEVEN_2_0_4) >= 0;
    }

    @Override
    protected boolean supportsGeneratedKeys(ExecutionContext context, Command command) {
        Insert insert;
        if (command instanceof Insert && (insert = (Insert)command).getParameterValues() != null) {
            return false;
        }
        return super.supportsGeneratedKeys(context, command);
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public String createTempTable(String string, List<ColumnReference> cols, ExecutionContext context, Connection connection) throws SQLException {
        SQLException e1 = null;
        for (int i = 0; i < 5; ++i) {
            try {
                return super.createTempTable(string, cols, context, connection);
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 955) {
                    throw e;
                }
                e1 = e;
                continue;
            }
        }
        throw e1;
    }

    @Override
    public String getTemporaryTableName(String prefix) {
        return prefix + (int)(Math.random() * 1.0E7);
    }

    @Override
    public String getCreateTemporaryTablePostfix(boolean inTransaction) {
        if (!inTransaction) {
            return "ON COMMIT PRESERVE ROWS";
        }
        return super.getCreateTemporaryTablePostfix(inTransaction) + "; END;";
    }

    @Override
    public String getCreateTemporaryTableString(boolean inTransaction) {
        if (!inTransaction) {
            return super.getCreateTemporaryTableString(inTransaction);
        }
        return "DECLARE PRAGMA AUTONOMOUS_TRANSACTION; BEGIN EXECUTE IMMEDIATE '" + super.getCreateTemporaryTableString(inTransaction);
    }

    @Override
    public String getHibernateDialectClassName() {
        if (this.getVersion().getMajorVersion() >= 10) {
            return "org.hibernate.dialect.Oracle10gDialect";
        }
        return "org.hibernate.dialect.Oracle9iDialect";
    }

    public boolean supportsGroupByRollup() {
        return true;
    }

    @Override
    public Expression translateGeometrySelect(Expression expr) {
        return new Function("st_asgml", Arrays.asList(expr), TypeFacility.RUNTIME_TYPES.CLOB);
    }

    @Override
    public Object retrieveGeometryValue(ResultSet results, int paramIndex) throws SQLException {
        final Clob clob = results.getClob(paramIndex);
        if (clob != null) {
            return new GeometryInputSource(){

                public Reader getGml() throws SQLException {
                    return clob.getCharacterStream();
                }
            };
        }
        return null;
    }

    @Override
    public void intializeConnectionAfterCancel(Connection c) throws SQLException {
        c.isValid(1);
    }

    public boolean supportsCorrelatedSubqueryLimit() {
        return false;
    }

    @Override
    public boolean useColumnNamesForGeneratedKeys() {
        return true;
    }

    @Override
    public String translateLiteralBinaryType(BinaryType obj) {
        return "HEXTORAW('" + obj + "')";
    }

    public boolean supportsSubqueryInOn() {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) {
        return fromType != 14 && fromType != 17 && fromType != 15 && toType != 16 && toType != 17 && toType != 15;
    }

    @Override
    protected boolean supportsBooleanExpressions() {
        return false;
    }

    public boolean supportsSelectExpressionArrayType() {
        return false;
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        AggregateFunction af;
        if (obj instanceof AggregateFunction && (af = (AggregateFunction)obj).getName().equalsIgnoreCase(LISTAGG)) {
            OrderBy order = af.getOrderBy();
            af.setOrderBy(null);
            if (order == null) {
                return null;
            }
            return Arrays.asList(af, " WITHIN GROUP (", order, ")");
        }
        return super.translate(obj, context);
    }

    static {
        STRING_BOOLEAN_FUNCTIONS.addAll(Arrays.asList("st_disjoint", "st_contains", "st_crosses", "st_intersects", "st_overlaps", "st_touches", "st_equals"));
        CURSOR_TYPE = -10;
        FIXED_CHAR_TYPE = 999;
    }

    static final class FixedCharType {
        FixedCharType() {
        }
    }

    static final class RefCursorType {
        RefCursorType() {
        }
    }

    private final class DateAwareExtract
    extends ExtractFunctionModifier {
        private DateAwareExtract() {
        }

        @Override
        public List<?> translate(Function function) {
            Expression ex = (Expression)function.getParameters().get(0);
            if (ex instanceof ColumnReference && "date".equalsIgnoreCase(((ColumnReference)ex).getMetadataObject().getNativeType()) || !(ex instanceof ColumnReference) && !(ex instanceof Literal) && !(ex instanceof Function)) {
                ex = ConvertModifier.createConvertFunction(OracleExecutionFactory.this.getLanguageFactory(), (Expression)function.getParameters().get(0), "timestamp");
                function.getParameters().set(0, ex);
            }
            return super.translate(function);
        }
    }
}

