/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.vertica;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.AggregateFunction;
import org.teiid.language.Expression;
import org.teiid.language.LanguageObject;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;

@Translator(name="vertica", description="A translator for read/write HP Vertica Analytic Database Server")
public class VerticaExecutionFactory
extends JDBCExecutionFactory {
    public static final String VERTICA = "vertica";
    public static final String BIT_LENGTH = "BIT_LENGTH";
    public static final String BITCOUNT = "BITCOUNT";
    public static final String BITSTRING_TO_BINARY = "BITSTRING_TO_BINARY";
    public static final String BTRIM = "BTRIM";
    public static final String CHR = "CHR";
    public static final String GREATEST = "GREATEST";
    public static final String GREATESTB = "GREATESTB";
    public static final String HEX_TO_BINARY = "HEX_TO_BINARY";
    public static final String HEX_TO_INTEGER = "HEX_TO_INTEGER";
    public static final String INITCAP = "INITCAP";
    public static final String INSERT = "INSERT";
    public static final String ISUTF8 = "ISUTF8";
    public static final String LOWER = "LOWER";
    public static final String MD5 = "MD5";
    public static final String SPACE = "SPACE";
    public static final String TO_HEX = "TO_HEX";
    public static final String UPPER = "UPPER";
    public static final String CBRT = "CBRT";
    public static final String LN = "LN";
    public static final String PI = "PI";
    public static final String RANDOM = "RANDOM";
    public static final String TRUNC = "TRUNC";
    public static final String ADD_MONTHS = "ADD_MONTHS";
    public static final String AGE_IN_MONTHS = "AGE_IN_MONTHS";
    public static final String AGE_IN_YEARS = "AGE_IN_YEARS";
    public static final String CURRENT_DATE = "CURRENT_DATE";
    public static final String CURRENT_TIME = "CURRENT_TIME";
    public static final String WEEK_ISO = "WEEK_ISO";
    public static final String DATE_NAME = "DATE";
    public static final String DATEDIFF = "DATEDIFF";
    public static final String DAY = "DAY";
    public static final String GETDATE = "GETDATE";
    public static final String GETUTCDATE = "GETUTCDATE";
    public static final String ISFINITE = "ISFINITE";
    public static final String LOCALTIME = "LOCALTIME";
    public static final String LOCALTIMESTAMP = "LOCALTIMESTAMP";
    public static final String MONTHS_BETWEEN = "MONTHS_BETWEEN";
    public static final String OVERLAPS = "OVERLAPS";
    public static final String TIMESTAMPDIFF = "TIMESTAMPDIFF";

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("char", new AliasModifier(CHR));
        this.registerFunctionModifier("lcase", new AliasModifier(LOWER));
        this.registerFunctionModifier("ucase", new AliasModifier(UPPER));
        this.registerFunctionModifier("curdate", new AliasModifier(CURRENT_DATE));
        this.registerFunctionModifier("curtime", new AliasModifier(CURRENT_TIME));
        this.registerFunctionModifier("week", new AliasModifier(WEEK_ISO));
        this.addPushDownFunction(VERTICA, BIT_LENGTH, "integer", new String[]{"string"});
        this.addPushDownFunction(VERTICA, BITCOUNT, "byte", new String[]{"byte"});
        this.addPushDownFunction(VERTICA, BITSTRING_TO_BINARY, "byte", new String[]{"string"});
        this.addPushDownFunction(VERTICA, BTRIM, "string", new String[]{"string", "string"});
        this.addPushDownFunction(VERTICA, GREATEST, "object", new String[]{"object"});
        this.addPushDownFunction(VERTICA, GREATESTB, "byte", new String[]{"object"});
        this.addPushDownFunction(VERTICA, HEX_TO_BINARY, "byte", new String[]{"string"});
        this.addPushDownFunction(VERTICA, HEX_TO_INTEGER, "integer", new String[]{"string"});
        this.addPushDownFunction(VERTICA, INITCAP, "string", new String[]{"string"});
        this.addPushDownFunction(VERTICA, INSERT, "string", new String[]{"string", "integer", "integer", "string"});
        this.addPushDownFunction(VERTICA, ISUTF8, "boolean", new String[]{"string"});
        this.addPushDownFunction(VERTICA, MD5, "string", new String[]{"string"});
        this.addPushDownFunction(VERTICA, SPACE, "string", new String[]{"integer"});
        this.addPushDownFunction(VERTICA, TO_HEX, "string", new String[]{"integer"});
        this.addPushDownFunction(VERTICA, CBRT, "double", new String[]{"double"});
        this.addPushDownFunction(VERTICA, LN, "double", new String[]{"double"});
        this.addPushDownFunction(VERTICA, PI, "double", new String[0]);
        this.addPushDownFunction(VERTICA, RANDOM, "float", new String[0]);
        this.addPushDownFunction(VERTICA, TRUNC, "double", new String[]{"double"});
        this.addPushDownFunction(VERTICA, ADD_MONTHS, "date", new String[]{"date", "integer"});
        this.addPushDownFunction(VERTICA, AGE_IN_MONTHS, "integer", new String[]{"timestamp", "timestamp"});
        this.addPushDownFunction(VERTICA, AGE_IN_YEARS, "integer", new String[]{"timestamp", "timestamp"});
        this.addPushDownFunction(VERTICA, DATE_NAME, "date", new String[]{"object"});
        this.addPushDownFunction(VERTICA, DATEDIFF, "integer", new String[]{"string", "date", "date"});
        this.addPushDownFunction(VERTICA, DAY, "integer", new String[]{"object"});
        this.addPushDownFunction(VERTICA, GETDATE, "timestamp", new String[0]);
        this.addPushDownFunction(VERTICA, GETUTCDATE, "timestamp", new String[0]);
        this.addPushDownFunction(VERTICA, ISFINITE, "boolean", new String[]{"timestamp"});
        this.addPushDownFunction(VERTICA, LOCALTIME, "time", new String[0]);
        this.addPushDownFunction(VERTICA, LOCALTIMESTAMP, "timestamp", new String[0]);
        this.addPushDownFunction(VERTICA, MONTHS_BETWEEN, "integer", new String[]{"date", "date"});
        this.addPushDownFunction(VERTICA, OVERLAPS, "boolean", new String[]{"date", "date"});
        this.addPushDownFunction(VERTICA, TIMESTAMPDIFF, "integer", new String[]{"timestamp", "timestamp"});
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ascii");
        supportedFunctions.add("char");
        supportedFunctions.add("concat");
        supportedFunctions.add("lcase");
        supportedFunctions.add("lpad");
        supportedFunctions.add("rpad");
        supportedFunctions.add("length");
        supportedFunctions.add("left");
        supportedFunctions.add("right");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("replace");
        supportedFunctions.add("substring");
        supportedFunctions.add("ucase");
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("cos");
        supportedFunctions.add("cot");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("log");
        supportedFunctions.add("mod");
        supportedFunctions.add("power");
        supportedFunctions.add("round");
        supportedFunctions.add("sign");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add("curdate");
        supportedFunctions.add("curtime");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("month");
        supportedFunctions.add("monthname");
        supportedFunctions.add("now");
        supportedFunctions.add("quarter");
        supportedFunctions.add("second");
        supportedFunctions.add("week");
        supportedFunctions.add("year");
        return supportedFunctions;
    }

    @Override
    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    @Override
    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        AggregateFunction agg;
        if (obj instanceof AggregateFunction && (agg = (AggregateFunction)obj).getParameters().size() == 1 && (agg.getName().equalsIgnoreCase("MIN") || agg.getName().equalsIgnoreCase("MAX")) && TypeFacility.RUNTIME_TYPES.BOOLEAN.equals(((Expression)agg.getParameters().get(0)).getType())) {
            return Arrays.asList("CAST(", agg.getName(), "(CAST(", agg.getParameters().get(0), " AS tinyint)) AS boolean)");
        }
        return super.translate(obj, context);
    }
}

