/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.teiid.core.util.StringUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.jdbc.JDBCMetdataProcessor;

public final class OracleMetadataProcessor
extends JDBCMetdataProcessor {
    private boolean useGeometryType;
    private boolean useIntegralTypes;

    @Override
    protected String getRuntimeType(int type, String typeName, int precision, int scale) {
        if (type == 12 || type == 1111 && typeName != null && StringUtil.indexOfIgnoreCase((String)typeName, (String)"char") > -1) {
            return "string";
        }
        if (this.useGeometryType && "SDO_GEOMETRY".equalsIgnoreCase(typeName)) {
            return "geometry";
        }
        if (this.useIntegralTypes && scale == 0 && (type == 2 || type == 3)) {
            if (precision <= 2) {
                return "byte";
            }
            if (precision <= 4) {
                return "short";
            }
            if (precision <= 9) {
                return "integer";
            }
            if (precision <= 18) {
                return "long";
            }
            return "biginteger";
        }
        return super.getRuntimeType(type, typeName, precision, scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getTableStatistics(Connection conn, String catalog, String schema, String name, Table table) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("select num_rows from ALL_TABLES where owner = ? AND table_name = ?");
            stmt.setString(1, schema);
            stmt.setString(2, name);
            rs = stmt.executeQuery();
            if (rs.next()) {
                int cardinality = rs.getInt(1);
                if (!rs.wasNull()) {
                    table.setCardinality(cardinality);
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    protected boolean getIndexInfoForTable(String catalogName, String schemaName, String tableName, boolean uniqueOnly, boolean approximateIndexes, String tableType) {
        return approximateIndexes || !"VIEW".equalsIgnoreCase(tableType);
    }

    @TranslatorProperty(display="Use Geometry Type", category=TranslatorProperty.PropertyType.IMPORT, description="Use Teiid Geometry Type rather than an Object/Struct for SDO_GEOMETRY")
    public boolean isUseGeometryType() {
        return this.useGeometryType;
    }

    public void setUseGeometryType(boolean useGeometryType) {
        this.useGeometryType = useGeometryType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getGeometryMetadata(Column c, Connection conn, String tableCatalog, String tableSchema, String tableName, String columnName) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("select coord_dimension, srid from ALL_GEOMETRY_COLUMNS where f_table_schema=? and f_table_name=? and f_geometry_column=?");
            ps.setString(1, tableSchema);
            ps.setString(2, tableName);
            ps.setString(3, columnName);
            rs = ps.executeQuery();
            if (rs.next()) {
                c.setProperty("{http://www.teiid.org/translator/spatial/2015}coord_dimension", rs.getString(1));
                c.setProperty("{http://www.teiid.org/translator/spatial/2015}srid", rs.getString(2));
            }
        }
        catch (SQLException e) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Throwable)e, (Object[])new Object[]{"Could not get geometry metadata for column", tableSchema, tableName, columnName});
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    protected String getFullyQualifiedName(String catalogName, String schemaName, String objectName, boolean quoted) {
        if (catalogName != null && catalogName.length() > 0) {
            if (quoted) {
                String fullName = this.quoteName(catalogName) + '.' + this.quoteName(objectName);
                if (this.isUseQualifiedName() && schemaName != null && schemaName.length() > 0) {
                    fullName = (quoted ? this.quoteName(schemaName) : schemaName) + '.' + fullName;
                }
                return fullName;
            }
            return super.getFullyQualifiedName(schemaName, catalogName, objectName, quoted);
        }
        return super.getFullyQualifiedName(catalogName, schemaName, objectName, quoted);
    }

    @TranslatorProperty(display="Use Integral Types", category=TranslatorProperty.PropertyType.IMPORT, description="Use integral types rather than decimal when the scale is 0.")
    public boolean isUseIntegralTypes() {
        return this.useIntegralTypes;
    }

    public void setUseIntegralTypes(boolean useIntegralTypes) {
        this.useIntegralTypes = useIntegralTypes;
    }

    @Override
    protected String getSequenceQuery() {
        return "select null as sequence_catalog, sequence_owner as sequence_schema, sequence_name from (select sequence_name, sequence_owner from all_sequences union select synonym_name, table_owner from all_synonyms us, all_sequences asq where asq.sequence_name = us.table_name and asq.sequence_owner = us.table_owner) where sequence_owner like ? and sequence_name like ?";
    }

    @Override
    protected String getSequenceNextSQL(String fullyQualifiedName) {
        return fullyQualifiedName + ".nextval";
    }
}

