/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.pi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Table;
import org.teiid.translator.jdbc.JDBCMetdataProcessor;

public class PIMetadataProcessor
extends JDBCMetdataProcessor {
    static Pattern guidPattern = Pattern.compile(Pattern.quote("guid"), 2);
    @ExtensionMetadataProperty(applicable={Table.class, Procedure.class}, datatype=String.class, display="Is Table Value Function", description="Marks the table as Table Value Function")
    public static final String TVF = "{http://www.teiid.org/translator/pi/2016}TVF";

    public PIMetadataProcessor() {
        this.setStartQuoteString("[");
        this.setEndQuoteString("]");
    }

    @Override
    protected String getRuntimeType(int type, String typeName, int precision, int scale) {
        String rtType = super.getRuntimeType(type, typeName, precision);
        if (typeName != null && guidPattern.matcher(typeName).find()) {
            rtType = "string";
        }
        return rtType;
    }

    @Override
    public void getConnectorMetadata(Connection conn, MetadataFactory metadataFactory) throws SQLException {
        super.getConnectorMetadata(conn, metadataFactory);
        for (String name : metadataFactory.getSchema().getTables().keySet()) {
            if (!name.startsWith("ft_")) continue;
            Table table = metadataFactory.getSchema().getTable(name);
            table.setProperty(TVF, "true");
        }
        for (String name : metadataFactory.getSchema().getProcedures().keySet()) {
            Procedure proc = metadataFactory.getSchema().getProcedure(name);
            proc.setProperty(TVF, "true");
        }
    }
}

