/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.hsql;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.hsql.HsqlExecutionFactory;

public class TestHsqlTranslator {
    private static HsqlExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        TRANSLATOR = new HsqlExecutionFactory();
        TRANSLATOR.start();
    }

    @Ignore(value="the hibernate dialect has the version set reflectively so we can't set version 2")
    @Test
    public void testTempTable() throws Exception {
        Assert.assertEquals((Object)"declare local temporary table foo (COL1 integer, COL2 varchar(100)) ", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)TRANSLATOR, true));
    }

    @Test
    public void testVarcharCast() throws Exception {
        String input = "select cast(SmallA.IntKey as varchar) from bqt1.smalla";
        String output = "SELECT cast(SmallA.IntKey AS varchar(4000)) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSelectWithoutFrom() throws Exception {
        String input = "select 1";
        String output = "VALUES(1)";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testJoinNesting() throws Exception {
        String input = "select a.intkey from (BQT1.Smalla a left outer join bqt1.smallb b on a.intkey = b.intkey) inner join (bqt1.mediuma ma inner join bqt1.mediumb mb on mb.intkey = ma.intkey) on a.intkey = mb.intkey";
        String output = "SELECT a.IntKey FROM (SmallA AS a LEFT OUTER JOIN SmallB AS b ON a.IntKey = b.IntKey) INNER JOIN (MediumA AS ma INNER JOIN MediumB AS mb ON mb.IntKey = ma.IntKey) ON a.IntKey = mb.IntKey";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }
}

