/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCPlugin;

public class JDBCMetadataProcessor
implements MetadataProcessor<Connection> {
    @ExtensionMetadataProperty(applicable={FunctionMethod.class}, datatype=String.class, display="Sequence Used By This Function")
    static final String SEQUENCE = "{http://www.teiid.org/ext/relational/2012}sequence";
    private boolean importProcedures;
    private boolean importKeys = true;
    private boolean importForeignKeys = true;
    private boolean importIndexes;
    private boolean importSequences;
    private String procedureNamePattern;
    private String sequenceNamePattern;
    protected boolean useFullSchemaName = true;
    private String[] tableTypes;
    private String tableNamePattern;
    private String catalog;
    private String schemaPattern;
    private boolean importApproximateIndexes = true;
    private boolean widenUnsingedTypes = true;
    private boolean quoteNameInSource = true;
    private boolean useProcedureSpecificName;
    private boolean useCatalogName = true;
    private String catalogSeparator = String.valueOf('.');
    private boolean autoCreateUniqueConstraints = true;
    private boolean useQualifiedName = true;
    private Set<String> unsignedTypes = new HashSet<String>();
    private String startQuoteString;
    private String endQuoteString;
    private Pattern excludeTables;
    private Pattern excludeProcedures;
    private Pattern excludeSequences;
    private int excludedTables;
    private boolean useAnyIndexCardinality;
    private boolean importStatistics;
    private String columnNamePattern;
    private boolean importRowIdAsBinary;
    private boolean importLargeAsLob;
    private boolean useIntegralTypes;

    public void process(MetadataFactory metadataFactory, Connection conn) throws TranslatorException {
        try {
            this.getConnectorMetadata(conn, metadataFactory);
        }
        catch (SQLException e) {
            throw new TranslatorException((BundleUtil.Event)JDBCPlugin.Event.TEIID11010, (Throwable)e);
        }
    }

    private String getDefaultQuoteStr(DatabaseMetaData metadata, String quoteString) {
        if (quoteString == null) {
            try {
                quoteString = metadata.getIdentifierQuoteString();
            }
            catch (SQLException e) {
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)e, (Object)"Assuming identifier quoting not supported");
            }
        }
        if (quoteString != null && quoteString.trim().length() == 0) {
            quoteString = null;
        }
        return quoteString;
    }

    public void getConnectorMetadata(Connection conn, MetadataFactory metadataFactory) throws SQLException {
        String separator;
        DatabaseMetaData metadata = conn.getMetaData();
        this.startQuoteString = this.getDefaultQuoteStr(metadata, this.startQuoteString);
        this.endQuoteString = this.getDefaultQuoteStr(metadata, this.endQuoteString);
        if (this.widenUnsingedTypes) {
            ResultSet rs = null;
            try {
                rs = metadata.getTypeInfo();
            }
            catch (SQLException e) {
                LogManager.logWarning((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11021, new Object[0]));
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    boolean unsigned = rs.getBoolean(10);
                    if (!unsigned || !this.isUnsignedTypeName(name)) continue;
                    this.unsignedTypes.add(name);
                }
            }
        }
        if (this.useCatalogName && (separator = metadata.getCatalogSeparator()) != null && !separator.isEmpty()) {
            this.catalogSeparator = separator;
        }
        Map<String, TableInfo> tableMap = this.getTables(metadataFactory, metadata, conn);
        LinkedHashSet<TableInfo> tables = new LinkedHashSet<TableInfo>(tableMap.values());
        if (this.importKeys) {
            this.getPrimaryKeys(metadataFactory, metadata, tables);
            this.getIndexes(metadataFactory, metadata, tables, !this.importIndexes);
            if (this.importForeignKeys) {
                this.getForeignKeys(metadataFactory, metadata, tables, tableMap);
            }
        } else if (this.importIndexes) {
            this.getIndexes(metadataFactory, metadata, tables, false);
        }
        if (this.importStatistics) {
            for (TableInfo tableInfo : tables) {
                if (tableInfo.table.getCardinality() != -1) continue;
                this.getTableStatistics(conn, tableInfo.catalog, tableInfo.schema, tableInfo.name, tableInfo.table);
            }
        }
        if (this.importProcedures) {
            this.getProcedures(metadataFactory, metadata);
        }
        if (this.importSequences) {
            this.getSequences(metadataFactory, conn);
        }
    }

    protected boolean isUnsignedTypeName(String name) {
        return true;
    }

    protected void getTableStatistics(Connection conn, String catalog, String schema, String name, Table table) throws SQLException {
    }

    private void getProcedures(MetadataFactory metadataFactory, DatabaseMetaData metadata) throws SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"JDBCMetadataProcessor - Importing procedures");
        ResultSet procedures = metadata.getProcedures(this.catalog, this.schemaPattern, this.procedureNamePattern);
        int rsColumns = procedures.getMetaData().getColumnCount();
        while (procedures.next()) {
            String procedureName;
            String procedureCatalog = procedures.getString(1);
            String procedureSchema = procedures.getString(2);
            String nameInSource = procedureName = procedures.getString(3);
            if (this.useProcedureSpecificName && rsColumns >= 9 && (procedureName = procedures.getString(9)) == null) {
                procedureName = nameInSource;
            }
            String fullProcedureName = this.getFullyQualifiedName(procedureCatalog, procedureSchema, procedureName);
            if (this.excludeProcedures != null && this.excludeProcedures.matcher(fullProcedureName).matches()) continue;
            Procedure procedure = metadataFactory.addProcedure(this.useFullSchemaName ? fullProcedureName : procedureName);
            procedure.setNameInSource(this.getFullyQualifiedName(procedureCatalog, procedureSchema, nameInSource, true));
            ResultSet columns = metadata.getProcedureColumns(procedureCatalog, procedureSchema, procedureName, null);
            block10: while (columns.next()) {
                String columnName = columns.getString(4);
                short columnType = 0;
                try {
                    columnType = columns.getShort(5);
                }
                catch (SQLException e) {
                    int type = columns.getInt(5);
                    columnType = new Integer(type).shortValue();
                }
                int sqlType = columns.getInt(6);
                String typeName = columns.getString(7);
                sqlType = this.checkForUnsigned(sqlType, typeName);
                if (columnType == 0) continue;
                Column record = null;
                int precision = columns.getInt(8);
                int scale = columns.getInt(10);
                String runtimeType = this.getRuntimeType(sqlType, typeName, precision, scale);
                switch (columnType) {
                    case 3: {
                        record = metadataFactory.addProcedureResultSetColumn(columnName, runtimeType, procedure);
                        break;
                    }
                    case 1: {
                        record = metadataFactory.addProcedureParameter(columnName, runtimeType, ProcedureParameter.Type.In, procedure);
                        break;
                    }
                    case 2: {
                        record = metadataFactory.addProcedureParameter(columnName, runtimeType, ProcedureParameter.Type.InOut, procedure);
                        break;
                    }
                    case 4: {
                        record = metadataFactory.addProcedureParameter(columnName, runtimeType, ProcedureParameter.Type.Out, procedure);
                        break;
                    }
                    case 5: {
                        if (columnName == null) {
                            columnName = "return";
                        }
                        record = metadataFactory.addProcedureParameter(columnName, runtimeType, ProcedureParameter.Type.ReturnValue, procedure);
                        break;
                    }
                    default: {
                        continue block10;
                    }
                }
                record.setNameInSource(this.quoteName(columnName));
                record.setNativeType(typeName);
                record.setPrecision(precision);
                record.setLength(columns.getInt(9));
                record.setScale(scale);
                record.setRadix(columns.getInt(11));
                record.setNullType(BaseColumn.NullType.values()[columns.getInt(12)]);
                record.setAnnotation(columns.getString(13));
            }
        }
        procedures.close();
    }

    private int checkForUnsigned(int sqlType, String typeName) {
        if (this.widenUnsingedTypes && this.unsignedTypes.contains(typeName)) {
            switch (sqlType) {
                case -6: {
                    sqlType = 5;
                    break;
                }
                case 5: {
                    sqlType = 4;
                    break;
                }
                case 4: {
                    sqlType = -5;
                }
            }
        }
        return sqlType;
    }

    private Map<String, TableInfo> getTables(MetadataFactory metadataFactory, DatabaseMetaData metadata, Connection conn) throws SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"JDBCMetadataProcessor - Importing tables");
        ResultSet tables = metadata.getTables(this.catalog, this.schemaPattern, this.tableNamePattern, this.tableTypes);
        HashMap<String, TableInfo> tableMap = new HashMap<String, TableInfo>();
        while (tables.next()) {
            String tableCatalog = tables.getString(1);
            String tableSchema = tables.getString(2);
            String tableName = tables.getString(3);
            String remarks = tables.getString(5);
            String fullName = this.getFullyQualifiedName(tableCatalog, tableSchema, tableName);
            if (this.shouldExclude(fullName)) {
                ++this.excludedTables;
                continue;
            }
            Table table = this.addTable(metadataFactory, tableCatalog, tableSchema, tableName, remarks, fullName, tables);
            if (table == null) continue;
            TableInfo ti = new TableInfo(tableCatalog, tableSchema, tableName, table);
            ti.type = tables.getString(4);
            tableMap.put(fullName, ti);
            tableMap.put(tableName, ti);
        }
        tables.close();
        this.getColumns(metadataFactory, metadata, tableMap, conn);
        return tableMap;
    }

    protected boolean shouldExclude(String fullName) {
        return this.excludeTables != null && this.excludeTables.matcher(fullName).matches();
    }

    protected Table addTable(MetadataFactory metadataFactory, String tableCatalog, String tableSchema, String tableName, String remarks, String fullName, ResultSet tables) throws SQLException {
        return this.addTable(metadataFactory, tableCatalog, tableSchema, tableName, remarks, fullName);
    }

    protected Table addTable(MetadataFactory metadataFactory, String tableCatalog, String tableSchema, String tableName, String remarks, String fullName) {
        Table table = metadataFactory.addTable(this.useFullSchemaName ? fullName : tableName);
        table.setNameInSource(this.getFullyQualifiedName(tableCatalog, tableSchema, tableName, true));
        table.setSupportsUpdate(true);
        table.setAnnotation(remarks);
        return table;
    }

    private void getColumns(MetadataFactory metadataFactory, DatabaseMetaData metadata, Map<String, TableInfo> tableMap, Connection conn) throws SQLException {
        boolean singleSchema;
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"JDBCMetadataProcessor - Importing columns");
        boolean bl = singleSchema = this.schemaPattern != null && !this.schemaPattern.contains("_") && !this.schemaPattern.contains("%");
        if (this.excludeTables == null && this.schemaPattern == null && this.tableNamePattern == null || singleSchema && this.tableNamePattern == null && (this.excludeTables == null || (double)(tableMap.size() / 2) > Math.sqrt(tableMap.size() / 2 + this.excludedTables))) {
            ResultSet columns = metadata.getColumns(this.catalog, this.schemaPattern, this.tableNamePattern, this.columnNamePattern);
            this.processColumns(metadataFactory, tableMap, columns, conn);
        } else {
            for (TableInfo ti : new LinkedHashSet<TableInfo>(tableMap.values())) {
                ResultSet columns = metadata.getColumns(ti.catalog, ti.schema, ti.name, this.columnNamePattern);
                this.processColumns(metadataFactory, tableMap, columns, conn);
            }
        }
    }

    private void processColumns(MetadataFactory metadataFactory, Map<String, TableInfo> tableMap, ResultSet columns, Connection conn) throws SQLException {
        int rsColumns = columns.getMetaData().getColumnCount();
        while (columns.next()) {
            Column c;
            String tableName;
            String tableSchema;
            String tableCatalog = columns.getString(1);
            String fullTableName = this.getFullyQualifiedName(tableCatalog, tableSchema = columns.getString(2), tableName = columns.getString(3));
            TableInfo tableInfo = tableMap.get(fullTableName);
            if (tableInfo == null && (tableInfo = tableMap.get(tableName)) == null || !TypeFacility.RUNTIME_TYPES.GEOMETRY.equals((c = this.addColumn(columns, tableInfo.table, metadataFactory, rsColumns)).getJavaType())) continue;
            String columnName = columns.getString(4);
            this.getGeometryMetadata(c, conn, tableCatalog, tableSchema, tableName, columnName);
        }
        columns.close();
    }

    protected void getGeometryMetadata(Column c, Connection conn, String tableCatalog, String tableSchema, String tableName, String columnName) {
    }

    protected Column addColumn(ResultSet columns, Table table, MetadataFactory metadataFactory, int rsColumns) throws SQLException {
        String columnName = columns.getString(4);
        int type = columns.getInt(5);
        String typeName = columns.getString(6);
        int columnSize = columns.getInt(7);
        int scale = columns.getInt(9);
        String runtimeType = this.getRuntimeType(type, typeName, columnSize, scale);
        Column column = metadataFactory.addColumn(columnName, runtimeType, (ColumnSet)table);
        column.setNameInSource(this.quoteName(columnName));
        column.setPrecision(columnSize);
        column.setScale(scale);
        column.setLength(columnSize);
        column.setNativeType(typeName);
        column.setRadix(columns.getInt(10));
        column.setNullType(BaseColumn.NullType.values()[columns.getInt(11)]);
        column.setUpdatable(true);
        String remarks = columns.getString(12);
        column.setAnnotation(remarks);
        String defaultValue = columns.getString(13);
        column.setDefaultValue(defaultValue);
        if (defaultValue != null && type == -7 && "boolean".equals(runtimeType)) {
            if (defaultValue.length() == 1) {
                char charIntVal = defaultValue.charAt(0);
                if (charIntVal == '\u0000') {
                    column.setDefaultValue(Boolean.FALSE.toString());
                } else if (charIntVal == '\u0001') {
                    column.setDefaultValue(Boolean.TRUE.toString());
                }
            } else {
                String trimedDefault = defaultValue.trim();
                if (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
                    trimedDefault = defaultValue.substring(1, defaultValue.length() - 1);
                }
                column.setDefaultValue(trimedDefault);
            }
        }
        column.setCharOctetLength(columns.getInt(16));
        if (rsColumns >= 23) {
            column.setAutoIncremented("YES".equalsIgnoreCase(columns.getString(23)));
        }
        return column;
    }

    protected String getRuntimeType(int type, String typeName, int precision, int scale) {
        if (this.useIntegralTypes && scale == 0 && (type == 2 || type == 3)) {
            if (precision <= 2) {
                return "byte";
            }
            if (precision <= 4) {
                return "short";
            }
            if (precision <= 9) {
                return "integer";
            }
            if (precision <= 18) {
                return "long";
            }
            return "biginteger";
        }
        return this.getRuntimeType(type, typeName, precision);
    }

    protected String getRuntimeType(int type, String typeName, int precision) {
        if (this.importRowIdAsBinary && type == -8) {
            return "varbinary";
        }
        if (type == -7 && precision > 1) {
            type = -2;
        }
        type = this.checkForUnsigned(type, typeName);
        String result = TypeFacility.getDataTypeNameFromSQLType((int)type);
        if (this.importLargeAsLob) {
            if (result.equals("string") && precision > DataTypeManager.MAX_STRING_LENGTH) {
                result = "clob";
            } else if (result.equals("varbinary") && precision > DataTypeManager.MAX_VARBINARY_BYTES) {
                result = "blob";
            }
        }
        return result;
    }

    protected String quoteName(String name) {
        if (this.quoteNameInSource && this.startQuoteString != null && this.endQuoteString != null) {
            String str = StringUtil.replaceAll((String)name, (String)this.startQuoteString, (String)(this.startQuoteString + this.startQuoteString));
            str = StringUtil.replaceAll((String)str, (String)this.endQuoteString, (String)(this.endQuoteString + this.endQuoteString));
            return this.startQuoteString + str + this.endQuoteString;
        }
        return name;
    }

    private void getPrimaryKeys(MetadataFactory metadataFactory, DatabaseMetaData metadata, Collection<TableInfo> tables) throws SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"JDBCMetadataProcessor - Importing primary keys");
        for (TableInfo tableInfo : tables) {
            ResultSet pks = metadata.getPrimaryKeys(tableInfo.catalog, tableInfo.schema, tableInfo.name);
            TreeMap<Short, String> keyColumns = null;
            String pkName = null;
            while (pks.next()) {
                String columnName = pks.getString(4);
                short seqNum = this.safeGetShort(pks, 5);
                if (keyColumns == null) {
                    keyColumns = new TreeMap<Short, String>();
                }
                keyColumns.put(seqNum, columnName);
                if (pkName != null || (pkName = pks.getString(6)) != null) continue;
                pkName = "PK_" + tableInfo.table.getName().toUpperCase();
            }
            if (keyColumns != null) {
                metadataFactory.addPrimaryKey(pkName, new ArrayList(keyColumns.values()), tableInfo.table);
            }
            pks.close();
        }
    }

    private short safeGetShort(ResultSet rs, int pos) throws SQLException {
        short val;
        try {
            val = rs.getShort(pos);
        }
        catch (SQLException e) {
            int valInt = rs.getInt(pos);
            if (valInt > Short.MAX_VALUE) {
                throw new SQLException("invalid short value " + valInt);
            }
            val = (short)valInt;
        }
        return val;
    }

    private void getForeignKeys(MetadataFactory metadataFactory, DatabaseMetaData metadata, Collection<TableInfo> tables, Map<String, TableInfo> tableMap) throws SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"JDBCMetadataProcessor - Importing foreign keys");
        for (TableInfo tableInfo : tables) {
            ResultSet fks = null;
            try {
                fks = metadata.getImportedKeys(tableInfo.catalog, tableInfo.schema, tableInfo.name);
            }
            catch (SQLException e) {
                if (tableInfo.type != null && StringUtil.indexOfIgnoreCase((String)tableInfo.type, (String)"TABLE") < 0) {
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)e, (Object)"skipping foreign keys for non-table", (Object)tableInfo.table.getFullName());
                    continue;
                }
                LogManager.logWarning((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11026, new Object[]{tableInfo.table.getFullName(), tableInfo.type}));
                continue;
            }
            HashMap<String, FKInfo> allKeys = new HashMap<String, FKInfo>();
            while (fks.next()) {
                FKInfo fkInfo;
                String columnName = fks.getString(8);
                short seqNum = this.safeGetShort(fks, 9);
                String pkColumnName = fks.getString(4);
                String fkName = fks.getString(12);
                if (fkName == null) {
                    fkName = "FK_" + tableInfo.table.getName().toUpperCase();
                }
                if ((fkInfo = (FKInfo)allKeys.get(fkName)) == null) {
                    fkInfo = new FKInfo();
                    allKeys.put(fkName, fkInfo);
                    String tableCatalog = fks.getString(1);
                    String tableSchema = fks.getString(2);
                    String tableName = fks.getString(3);
                    String fullTableName = this.getFullyQualifiedName(tableCatalog, tableSchema, tableName);
                    fkInfo.pkTable = tableMap.get(fullTableName);
                    if (fkInfo.pkTable == null) {
                        fkInfo.valid = false;
                        continue;
                    }
                }
                if (!fkInfo.valid) continue;
                if (fkInfo.keyColumns.put(seqNum, columnName) != null) {
                    fkInfo.valid = false;
                }
                fkInfo.referencedKeyColumns.put(seqNum, pkColumnName);
            }
            for (Map.Entry entry : allKeys.entrySet()) {
                FKInfo info = (FKInfo)entry.getValue();
                if (!info.valid) continue;
                KeyRecord record = this.autoCreateUniqueKeys(this.autoCreateUniqueConstraints, metadataFactory, (String)entry.getKey(), info.referencedKeyColumns, info.pkTable.table);
                ForeignKey fk = metadataFactory.addForiegnKey((String)entry.getKey(), new ArrayList<String>(info.keyColumns.values()), new ArrayList<String>(info.referencedKeyColumns.values()), info.pkTable.table.getName(), tableInfo.table);
                if (record == null) continue;
                fk.setReferenceKey(record);
            }
            fks.close();
        }
    }

    private KeyRecord autoCreateUniqueKeys(boolean create, MetadataFactory factory, String name, TreeMap<Short, String> referencedKeyColumns, Table pkTable) {
        if (referencedKeyColumns != null && pkTable.getPrimaryKey() == null && pkTable.getUniqueKeys().isEmpty()) {
            factory.addIndex(name + "_unique", false, new ArrayList<String>(referencedKeyColumns.values()), pkTable);
        }
        KeyRecord uniqueKey = null;
        if (referencedKeyColumns == null) {
            uniqueKey = pkTable.getPrimaryKey();
        } else {
            for (KeyRecord record : pkTable.getUniqueKeys()) {
                if (!this.keyMatches(new ArrayList<String>(referencedKeyColumns.values()), record)) continue;
                uniqueKey = record;
                break;
            }
            if (uniqueKey == null && pkTable.getPrimaryKey() != null && this.keyMatches(new ArrayList<String>(referencedKeyColumns.values()), pkTable.getPrimaryKey())) {
                uniqueKey = pkTable.getPrimaryKey();
            }
        }
        if (uniqueKey == null && create) {
            uniqueKey = factory.addIndex(name + "_unique", false, new ArrayList<String>(referencedKeyColumns.values()), pkTable);
        }
        return uniqueKey;
    }

    private boolean keyMatches(List<String> names, KeyRecord record) {
        if (names.size() != record.getColumns().size()) {
            return false;
        }
        for (int i = 0; i < names.size(); ++i) {
            if (names.get(i).equals(((Column)record.getColumns().get(i)).getName())) continue;
            return false;
        }
        return true;
    }

    void getIndexes(MetadataFactory metadataFactory, DatabaseMetaData metadata, Collection<TableInfo> tables, boolean uniqueOnly) throws SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"JDBCMetadataProcessor - Importing index info");
        for (TableInfo tableInfo : tables) {
            if (!this.getIndexInfoForTable(tableInfo.catalog, tableInfo.schema, tableInfo.name, uniqueOnly, this.importApproximateIndexes, tableInfo.type)) continue;
            ResultSet indexInfo = metadata.getIndexInfo(tableInfo.catalog, tableInfo.schema, tableInfo.name, uniqueOnly, this.importApproximateIndexes);
            TreeMap<Short, String> indexColumns = null;
            String indexName = null;
            short savedOrdinalPosition = Short.MAX_VALUE;
            boolean nonUnique = false;
            boolean valid = true;
            boolean cardinalitySet = false;
            while (indexInfo.next()) {
                short type = indexInfo.getShort(7);
                if (type == 0) {
                    tableInfo.table.setCardinality(this.getCardinality(indexInfo));
                    cardinalitySet = true;
                    continue;
                }
                short ordinalPosition = indexInfo.getShort(8);
                if (this.useAnyIndexCardinality && !cardinalitySet) {
                    long cardinality = this.getCardinality(indexInfo);
                    tableInfo.table.setCardinality(Math.max(cardinality, (long)tableInfo.table.getCardinalityAsFloat()));
                }
                if (ordinalPosition <= savedOrdinalPosition) {
                    if (!(!valid || indexColumns == null || uniqueOnly && nonUnique || indexName != null && !nonUnique && tableInfo.table.getPrimaryKey() != null && indexName.equals(tableInfo.table.getPrimaryKey().getName()))) {
                        metadataFactory.addIndex(indexName, nonUnique, new ArrayList(indexColumns.values()), tableInfo.table);
                    }
                    indexColumns = new TreeMap<Short, String>();
                    indexName = null;
                    valid = true;
                }
                savedOrdinalPosition = ordinalPosition;
                String columnName = indexInfo.getString(9);
                if (valid && columnName == null || tableInfo.table.getColumnByName(columnName) == null) {
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Skipping the import of non-simple index", (Object)indexInfo.getString(6));
                    valid = false;
                }
                nonUnique = indexInfo.getBoolean(4);
                indexColumns.put(ordinalPosition, columnName);
                if (indexName != null || (indexName = indexInfo.getString(6)) != null) continue;
                indexName = "NDX_" + tableInfo.table.getName().toUpperCase();
            }
            if (!(!valid || indexColumns == null || uniqueOnly && nonUnique || indexName != null && !nonUnique && tableInfo.table.getPrimaryKey() != null && indexName.equals(tableInfo.table.getPrimaryKey().getName()))) {
                metadataFactory.addIndex(indexName, nonUnique, new ArrayList(indexColumns.values()), tableInfo.table);
            }
            indexInfo.close();
        }
    }

    private long getCardinality(ResultSet indexInfo) throws SQLException {
        long result = -1L;
        try {
            result = indexInfo.getLong(11);
        }
        catch (SQLException e) {
            result = indexInfo.getInt(11);
        }
        if (indexInfo.wasNull()) {
            return -1L;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSequences(MetadataFactory metadataFactory, Connection conn) throws SQLException {
        ResultSet sequences = this.executeSequenceQuery(conn);
        if (sequences == null) {
            LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)"JDBCMetadataProcessor - sequence import requested, but is not supported by the translator.");
            return;
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"JDBCMetadataProcessor - Importing sequences");
        try {
            while (sequences.next()) {
                String sequenceCatalog = sequences.getString(1);
                String sequenceSchema = sequences.getString(2);
                String sequenceName = sequences.getString(3);
                String sequenceTeiidName = this.getFullyQualifiedName(sequenceCatalog, sequenceSchema, sequenceName);
                if (this.excludeSequences != null && this.excludeSequences.matcher(sequenceTeiidName).matches()) continue;
                String fullyQualifiedName = this.getFullyQualifiedName(sequenceCatalog, sequenceSchema, sequenceName, true);
                String sequenceNext = this.getSequenceNextSQL(fullyQualifiedName);
                FunctionMethod method = metadataFactory.addFunction((this.useFullSchemaName ? sequenceTeiidName : sequenceName) + "_nextval", "long", new String[0]);
                method.setProperty("{http://www.teiid.org/ext/relational/2012}native-query", sequenceNext);
                method.setProperty(SEQUENCE, fullyQualifiedName);
                method.setDeterminism(FunctionMethod.Determinism.NONDETERMINISTIC);
            }
        }
        finally {
            sequences.close();
        }
    }

    protected ResultSet executeSequenceQuery(Connection conn) throws SQLException {
        return null;
    }

    protected String getSequenceNextSQL(String fullyQualifiedName) {
        return null;
    }

    protected boolean getIndexInfoForTable(String catalogName, String schemaName, String tableName, boolean uniqueOnly, boolean approximateIndexes, String tableType) {
        return true;
    }

    private String getFullyQualifiedName(String catalogName, String schemaName, String objectName) {
        return this.getFullyQualifiedName(catalogName, schemaName, objectName, false);
    }

    protected String getFullyQualifiedName(String catalogName, String schemaName, String objectName, boolean quoted) {
        String fullName;
        String string = fullName = quoted ? this.quoteName(objectName) : objectName;
        if (this.useQualifiedName) {
            if (schemaName != null && schemaName.length() > 0) {
                fullName = (quoted ? this.quoteName(schemaName) : schemaName) + '.' + fullName;
            }
            if (this.useCatalogName && catalogName != null && catalogName.length() > 0) {
                fullName = (quoted ? this.quoteName(catalogName) : catalogName) + this.catalogSeparator + fullName;
            }
        }
        return fullName;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setTableTypes(String[] tableTypes) {
        this.tableTypes = tableTypes;
    }

    @TranslatorProperty(display="Table Types", category=TranslatorProperty.PropertyType.IMPORT, description="Comma separated list - without spaces - of imported table types. null returns all types")
    public String[] getTableTypes() {
        return this.tableTypes;
    }

    public void setUseFullSchemaName(boolean useFullSchemaName) {
        this.useFullSchemaName = useFullSchemaName;
    }

    public void setProcedureNamePattern(String procedureNamePattern) {
        this.procedureNamePattern = procedureNamePattern;
    }

    public void setImportIndexes(boolean importIndexes) {
        this.importIndexes = importIndexes;
    }

    public void setImportKeys(boolean importKeys) {
        this.importKeys = importKeys;
    }

    public void setImportProcedures(boolean importProcedures) {
        this.importProcedures = importProcedures;
    }

    public void setImportApproximateIndexes(boolean importApproximateIndexes) {
        this.importApproximateIndexes = importApproximateIndexes;
    }

    @Deprecated
    public void setWidenUnsingedTypes(boolean widenUnsingedTypes) {
        this.widenUnsingedTypes = widenUnsingedTypes;
    }

    public void setWidenUnsignedTypes(boolean widenUnsignedTypes) {
        this.widenUnsingedTypes = widenUnsignedTypes;
    }

    public void setQuoteNameInSource(boolean quoteIdentifiers) {
        this.quoteNameInSource = quoteIdentifiers;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchemaPattern(String schema) {
        this.schemaPattern = schema;
    }

    public void setUseProcedureSpecificName(boolean useProcedureSpecificName) {
        this.useProcedureSpecificName = useProcedureSpecificName;
    }

    public void setUseCatalogName(boolean useCatalog) {
        this.useCatalogName = useCatalog;
    }

    public void setAutoCreateUniqueConstraints(boolean autoCreateUniqueConstraints) {
        this.autoCreateUniqueConstraints = autoCreateUniqueConstraints;
    }

    public void setExcludeProcedures(String excludeProcedures) {
        this.excludeProcedures = Pattern.compile(excludeProcedures, 34);
    }

    public void setExcludeTables(String excludeTables) {
        this.excludeTables = Pattern.compile(excludeTables, 34);
    }

    public void setUseQualifiedName(boolean useQualifiedName) {
        this.useQualifiedName = useQualifiedName;
    }

    public void setUseAnyIndexCardinality(boolean useAnyIndexCardinality) {
        this.useAnyIndexCardinality = useAnyIndexCardinality;
    }

    public void setImportStatistics(boolean importStatistics) {
        this.importStatistics = importStatistics;
    }

    public void setImportForeignKeys(boolean importForeignKeys) {
        this.importForeignKeys = importForeignKeys;
    }

    public void setColumnNamePattern(String columnNamePattern) {
        this.columnNamePattern = columnNamePattern;
    }

    @TranslatorProperty(display="Import Procedures", category=TranslatorProperty.PropertyType.IMPORT, description="true to import procedures and procedure columns - Note that it is not always possible to import procedure result set columns due to database limitations. It is also not currently possible to import overloaded procedures.")
    public boolean isImportProcedures() {
        return this.importProcedures;
    }

    @TranslatorProperty(display="Import Keys", category=TranslatorProperty.PropertyType.IMPORT, description="true to import primary and foreign keys - NOTE foreign keys to tables that are not imported will be ignored")
    public boolean isImportKeys() {
        return this.importKeys;
    }

    @TranslatorProperty(display="Import Foreign Key", category=TranslatorProperty.PropertyType.IMPORT, description="true to import foreign keys")
    public boolean isImportForeignKeys() {
        return this.importForeignKeys;
    }

    @TranslatorProperty(display="Import Indexes", category=TranslatorProperty.PropertyType.IMPORT, description="true to import index/unique key/cardinality information")
    public boolean isImportIndexes() {
        return this.importIndexes;
    }

    @TranslatorProperty(display="Procedure Name Pattern", category=TranslatorProperty.PropertyType.IMPORT, description=" a procedure name pattern; must match the procedure name as it is stored in the database")
    public String getProcedureNamePattern() {
        return this.procedureNamePattern;
    }

    @TranslatorProperty(display="Use Full Schema Name", category=TranslatorProperty.PropertyType.IMPORT, description="When false, directs the importer to drop the source catalog/schema from the Teiid object name, so that the Teiid fully qualified name will be in the form of <model name>.<table name> - Note: when false this may lead to objects with duplicate names when importing from multiple schemas, which results in an exception.  This option does not affect the name in source property.")
    public boolean isUseFullSchemaName() {
        return this.useFullSchemaName;
    }

    @TranslatorProperty(display="Table Name Pattern", category=TranslatorProperty.PropertyType.IMPORT, description=" a table name pattern; must match the table name as it is stored in the database")
    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    @TranslatorProperty(display="catalog", category=TranslatorProperty.PropertyType.IMPORT, description="a catalog name; must match the catalog name as it is stored in the database; \"\" retrieves those without a catalog; null means that the catalog name should not be used to narrow the search")
    public String getCatalog() {
        return this.catalog;
    }

    @TranslatorProperty(display="Schema Pattern", category=TranslatorProperty.PropertyType.IMPORT, description="a schema name pattern; must match the schema name as it is stored in the database; \"\" retrieves those without a schema; null means that the schema name should not be used to narrow the search")
    public String getSchemaPattern() {
        return this.schemaPattern;
    }

    @TranslatorProperty(display="Import Approximate Indexes", category=TranslatorProperty.PropertyType.IMPORT, description="true to import approximate index information. when true, result is allowed to reflect approximate or out of data values; when false, results are requested to be accurate")
    public boolean isImportApproximateIndexes() {
        return this.importApproximateIndexes;
    }

    @TranslatorProperty(display="Widen unSigned Types", category=TranslatorProperty.PropertyType.IMPORT, description="true to convert unsigned types to the next widest type. For example SQL Server reports tinyint as an unsigned type. With this option enabled, tinyint would be imported as a short instead of a byte.")
    public boolean isWidenUnsingedTypes() {
        return this.widenUnsingedTypes;
    }

    @TranslatorProperty(display="Quote NameInSource", category=TranslatorProperty.PropertyType.IMPORT, description="false will override the default and direct Teiid to create source queries using unquoted identifiers.")
    public boolean isQuoteNameInSource() {
        return this.quoteNameInSource;
    }

    @TranslatorProperty(display="Use Procedure Specific Name", category=TranslatorProperty.PropertyType.IMPORT, description="true will allow the import of overloaded procedures (which will normally result in a duplicate procedure error) by using the unique procedure specific name as the Teiid name. This option will only work with JDBC 4.0 compatible drivers that report specific names.")
    public boolean isUseProcedureSpecificName() {
        return this.useProcedureSpecificName;
    }

    @TranslatorProperty(display="Use Catalog Name", category=TranslatorProperty.PropertyType.IMPORT, description="true will use any non-null/non-empty catalog name as part of the name in source, e.g. \"catalog\".\"schema\".\"table\".\"column\", and in the Teiid runtime name if useFullSchemaName is also true. false will not use the catalog name in either the name in source or the Teiid runtime name. Should be set to false for sources that do not fully support a catalog concept, but return a non-null catalog name in their metadata - such as HSQL.")
    public boolean isUseCatalogName() {
        return this.useCatalogName;
    }

    @TranslatorProperty(display="Auto Create Unique Constraints", category=TranslatorProperty.PropertyType.IMPORT, description="true to create a unique constraint if one is not found for a foreign keys")
    public boolean isAutoCreateUniqueConstraints() {
        return this.autoCreateUniqueConstraints;
    }

    @TranslatorProperty(display="use Qualified Name", category=TranslatorProperty.PropertyType.IMPORT, description="true will use name qualification for both the Teiid name and name in source as dictated by the useCatalogName and useFullSchemaName properties.  Set to false to disable all qualification for both the Teiid name and the name in source, which effectively ignores the useCatalogName and useFullSchemaName properties.  Note: when false this may lead to objects with duplicate names when importing from multiple schemas, which results in an exception.")
    public boolean isUseQualifiedName() {
        return this.useQualifiedName;
    }

    @TranslatorProperty(display="Use Any Index Cardinality", category=TranslatorProperty.PropertyType.IMPORT, description="true will use the maximum cardinality returned from DatabaseMetaData.getIndexInfo. importKeys or importIndexes needs to be enabled for this setting to have an effect. This allows for better stats gathering from sources that don't support returning a statistical index.")
    public boolean isUseAnyIndexCardinality() {
        return this.useAnyIndexCardinality;
    }

    @TranslatorProperty(display="Import Statistics", category=TranslatorProperty.PropertyType.IMPORT, description="true will use database dependent logic to determine the cardinality if none is determined. Not yet supported by all database types - currently only supported by Oracle and MySQL.")
    public boolean isImportStatistics() {
        return this.importStatistics;
    }

    @TranslatorProperty(display="Column Name Pattern", category=TranslatorProperty.PropertyType.IMPORT, description="a column name pattern; must match the column name as it is stored in the database. Used to import columns of tables.  Leave unset to import all columns.", advanced=true)
    public String getColumnNamePattern() {
        return this.columnNamePattern;
    }

    @TranslatorProperty(display="Exclude Tables", category=TranslatorProperty.PropertyType.IMPORT, description="A case-insensitive regular expression that when matched against a fully qualified Teiid table name will exclude it from import.  Applied after table names are retrieved.  Use a negative look-ahead (?!<inclusion pattern>).* to act as an inclusion filter")
    public String getExcludeTables() {
        if (this.excludeTables == null) {
            return null;
        }
        return this.excludeTables.pattern();
    }

    @TranslatorProperty(display="Exclude Procedures", category=TranslatorProperty.PropertyType.IMPORT, description="A case-insensitive regular expression that when matched against a fully qualified Teiid procedure name will exclude it from import.  Applied after procedure names are retrieved.  Use a negative look-ahead (?!<inclusion pattern>).* to act as an inclusion filter")
    public String getExcludeProcedures() {
        if (this.excludeProcedures == null) {
            return null;
        }
        return this.excludeProcedures.pattern();
    }

    public void setQuoteString(String quoteString) {
        this.startQuoteString = quoteString;
        this.endQuoteString = quoteString;
    }

    public void setStartQuoteString(String quoteString) {
        this.startQuoteString = quoteString;
    }

    public void setEndQuoteString(String quoteString) {
        this.endQuoteString = quoteString;
    }

    @TranslatorProperty(display="Import RowId as binary", category=TranslatorProperty.PropertyType.IMPORT, description="Import RowId values as varbinary rather than object.")
    public boolean isImportRowIdAsBinary() {
        return this.importRowIdAsBinary;
    }

    public void setImportRowIdAsBinary(boolean importRowIdAsBinary) {
        this.importRowIdAsBinary = importRowIdAsBinary;
    }

    @TranslatorProperty(display="Import Large as LOB", category=TranslatorProperty.PropertyType.IMPORT, description="Import character and binary types larger than the Teiid max as clob or blob respectively.")
    public boolean isImportLargeAsLob() {
        return this.importLargeAsLob;
    }

    public void setImportLargeAsLob(boolean importLargeAsLob) {
        this.importLargeAsLob = importLargeAsLob;
    }

    @TranslatorProperty(display="Import Sequences", category=TranslatorProperty.PropertyType.IMPORT, description="true to import sequences")
    public boolean isImportSequences() {
        return this.importSequences;
    }

    public void setImportSequences(boolean importSequences) {
        this.importSequences = importSequences;
    }

    @TranslatorProperty(display="Exclude Tables", category=TranslatorProperty.PropertyType.IMPORT, description="A case-insensitive regular expression that when matched against a fully qualified Teiid sequence name will exclude it from import.  Applied after table names are retrieved.  Use a negative look-ahead (?!<inclusion pattern>).* to act as an inclusion filter")
    public String getExcludeSequences() {
        if (this.excludeSequences == null) {
            return null;
        }
        return this.excludeSequences.pattern();
    }

    public void setExcludeSequences(String excludeSequences) {
        this.excludeSequences = Pattern.compile(excludeSequences, 34);
    }

    @TranslatorProperty(display="Sequence Name Pattern", category=TranslatorProperty.PropertyType.IMPORT, description="a sequence name pattern; must match the sequence name as it is stored in the database")
    public String getSequenceNamePattern() {
        return this.sequenceNamePattern;
    }

    public void setSequenceNamePattern(String sequenceNamePattern) {
        this.sequenceNamePattern = sequenceNamePattern;
    }

    @TranslatorProperty(display="Use Integral Types", category=TranslatorProperty.PropertyType.IMPORT, description="Use integral types rather than decimal when the scale is 0.")
    public boolean isUseIntegralTypes() {
        return this.useIntegralTypes;
    }

    public void setUseIntegralTypes(boolean useIntegralTypes) {
        this.useIntegralTypes = useIntegralTypes;
    }

    private class FKInfo {
        TableInfo pkTable;
        TreeMap<Short, String> keyColumns = new TreeMap();
        TreeMap<Short, String> referencedKeyColumns = new TreeMap();
        boolean valid = true;

        private FKInfo() {
        }
    }

    static class TableInfo {
        private String catalog;
        private String schema;
        private String name;
        private Table table;
        private String type;

        public TableInfo(String catalog, String schema, String name, Table table) {
            this.catalog = catalog;
            this.schema = schema;
            this.name = name;
            this.table = table;
        }
    }
}

