/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.redshift;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.postgresql.PostgreSQLExecutionFactory;

@Translator(name="redshift", description="A translator for Redshift")
public class RedshiftExecutionFactory
extends PostgreSQLExecutionFactory {
    @Override
    public void start() throws TranslatorException {
        super.start();
        this.getFunctionModifiers().remove("substring");
        this.parseModifier.setPrefix("TO_DATE(");
    }

    @Override
    public void intializeConnectionAfterCancel(Connection c) throws SQLException {
        try (Statement s = c.createStatement();){
            s.execute("select 1");
        }
    }

    @Override
    public boolean hasTimeType() {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) {
        if (toType == 12) {
            return false;
        }
        return super.supportsConvert(fromType, toType);
    }

    @Override
    public List<String> getSupportedFunctions() {
        List<String> functions = super.getSupportedFunctions();
        functions.remove("ascii");
        return functions;
    }

    @Override
    public boolean supportsQuantifiedCompareCriteriaAll() {
        return false;
    }

    @Override
    public boolean supportsQuantifiedCompareCriteriaSome() {
        return false;
    }

    @Override
    public Object convertToken(String group) {
        if (group.charAt(0) == 'Z') {
            throw new IllegalArgumentException();
        }
        return super.convertToken(group);
    }
}

