/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.db2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;
import org.teiid.translator.jdbc.db2.BaseDB2ExecutionFactory;
import org.teiid.util.Version;

@Translator(name="db2", description="A translator for IBM DB2 Database")
public class DB2ExecutionFactory
extends BaseDB2ExecutionFactory {
    public static final Version EIGHT_0 = Version.getVersion((String)"8.0");
    public static final Version NINE_1 = Version.getVersion((String)"9.1");
    public static final Version NINE_5 = Version.getVersion((String)"9.5");
    public static final Version FIVE_4 = Version.getVersion((String)"5.4");
    public static final Version SIX_1 = Version.getVersion((String)"6.1");
    private static final String WEEK_ISO = "WEEK_ISO";
    private boolean dB2ForI;
    private boolean supportsCommonTableExpressions = true;

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("CEILING");
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("||");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LOCATE");
        supportedFunctions.add("LOWER");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("RAND");
        supportedFunctions.add("REPLACE");
        supportedFunctions.add("RIGHT");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("trim");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("UPPER");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("DAY");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("WEEK");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        supportedFunctions.add("COALESCE");
        if (this.getVersion().compareTo(this.isdB2ForI() ? SIX_1 : NINE_5) >= 0) {
            supportedFunctions.add("round");
        }
        return supportedFunctions;
    }

    public boolean supportsFunctionsInGroupBy() {
        return !this.dB2ForI;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public void setSupportsCommonTableExpressions(boolean supportsCommonTableExpressions) {
        this.supportsCommonTableExpressions = supportsCommonTableExpressions;
    }

    @TranslatorProperty(display="Supports Common Table Expressions", description="Supports Common Table Expressions", advanced=true)
    public boolean supportsCommonTableExpressions() {
        return this.supportsCommonTableExpressions;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsElementaryOlapOperations() {
        return this.getVersion().compareTo(this.isdB2ForI() ? SIX_1 : NINE_1) >= 0;
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("trim", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                List p = function.getParameters();
                return Arrays.asList("STRIP(", p.get(2), ", ", ((Literal)p.get(0)).getValue(), ", ", p.get(1), ")");
            }
        });
        this.registerFunctionModifier("week", new AliasModifier(WEEK_ISO));
        this.addPushDownFunction("db2", "substr", "string", new String[]{"string", "integer", "integer"});
    }

    @TranslatorProperty(display="Is DB2 for i", description="If the server is DB2 for i (formally known as DB2/AS).", advanced=true)
    public boolean isdB2ForI() {
        return this.dB2ForI;
    }

    public void setdB2ForI(boolean dB2ForI) {
        this.dB2ForI = dB2ForI;
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }

    @Override
    public String getHibernateDialectClassName() {
        return "org.hibernate.dialect.DB2Dialect";
    }

    @Override
    public String getTemporaryTableName(String prefix) {
        return "session." + super.getTemporaryTableName(prefix);
    }

    public boolean supportsGroupByRollup() {
        return true;
    }

    @Override
    protected boolean supportsBooleanExpressions() {
        return false;
    }

    @Override
    public MetadataProcessor<Connection> getMetadataProcessor() {
        return new JDBCMetadataProcessor(){

            @Override
            protected ResultSet executeSequenceQuery(Connection conn) throws SQLException {
                String query = "select null as sequence_catalog, seqschema as sequence_schema, seqname as sequence_name from sysibm.syssequences where seqschema like ? and seqname like ?";
                PreparedStatement ps = conn.prepareStatement(query);
                ps.setString(1, this.getSchemaPattern() == null ? "%" : this.getSchemaPattern());
                ps.setString(2, this.getSequenceNamePattern() == null ? "%" : this.getSequenceNamePattern());
                return ps.executeQuery();
            }
        };
    }
}

