/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.hsql;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.Literal;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.FunctionModifier;

public class AddDiffModifier
extends FunctionModifier {
    private static Map<String, String> INTERVAL_MAP = new HashMap<String, String>();
    private boolean add;
    private LanguageFactory factory;
    private boolean supportsQuarter;

    public AddDiffModifier(boolean add, LanguageFactory factory) {
        this.add = add;
        this.factory = factory;
    }

    public AddDiffModifier supportsQuarter(boolean b) {
        this.supportsQuarter = b;
        return this;
    }

    @Override
    public List<?> translate(Function function) {
        if (this.add) {
            function.setName("dateadd");
        } else {
            function.setName("datediff");
        }
        Literal intervalType = (Literal)function.getParameters().get(0);
        String interval = ((String)intervalType.getValue()).toUpperCase();
        String newInterval = INTERVAL_MAP.get(interval);
        if (newInterval != null) {
            intervalType.setValue((Object)newInterval);
            return null;
        }
        if (this.supportsQuarter && interval.equals("SQL_TSI_QUARTER")) {
            intervalType.setValue((Object)"QUARTER");
            return null;
        }
        if (this.add) {
            if (interval.equals("SQL_TSI_FRAC_SECOND")) {
                intervalType.setValue((Object)"MILLISECOND");
                Expression[] args = new Expression[]{(Expression)function.getParameters().get(1), this.factory.createLiteral((Object)1000000, TypeFacility.RUNTIME_TYPES.INTEGER)};
                function.getParameters().set(1, this.factory.createFunction("/", args, TypeFacility.RUNTIME_TYPES.INTEGER));
            } else if (interval.equals("SQL_TSI_QUARTER")) {
                intervalType.setValue((Object)"DAY");
                Expression[] args = new Expression[]{(Expression)function.getParameters().get(1), this.factory.createLiteral((Object)91, TypeFacility.RUNTIME_TYPES.INTEGER)};
                function.getParameters().set(1, this.factory.createFunction("*", args, TypeFacility.RUNTIME_TYPES.INTEGER));
            } else {
                intervalType.setValue((Object)"DAY");
                Expression[] args = new Expression[]{(Expression)function.getParameters().get(1), this.factory.createLiteral((Object)7, TypeFacility.RUNTIME_TYPES.INTEGER)};
                function.getParameters().set(1, this.factory.createFunction("*", args, TypeFacility.RUNTIME_TYPES.INTEGER));
            }
            return null;
        }
        if (interval.equals("SQL_TSI_FRAC_SECOND")) {
            intervalType.setValue((Object)"MILLISECOND");
            return Arrays.asList(function, " * 1000000");
        }
        if (interval.equals("SQL_TSI_QUARTER")) {
            intervalType.setValue((Object)"DAY");
            return Arrays.asList(function, " / 91");
        }
        intervalType.setValue((Object)"DAY");
        return Arrays.asList(function, " / 7");
    }

    static {
        INTERVAL_MAP.put("SQL_TSI_DAY", "DAY");
        INTERVAL_MAP.put("SQL_TSI_HOUR", "HOUR");
        INTERVAL_MAP.put("SQL_TSI_MINUTE", "MINUTE");
        INTERVAL_MAP.put("SQL_TSI_MONTH", "MONTH");
        INTERVAL_MAP.put("SQL_TSI_SECOND", "SECOND");
        INTERVAL_MAP.put("SQL_TSI_YEAR", "YEAR");
    }
}

