/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.ColumnReference;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.metadata.Column;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.oracle.OracleExecutionFactory;

public class TestOracleConvertModifier {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();
    private static OracleExecutionFactory TRANSLATOR = new OracleExecutionFactory();

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        TRANSLATOR.start();
    }

    public String helpGetString(Expression expr) throws Exception {
        OracleExecutionFactory trans = new OracleExecutionFactory();
        trans.start();
        SQLConversionVisitor sqlVisitor = TRANSLATOR.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)expr);
        return sqlVisitor.toString();
    }

    public void helpTest(Expression srcExpression, String tgtType, String expectedExpression) throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", Arrays.asList(srcExpression, LANG_FACTORY.createLiteral((Object)tgtType, String.class)), TypeFacility.getDataTypeClass((String)tgtType));
        Assert.assertEquals((String)("Error converting from " + srcExpression.getType() + " to " + tgtType), (Object)expectedExpression, (Object)this.helpGetString((Expression)func));
    }

    @Test
    public void testStringToChar() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "char", "cast('5' AS char(1))");
    }

    @Test
    public void testStringToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "boolean", "CASE WHEN '5' IN ('false', '0') THEN 0 WHEN '5' IS NOT NULL THEN 1 END");
    }

    @Test
    public void testStringToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "byte", "trunc(to_number('5'))");
    }

    @Test
    public void testStringToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "short", "trunc(to_number('5'))");
    }

    @Test
    public void testStringToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "integer", "trunc(to_number('5'))");
    }

    @Test
    public void testStringToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "long", "trunc(to_number('5'))");
    }

    @Test
    public void testStringToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "biginteger", "trunc(to_number('5'))");
    }

    @Test
    public void testStringToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "float", "to_number('5')");
    }

    @Test
    public void testStringToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "double", "to_number('5')");
    }

    @Test
    public void testStringToDate() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"2004-06-29", String.class), "date", "to_date('2004-06-29', 'YYYY-MM-DD')");
    }

    @Test
    public void testStringToTime() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"23:59:59", String.class), "time", "to_date('23:59:59', 'HH24:MI:SS')");
    }

    @Test
    public void testStringToTimestamp() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"2004-06-29 23:59:59.987", String.class), "timestamp", "to_timestamp('2004-06-29 23:59:59.987', 'YYYY-MM-DD HH24:MI:SS.FF')");
    }

    @Test
    public void testStringToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "bigdecimal", "to_number('5')");
    }

    @Test
    public void testCharToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Character('5'), Character.class), "string", "'5'");
    }

    @Test
    public void testBooleanToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "string", "CASE WHEN 1 = 0 THEN 'false' WHEN 1 IS NOT NULL THEN 'true' END");
    }

    @Test
    public void testBooleanToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "byte", "1");
    }

    @Test
    public void testBooleanToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "short", "1");
    }

    @Test
    public void testBooleanToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "integer", "1");
    }

    @Test
    public void testBooleanToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "long", "1");
    }

    @Test
    public void testBooleanToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "biginteger", "1");
    }

    @Test
    public void testBooleanToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "float", "1");
    }

    @Test
    public void testBooleanToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "double", "1");
    }

    @Test
    public void testBooleanToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "bigdecimal", "1");
    }

    @Test
    public void testByteToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "string", "to_char(1)");
    }

    @Test
    public void testByteToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testByteToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "short", "1");
    }

    @Test
    public void testByteToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "integer", "1");
    }

    @Test
    public void testByteToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "long", "1");
    }

    @Test
    public void testByteToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "biginteger", "1");
    }

    @Test
    public void testByteToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "float", "1");
    }

    @Test
    public void testByteToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "double", "1");
    }

    @Test
    public void testByteToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "bigdecimal", "1");
    }

    @Test
    public void testShortToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "string", "to_char(1)");
    }

    @Test
    public void testShortToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testShortToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "byte", "1");
    }

    @Test
    public void testShortToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "integer", "1");
    }

    @Test
    public void testShortToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "long", "1");
    }

    @Test
    public void testShortToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "biginteger", "1");
    }

    @Test
    public void testShortToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "float", "1");
    }

    @Test
    public void testShortToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "double", "1");
    }

    @Test
    public void testShortToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "bigdecimal", "1");
    }

    @Test
    public void testIntegerToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "string", "to_char(1)");
    }

    @Test
    public void testIntegerToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testIntegerToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "byte", "1");
    }

    @Test
    public void testIntegerToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "short", "1");
    }

    @Test
    public void testIntegerToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "long", "1");
    }

    @Test
    public void testIntegerToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "biginteger", "1");
    }

    @Test
    public void testIntegerToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "float", "1");
    }

    @Test
    public void testIntegerToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "double", "1");
    }

    @Test
    public void testIntegerToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "bigdecimal", "1");
    }

    @Test
    public void testLongToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "string", "to_char(1)");
    }

    @Test
    public void testLongToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testLongToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "byte", "1");
    }

    @Test
    public void testLongToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "short", "1");
    }

    @Test
    public void testLongToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "integer", "1");
    }

    @Test
    public void testLongToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "biginteger", "1");
    }

    @Test
    public void testLongToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "float", "1");
    }

    @Test
    public void testLongToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "double", "1");
    }

    @Test
    public void testLongToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "bigdecimal", "1");
    }

    @Test
    public void testBigIntegerToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "string", "to_char(1)");
    }

    @Test
    public void testBigIntegerToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testBigIntegerToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "byte", "1");
    }

    @Test
    public void testBigIntegerToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "short", "1");
    }

    @Test
    public void testBigIntegerToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "integer", "1");
    }

    @Test
    public void testBigIntegerToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "long", "1");
    }

    @Test
    public void testBigIntegerToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "float", "1");
    }

    @Test
    public void testBigIntegerToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "double", "1");
    }

    @Test
    public void testBigIntegerToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "bigdecimal", "1");
    }

    @Test
    public void testFloatToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "string", "to_char(1.2)");
    }

    @Test
    public void testFloatToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "boolean", "CASE WHEN 1.2 = 0 THEN 0 WHEN 1.2 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testFloatToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "byte", "trunc(1.2)");
    }

    @Test
    public void testFloatToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "short", "trunc(1.2)");
    }

    @Test
    public void testFloatToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "integer", "trunc(1.2)");
    }

    @Test
    public void testFloatToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "long", "trunc(1.2)");
    }

    @Test
    public void testFloatToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "biginteger", "trunc(1.2)");
    }

    @Test
    public void testFloatToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "double", "1.2");
    }

    @Test
    public void testFloatToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "bigdecimal", "1.2");
    }

    @Test
    public void testDoubleToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "string", "to_char(1.2)");
    }

    @Test
    public void testDoubleToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "boolean", "CASE WHEN 1.2 = 0 THEN 0 WHEN 1.2 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testDoubleToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "byte", "trunc(1.2)");
    }

    @Test
    public void testDoubleToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "short", "trunc(1.2)");
    }

    @Test
    public void testDoubleToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "integer", "trunc(1.2)");
    }

    @Test
    public void testDoubleToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "long", "trunc(1.2)");
    }

    @Test
    public void testDoubleToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "biginteger", "trunc(1.2)");
    }

    @Test
    public void testDoubleToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "float", "1.2");
    }

    @Test
    public void testDoubleToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "bigdecimal", "1.2");
    }

    @Test
    public void testBigDecimalToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "string", "to_char(1.0)");
    }

    @Test
    public void testBigDecimalToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "boolean", "CASE WHEN 1.0 = 0 THEN 0 WHEN 1.0 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testBigDecimalToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "byte", "trunc(1.0)");
    }

    @Test
    public void testBigDecimalToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "short", "trunc(1.0)");
    }

    @Test
    public void testBigDecimalToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "integer", "trunc(1.0)");
    }

    @Test
    public void testBigDecimalToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "long", "trunc(1.0)");
    }

    @Test
    public void testBigDecimalToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "biginteger", "trunc(1.0)");
    }

    @Test
    public void testBigDecimalToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "float", "1.0");
    }

    @Test
    public void testBigDecimalToDoublel() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "double", "1.0");
    }

    @Test
    public void testDateToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)103, (int)10, (int)1), Date.class), "string", "to_char({d '2003-11-01'}, 'YYYY-MM-DD')");
    }

    @Test
    public void testDateToTimestamp() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)103, (int)10, (int)1), Date.class), "timestamp", "cast({d '2003-11-01'} AS timestamp)");
    }

    @Test
    public void testTimeToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createTime((int)23, (int)59, (int)59), Time.class), "string", "to_char(to_date('1970-01-01 23:59:59', 'YYYY-MM-DD HH24:MI:SS'), 'HH24:MI:SS')");
    }

    @Test
    public void testTimeToTimestamp() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createTime((int)23, (int)59, (int)59), Time.class), "timestamp", "cast(to_date('1970-01-01 23:59:59', 'YYYY-MM-DD HH24:MI:SS') AS timestamp)");
    }

    @Test
    public void testTimestampToString() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)103, (int)10, (int)1, (int)12, (int)5, (int)2, (int)10000000);
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)ts, Timestamp.class), "string", "to_char({ts '2003-11-01 12:05:02.01'}, 'YYYY-MM-DD HH24:MI:SS.FF')");
    }

    @Test
    public void testTimestampToString1() throws Exception {
        Column column = new Column();
        column.setNativeType("DATE");
        column.setNameInSource("dt");
        this.helpTest((Expression)LANG_FACTORY.createColumnReference("dt", LANG_FACTORY.createNamedTable("x", null, null), column, Timestamp.class), "string", "to_char(x.dt, 'YYYY-MM-DD HH24:MI:SS')");
    }

    @Test
    public void testTimestampToDate() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)103, (int)10, (int)1, (int)12, (int)5, (int)2, (int)10000000);
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)ts, Timestamp.class), "date", "trunc(cast({ts '2003-11-01 12:05:02.01'} AS date))");
    }

    @Test
    public void testTimestampToTime() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)103, (int)10, (int)1, (int)12, (int)5, (int)2, (int)10000000);
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)ts, Timestamp.class), "time", "case when {ts '2003-11-01 12:05:02.01'} is null then null else to_date('1970-01-01 ' || to_char({ts '2003-11-01 12:05:02.01'}, 'HH24:MI:SS'), 'YYYY-MM-DD HH24:MI:SS') end");
    }

    @Test
    public void testClobToString() throws Exception {
        Assert.assertTrue((boolean)TRANSLATOR.supportsConvert(16, 0));
        this.helpTest((Expression)new ColumnReference(null, "x", null, DataTypeManager.DefaultDataClasses.CLOB), "string", "DBMS_LOB.substr(x, 4000)");
    }
}

