/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.derby;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.derby.DerbyExecutionFactory;
import org.teiid.util.Version;

public class TestDerbySQLTranslator {
    private static DerbyExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        TRANSLATOR = new DerbyExecutionFactory();
        TRANSLATOR.setDatabaseVersion(Version.DEFAULT_VERSION);
        TRANSLATOR.start();
    }

    @Test
    public void testConcat_useLiteral() throws Exception {
        String input = "select concat(stringnum,'_xx') from BQT1.Smalla";
        String output = "SELECT {fn concat(SmallA.StringNum, '_xx')} FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConcat() throws Exception {
        String input = "select concat(stringnum, stringnum) from BQT1.Smalla";
        String output = "SELECT {fn concat(SmallA.StringNum, SmallA.StringNum)} FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConcat2_useLiteral() throws Exception {
        String input = "select concat2(stringnum,'_xx') from BQT1.Smalla";
        String output = "SELECT {fn concat(coalesce(SmallA.StringNum, ''), '_xx')} FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConcat2() throws Exception {
        String input = "select concat2(stringnum, stringnum) from BQT1.Smalla";
        String output = "SELECT CASE WHEN SmallA.StringNum IS NULL AND SmallA.StringNum IS NULL THEN NULL ELSE {fn concat(coalesce(SmallA.StringNum, ''), coalesce(SmallA.StringNum, ''))} END FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSelectWithNoFrom() throws Exception {
        String input = "select 1, 2";
        String output = "VALUES(1, 2)";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTempTable() throws Exception {
        Assert.assertEquals((Object)"declare global temporary table foo (COL1 integer, COL2 varchar(100)) not logged", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)TRANSLATOR, true));
    }

    @Test
    public void testXmlSelect() throws Exception {
        String input = "SELECT col as x, col1 as y from test";
        String output = "SELECT XMLSERIALIZE(test.col AS CLOB) AS x, test.col1 AS y FROM test";
        TranslationHelper.helpTestVisitor("create foreign table test (col xml, col1 integer);", input, output, (JDBCExecutionFactory)TRANSLATOR);
        input = "SELECT * from test";
        output = "SELECT XMLSERIALIZE(test.col AS CLOB), test.col1 FROM test";
        TranslationHelper.helpTestVisitor("create foreign table test (col xml, col1 integer);", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testOffset() throws Exception {
        String input = "select intkey from bqt1.smalla limit 50, 100";
        String output = "SELECT SmallA.IntKey FROM SmallA OFFSET 50 ROWS FETCH FIRST 100 ROWS ONLY";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }
}

