/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.sybase;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.language.Command;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslatedCommand;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.sybase.SybaseIQExecutionFactory;

public class TestSybaseIQTranslator {
    private static SybaseIQExecutionFactory trans = new SybaseIQExecutionFactory();

    @BeforeClass
    public static void setup() throws TranslatorException {
        trans.setUseBindVariables(false);
        trans.start();
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput) {
        Command obj = TranslationHelper.helpTranslate(vdb, input);
        TranslatedCommand tc = new TranslatedCommand((ExecutionContext)Mockito.mock(ExecutionContext.class), (JDBCExecutionFactory)trans);
        try {
            tc.translateCommand(obj);
        }
        catch (TranslatorException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((String)"Did not get correct sql", (Object)expectedOutput, (Object)tc.getSql());
    }

    @Test
    public void testTimestampDiff() {
        String input = "SELECT timestampadd(sql_tsi_quarter, 1, timestampvalue), timestampadd(sql_tsi_frac_second, 1000, timestampvalue), timestampdiff(sql_tsi_frac_second, timestampvalue, timestampvalue) from bqt1.smalla";
        String output = "SELECT dateadd('QUARTER', 1, SmallA.TimestampValue), dateadd('MILLISECOND', (1000 / 1000000), SmallA.TimestampValue), datediff('MILLISECOND', SmallA.TimestampValue, SmallA.TimestampValue) * 1000000 FROM SmallA";
        this.helpTestVisitor("/bqt.vdb", input, output);
    }

    @Test
    public void testLocate() {
        String input = "SELECT locate('a', stringkey, 2) from bqt1.smalla";
        String output = "SELECT locate(SmallA.StringKey, 'a', 2) FROM SmallA";
        this.helpTestVisitor("/bqt.vdb", input, output);
    }

    @Test
    public void testWeek() {
        String input = "SELECT week(datevalue) from bqt1.smalla";
        String output = "SELECT {fn week(SmallA.DateValue)} FROM SmallA";
        this.helpTestVisitor("/bqt.vdb", input, output);
    }

    @Test
    public void testDayOfYear() {
        String input = "SELECT dayofyear(datevalue) from bqt1.smalla";
        String output = "SELECT DATEPART(dy,SmallA.DateValue) FROM SmallA";
        this.helpTestVisitor("/bqt.vdb", input, output);
    }
}

