/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.pi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.ColumnReference;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.pi.PIMetadataProcessor;
import org.teiid.translator.jdbc.pi.PISQLConversionVisitor;

@Translator(name="osisoft-pi", description="A translator for OsiSoft PI database")
public class PIExecutionFactory
extends JDBCExecutionFactory {
    public static String PI = "pi";
    protected ConvertModifier convert = new ConvertModifier();

    public PIExecutionFactory() {
        this.setUseBindVariables(false);
        this.setSupportsFullOuterJoins(false);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.convert.addTypeMapping("Int8", 3);
        this.convert.addTypeMapping("Int16", 4);
        this.convert.addTypeMapping("Int32", 5);
        this.convert.addTypeMapping("Int64", 6);
        this.convert.addTypeMapping("Single", 8);
        this.convert.addTypeMapping("Double", 9);
        this.convert.addTypeMapping("Boolean", 2);
        this.convert.addTypeMapping("String", 0);
        this.convert.addTypeMapping("DateTime", 13);
        this.convert.addTypeMapping("Time", 12);
        this.convert.addTypeMapping("Variant", 14);
        this.convert.addConvert(13, 12, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(format(", function.getParameters().get(0), ", 'hh:mm:ss.fff') as Time)");
            }
        });
        this.convert.addConvert(2, 8, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(cast(", function.getParameters().get(0), " as int8) as single)");
            }
        });
        this.convert.addConvert(2, 9, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(cast(", function.getParameters().get(0), " as int8) as double)");
            }
        });
        this.registerFunctionModifier("convert", this.convert);
        this.registerFunctionModifier("mod", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(", function.getParameters().get(0), " as int64)", "%", "cast(", function.getParameters().get(1), " as int64)");
            }
        });
        this.registerFunctionModifier("dayofmonth", new AliasModifier("DAY"));
        this.registerFunctionModifier("locate", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                if (function.getParameters().size() <= 2) {
                    return Arrays.asList("INSTR(", function.getParameters().get(1), ",", function.getParameters().get(0), ")");
                }
                return Arrays.asList("INSTR(", function.getParameters().get(1), ",", function.getParameters().get(0), ",", function.getParameters().get(2), ")");
            }
        });
        this.registerFunctionModifier("lcase", new AliasModifier("LOWER"));
        this.registerFunctionModifier("ucase", new AliasModifier("UPPER"));
        this.registerFunctionModifier("substring", new AliasModifier("SUBSTR"));
        this.registerFunctionModifier("length", new AliasModifier("LEN"));
        this.addPushDownFunction(PI, "COSH", "float", new String[]{"float"});
        this.addPushDownFunction(PI, "TANH", "float", new String[]{"float"});
        this.addPushDownFunction(PI, "SINH", "float", new String[]{"float"});
        this.addPushDownFunction(PI, "FORMAT", "string", new String[]{"float", "string"});
        this.addPushDownFunction(PI, "FORMAT", "string", new String[]{"integer", "string"});
        this.addPushDownFunction(PI, "ParentName", "string", new String[]{"string", "integer"});
        this.addPushDownFunction(PI, "List", "string", new String[]{"string"}).setVarArgs(true);
        this.addPushDownFunction(PI, "DIGCODE", "integer", new String[]{"string", "string"});
        this.addPushDownFunction(PI, "DIGSTRING", "string", new String[]{"integer"});
        this.addPushDownFunction(PI, "PE", "string", new String[]{"object"});
        this.addPushDownFunction(PI, "ParentName", "string", new String[]{"string", "integer"});
        this.addPushDownFunction(PI, "VarType", "string", new String[]{"string"});
        this.addPushDownFunction(PI, "UOMID", "string", new String[]{"string"});
        this.addPushDownFunction(PI, "UOMName", "string", new String[]{"string"});
        this.addPushDownFunction(PI, "UOMAbbreviation", "string", new String[]{"string"});
        this.addPushDownFunction(PI, "UOMClassName", "string", new String[]{"string"});
        this.addPushDownFunction(PI, "UOMCanonicallD", "string", new String[]{"string"});
        this.addPushDownFunction(PI, "UOMConvert", "double", new String[]{"double", "string", "string"});
        FunctionMethod f = this.addPushDownFunction(PI, "interval", "timestamp", new String[]{"string"});
        f.setProperty("{http://www.teiid.org/ext/relational/2012}native-query", "$1");
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    @Override
    public boolean supportsInsertWithQueryExpression() {
        return false;
    }

    @Override
    public boolean supportsBatchedUpdates() {
        return false;
    }

    @Override
    public boolean supportsBulkUpdate() {
        return false;
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        return Arrays.asList("TOP ", limit.getRowLimit());
    }

    @Override
    public boolean useSelectLimit() {
        return true;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("concat");
        supportedFunctions.add("cos");
        supportedFunctions.add("convert");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("hour");
        supportedFunctions.add("lcase");
        supportedFunctions.add("locate");
        supportedFunctions.add("left");
        supportedFunctions.add("length");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("minute");
        supportedFunctions.add("mod");
        supportedFunctions.add("power");
        supportedFunctions.add("second");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("replace");
        supportedFunctions.add("right");
        supportedFunctions.add("round");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("month");
        supportedFunctions.add("nullif");
        supportedFunctions.add("pi");
        supportedFunctions.add("sin");
        supportedFunctions.add("substring");
        supportedFunctions.add("tan");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        supportedFunctions.add("year");
        return supportedFunctions;
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "'" + this.formatDateValue(dateValue) + "'";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "'" + this.formatDateValue(timeValue) + "'";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "'" + this.formatDateValue(timestampValue) + "'";
    }

    @Override
    public void getMetadata(MetadataFactory metadataFactory, Connection conn) throws TranslatorException {
        if (metadataFactory.getModelProperties().get("importer.ImportKeys") == null) {
            metadataFactory.getModelProperties().put("importer.ImportKeys", "false");
        }
        super.getMetadata(metadataFactory, conn);
    }

    @Override
    public MetadataProcessor<Connection> getMetadataProcessor() {
        return new PIMetadataProcessor();
    }

    @Override
    public boolean useAsInGroupAlias() {
        return true;
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        String nativeType;
        ColumnReference elem;
        DerivedColumn derived;
        if (obj instanceof DerivedColumn && (derived = (DerivedColumn)obj).isProjected() && derived.getExpression() instanceof ColumnReference && (elem = (ColumnReference)derived.getExpression()).getMetadataObject() != null && (nativeType = elem.getMetadataObject().getNativeType()) != null && TypeFacility.RUNTIME_TYPES.STRING.equals(elem.getType()) && PIMetadataProcessor.guidPattern.matcher(nativeType).find()) {
            return Arrays.asList("cast(", elem, " as String)");
        }
        return super.translate(obj, context);
    }

    @Override
    public SQLConversionVisitor getSQLConversionVisitor() {
        return new PISQLConversionVisitor(this);
    }

    public boolean supportsLateralJoin() {
        return true;
    }

    public boolean supportsLateralJoinCondition() {
        return false;
    }

    public boolean supportsProcedureTable() {
        return true;
    }

    @Override
    public Object retrieveValue(ResultSet results, int columnIndex, Class<?> expectedType) throws SQLException {
        return results.getObject(columnIndex);
    }

    @Override
    public Object retrieveValue(CallableStatement results, int parameterIndex, Class<?> expectedType) throws SQLException {
        Object result = results.getObject(parameterIndex);
        if (result == null) {
            return null;
        }
        return super.retrieveValue(results, parameterIndex, expectedType);
    }

    public boolean supportsConvert(int fromType, int toType) {
        if (!super.supportsConvert(fromType, toType)) {
            return false;
        }
        return this.convert.hasTypeMapping(toType);
    }
}

