/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.pi;

import java.io.File;
import java.util.TimeZone;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.pi.PIExecutionFactory;

public class TestPIExecutionFactory {
    private static PIExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setup() throws TranslatorException {
        TRANSLATOR = new PIExecutionFactory();
        TRANSLATOR.start();
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT"));
    }

    @AfterClass
    public static void tearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }

    @Test
    public void testDateFormats() throws TranslatorException {
        String input = "SELECT stringkey FROM BQT1.MediumA where datevalue < '2001-01-01' and timevalue < '12:11:01' and timestampvalue < '2012-02-03 11:12:13'";
        String output = "SELECT MediumA.StringKey FROM MediumA WHERE MediumA.DateValue < '2001-01-01' AND MediumA.TimeValue < '12:11:01' AND MediumA.TimestampValue < '2012-02-03 11:12:13.0'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLeftJoin() throws Exception {
        String input = "SELECT * FROM Sample.Asset.ElementAttribute EA LEFT JOIN Sample.Asset.ElementAttributeCategory EAC ON EA.ID = EAC.ElementAttributeID";
        String output = "SELECT EAC.[ElementAttributeID], cast(EAC.[CategoryID] as String), cast(EA.[ID] as String), EA.[Path], EA.[Name] FROM Sample.Asset.ElementAttribute AS EA LEFT OUTER JOIN [Sample].[Asset].[ElementAttributeCategory] AS EAC ON EA.[ID] = EAC.[ElementAttributeID]";
        String ddl = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"pi.ddl"));
        TranslationHelper.helpTestVisitor(ddl, input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testCrossJoinAsInnter() throws Exception {
        String input = "SELECT * FROM Sample.Asset.ElementAttribute EA CROSS JOIN Sample.Asset.ElementAttributeCategory EAC";
        String output = "SELECT EAC.[ElementAttributeID], cast(EAC.[CategoryID] as String), cast(EA.[ID] as String), EA.[Path], EA.[Name] FROM Sample.Asset.ElementAttribute AS EA INNER JOIN [Sample].[Asset].[ElementAttributeCategory] AS EAC ON 1 = 1";
        String ddl = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"pi.ddl"));
        TranslationHelper.helpTestVisitor(ddl, input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testRightOuterAsLeftOuter() throws Exception {
        String input = "SELECT * FROM Sample.Asset.ElementAttribute EA RIGHT OUTER JOIN Sample.Asset.ElementAttributeCategory EAC ON EA.ID = EAC.ElementAttributeID";
        String output = "SELECT EAC.[ElementAttributeID], cast(EAC.[CategoryID] as String), cast(EA.[ID] as String), EA.[Path], EA.[Name] FROM [Sample].[Asset].[ElementAttributeCategory] AS EAC LEFT OUTER JOIN Sample.Asset.ElementAttribute AS EA ON EA.[ID] = EAC.[ElementAttributeID]";
        String ddl = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"pi.ddl"));
        TranslationHelper.helpTestVisitor(ddl, input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testCrossApply() throws Exception {
        String input = "SELECT * FROM Sample.Asset.ElementAttribute EA CROSS JOIN LATERAL (exec GetPIPoint(EA.ID)) EAC ";
        String output = "SELECT Path, Server, Tag, [Number of Computers], cast(EA.[ID] as String), EA.[Path], EA.[Name] FROM Sample.Asset.ElementAttribute AS EA CROSS APPLY Sample.EventFrame.GetPIPoint(EA.[ID])";
        String ddl = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"pi.ddl"));
        TranslationHelper.helpTestVisitor(ddl, input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testInlineViewJoin() throws Exception {
        String input = "SELECT bqt2.smalla.intkey, g2.intkey, bqt2.smalla.bytenum FROM bqt2.smalla LEFT JOIN (SELECT intkey, bytenum FROM bqt2.mediuma) AS g2 ON  bqt2.smalla.bytenum = g2.bytenum";
        String output = "SELECT SmallA.IntKey, g2.intkey, SmallA.ByteNum FROM SmallA LEFT OUTER JOIN (SELECT MediumA.IntKey, MediumA.ByteNum FROM MediumA) AS g2 ON SmallA.ByteNum = g2.bytenum";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testApplyOuter() throws Exception {
        String input = "SELECT EA.ID, EAC.Path FROM ElementAttribute EA LEFT OUTER JOIN LATERAL (exec GetPIPoint(EA.ID)) AS EAC ON 1=1";
        String output = "SELECT cast(EA.[ID] as String), Path FROM Sample.Asset.ElementAttribute AS EA OUTER APPLY Sample.EventFrame.GetPIPoint(EA.[ID])";
        String ddl = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"pi.ddl"));
        TranslationHelper.helpTestVisitor(ddl, input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimestamp2Time() throws TranslatorException {
        String input = "select cast(timestampvalue as time) from BQT1.MediumA";
        String output = "SELECT cast(format(MediumA.TimestampValue, 'hh:mm:ss.fff') as Time) FROM MediumA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLength() throws TranslatorException {
        String input = "select length(STRINGKEY) from BQT1.MediumA";
        String output = "SELECT LEN(MediumA.StringKey) FROM MediumA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testOrderBy() throws TranslatorException {
        String input = "SELECT FloatNum FROM BQT1.MediumA ORDER BY FloatNum ASC";
        String output = "SELECT MediumA.FloatNum FROM MediumA ORDER BY MediumA.FloatNum";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testBooleanCast() throws TranslatorException {
        String input = "SELECT cast(booleanvalue as float), cast(booleanvalue as double) FROM BQT1.MediumA";
        String output = "SELECT cast(cast(MediumA.BooleanValue as int8) as single), cast(cast(MediumA.BooleanValue as int8) as double) FROM MediumA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConvertToBigDecimal() throws TranslatorException {
        Assert.assertFalse((boolean)TRANSLATOR.supportsConvert(0, 10));
        Assert.assertFalse((boolean)TRANSLATOR.supportsConvert(0, 7));
        Assert.assertFalse((boolean)TRANSLATOR.supportsConvert(0, 20));
        Assert.assertTrue((boolean)TRANSLATOR.supportsConvert(0, 5));
    }

    @Test
    public void testLocate() throws TranslatorException {
        String input = "SELECT INTKEY FROM BQT1.SmallA WHERE LOCATE(2, INTKEY, 1) = 1";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE INSTR(cast(SmallA.IntKey AS String),'2',1) = 1";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
        input = "SELECT STRINGKEY FROM BQT1.SmallA WHERE LOCATE('2', STRINGKEY) = 1";
        output = "SELECT SmallA.StringKey FROM SmallA WHERE INSTR(SmallA.StringKey,'2') = 1";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testMOD() throws TranslatorException {
        String input = "SELECT FloatNum, 11, MOD(FloatNum, 11) FROM BQT1.SmallA";
        String output = "SELECT SmallA.FloatNum, 11, cast(SmallA.FloatNum as int64)%cast(11.0 as int64) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSOME() throws TranslatorException {
        String input = "SELECT INTKEY FROM BQT1.SMALLA WHERE FLOATNUM <> SOME (SELECT FLOATNUM FROM BQT1.SMALLA WHERE STRINGKEY = 10)";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE SmallA.FloatNum <> ANY (SELECT SmallA.FloatNum FROM SmallA WHERE SmallA.StringKey = '10')";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLimitOverUnion() throws TranslatorException {
        String input = "SELECT g_0.intkey FROM bqt1.smalla g_0 UNION SELECT g_1.intkey FROM bqt1.smallb g_1 LIMIT 100";
        String output = "SELECT TOP 100 * FROM (SELECT g_0.IntKey FROM SmallA AS g_0 UNION SELECT g_1.IntKey FROM SmallB AS g_1) _X_";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testCastFloatToSingle() throws Exception {
        String input = "SELECT MediumA.IntNum, MediumB.FloatNum \tFROM MediumA, MediumB \tWHERE MediumA.IntNum = MediumB.FloatNum";
        String output = "SELECT dvqe..MediumA.IntNum, dvqe..MediumB.FloatNum FROM dvqe..MediumA, dvqe..MediumB WHERE dvqe..MediumA.IntNum = dvqe..MediumB.FloatNum";
        String ddl = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"pi.ddl"));
        TranslationHelper.helpTestVisitor(ddl, input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testIntervalFunction() throws TranslatorException {
        String input = "select intnum from bqt1.smalla a where a.timestampvalue between pi.interval('*-14d') and pi.interval('*')";
        String output = "SELECT a.IntNum FROM SmallA AS a WHERE a.TimestampValue >= '*-14d' AND a.TimestampValue <= '*'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }
}

