/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.translator.jdbc.oracle.Log10FunctionModifier;

public class TestLog10FunctionModifier
extends TestCase {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();

    public TestLog10FunctionModifier(String name) {
        super(name);
    }

    public void testModifier() {
        Literal arg = LANG_FACTORY.createLiteral((Object)new Double(5.2), Double.class);
        Function func = LANG_FACTORY.createFunction("log10", Arrays.asList(arg), Double.class);
        Log10FunctionModifier modifier = new Log10FunctionModifier(LANG_FACTORY);
        modifier.translate(func);
        TestLog10FunctionModifier.assertEquals((String)"log", (String)func.getName());
        TestLog10FunctionModifier.assertEquals(Double.class, (Object)func.getType());
        List outArgs = func.getParameters();
        TestLog10FunctionModifier.assertEquals((int)2, (int)outArgs.size());
        TestLog10FunctionModifier.assertEquals((Object)arg, outArgs.get(1));
        TestLog10FunctionModifier.assertTrue((boolean)(outArgs.get(1) instanceof Literal));
        Literal newArg = (Literal)outArgs.get(0);
        TestLog10FunctionModifier.assertEquals(Integer.class, (Object)newArg.getType());
        TestLog10FunctionModifier.assertEquals((Object)new Integer(10), (Object)newArg.getValue());
        TestLog10FunctionModifier.assertEquals((String)"log(10, 5.2)", (String)SQLStringVisitor.getSQLString((LanguageObject)func));
    }
}

