/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.db2;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.TestCase;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.db2.DB2ExecutionFactory;

public class TestDB2ConvertModifier
extends TestCase {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();

    public TestDB2ConvertModifier(String name) {
        super(name);
    }

    public String helpGetString(Expression expr) throws Exception {
        DB2ExecutionFactory trans = new DB2ExecutionFactory();
        trans.start();
        SQLConversionVisitor sqlVisitor = trans.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)expr);
        return sqlVisitor.toString();
    }

    public void helpTest(Expression srcExpression, String tgtType, String expectedExpression) throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", Arrays.asList(srcExpression, LANG_FACTORY.createLiteral((Object)tgtType, String.class)), TypeFacility.getDataTypeClass((String)tgtType));
        TestDB2ConvertModifier.assertEquals((String)("Error converting from " + srcExpression.getType() + " to " + tgtType), (String)expectedExpression, (String)this.helpGetString((Expression)func));
    }

    public void testStringToChar() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "char", "cast('5' AS char(1))");
    }

    public void testStringToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "boolean", "CASE WHEN '5' IN ('false', '0') THEN 0 WHEN '5' IS NOT NULL THEN 1 END");
    }

    public void testStringToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "byte", "smallint('5')");
    }

    public void testStringToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "short", "smallint('5')");
    }

    public void testStringToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "integer", "integer('5')");
    }

    public void testStringToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "long", "bigint('5')");
    }

    public void testStringToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "biginteger", "cast('5' AS numeric(31,0))");
    }

    public void testStringToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "float", "cast(double('5') as real)");
    }

    public void testStringToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "double", "double('5')");
    }

    public void testStringToDate() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"2004-06-29", String.class), "date", "date('2004-06-29')");
    }

    public void testStringToTime() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"23:59:59", String.class), "time", "time('23:59:59')");
    }

    public void testStringToTimestamp() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"2004-06-29 23:59:59.987", String.class), "timestamp", "timestamp('2004-06-29 23:59:59.987')");
    }

    public void testStringToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "bigdecimal", "cast('5' AS numeric(31,12))");
    }

    public void testCharToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Character('5'), Character.class), "string", "'5'");
    }

    public void testBooleanToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "string", "CASE WHEN 1 = 0 THEN 'false' WHEN 1 IS NOT NULL THEN 'true' END");
    }

    public void testBooleanToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "byte", "1");
    }

    public void testBooleanToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "short", "1");
    }

    public void testBooleanToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "integer", "integer(1)");
    }

    public void testBooleanToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "long", "bigint(1)");
    }

    public void testBooleanToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "biginteger", "cast(1 AS numeric(31,0))");
    }

    public void testBooleanToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "float", "cast(1 AS real)");
    }

    public void testBooleanToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "double", "double(1)");
    }

    public void testBooleanToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "bigdecimal", "cast(1 AS numeric(31,12))");
    }

    public void testByteToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "string", "varchar(1)");
    }

    public void testByteToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    public void testByteToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "short", "1");
    }

    public void testByteToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "integer", "integer(1)");
    }

    public void testByteToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "long", "bigint(1)");
    }

    public void testByteToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "biginteger", "cast(1 AS numeric(31,0))");
    }

    public void testByteToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "float", "cast(1 AS real)");
    }

    public void testByteToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "double", "double(1)");
    }

    public void testByteToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "bigdecimal", "cast(1 AS numeric(31,12))");
    }

    public void testShortToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "string", "varchar(1)");
    }

    public void testShortToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    public void testShortToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "byte", "1");
    }

    public void testShortToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "integer", "integer(1)");
    }

    public void testShortToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "long", "bigint(1)");
    }

    public void testShortToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "biginteger", "cast(1 AS numeric(31,0))");
    }

    public void testShortToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "float", "cast(1 AS real)");
    }

    public void testShortToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "double", "double(1)");
    }

    public void testShortToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "bigdecimal", "cast(1 AS numeric(31,12))");
    }

    public void testIntegerToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "string", "varchar(1)");
    }

    public void testIntegerToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    public void testIntegerToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "byte", "smallint(1)");
    }

    public void testIntegerToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "short", "smallint(1)");
    }

    public void testIntegerToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "long", "bigint(1)");
    }

    public void testIntegerToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "biginteger", "cast(1 AS numeric(31,0))");
    }

    public void testIntegerToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "float", "cast(1 AS real)");
    }

    public void testIntegerToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "double", "double(1)");
    }

    public void testIntegerToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "bigdecimal", "cast(1 AS numeric(31,12))");
    }

    public void testLongToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "string", "varchar(1)");
    }

    public void testLongToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    public void testLongToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "byte", "smallint(1)");
    }

    public void testLongToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "short", "smallint(1)");
    }

    public void testLongToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "integer", "integer(1)");
    }

    public void testLongToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "biginteger", "cast(1 AS numeric(31,0))");
    }

    public void testLongToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "float", "cast(1 AS real)");
    }

    public void testLongToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "double", "double(1)");
    }

    public void testLongToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "bigdecimal", "cast(1 AS numeric(31,12))");
    }

    public void testBigIntegerToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "string", "varchar(1)");
    }

    public void testBigIntegerToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    public void testBigIntegerToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "byte", "smallint(1)");
    }

    public void testBigIntegerToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "short", "smallint(1)");
    }

    public void testBigIntegerToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "integer", "integer(1)");
    }

    public void testBigIntegerToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "long", "bigint(1)");
    }

    public void testBigIntegerToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "float", "cast(1 AS real)");
    }

    public void testBigIntegerToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "double", "double(1)");
    }

    public void testBigIntegerToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "bigdecimal", "cast(1 AS numeric(31,12))");
    }

    public void testFloatToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "string", "varchar(1.2)");
    }

    public void testFloatToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "boolean", "CASE WHEN 1.2 = 0 THEN 0 WHEN 1.2 IS NOT NULL THEN 1 END");
    }

    public void testFloatToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "byte", "smallint(1.2)");
    }

    public void testFloatToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "short", "smallint(1.2)");
    }

    public void testFloatToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "integer", "integer(1.2)");
    }

    public void testFloatToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "long", "bigint(1.2)");
    }

    public void testFloatToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "biginteger", "cast(1.2 AS numeric(31,0))");
    }

    public void testFloatToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "double", "double(1.2)");
    }

    public void testFloatToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "bigdecimal", "cast(1.2 AS numeric(31,12))");
    }

    public void testDoubleToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "string", "varchar(1.2)");
    }

    public void testDoubleToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "boolean", "CASE WHEN 1.2 = 0 THEN 0 WHEN 1.2 IS NOT NULL THEN 1 END");
    }

    public void testDoubleToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "byte", "smallint(1.2)");
    }

    public void testDoubleToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "short", "smallint(1.2)");
    }

    public void testDoubleToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "integer", "integer(1.2)");
    }

    public void testDoubleToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "long", "bigint(1.2)");
    }

    public void testDoubleToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "biginteger", "cast(1.2 AS numeric(31,0))");
    }

    public void testDoubleToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "float", "cast(1.2 AS real)");
    }

    public void testDoubleToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "bigdecimal", "cast(1.2 AS numeric(31,12))");
    }

    public void testBigDecimalToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "string", "varchar(1.0)");
    }

    public void testBigDecimalToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "boolean", "CASE WHEN 1.0 = 0 THEN 0 WHEN 1.0 IS NOT NULL THEN 1 END");
    }

    public void testBigDecimalToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "byte", "smallint(1.0)");
    }

    public void testBigDecimalToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "short", "smallint(1.0)");
    }

    public void testBigDecimalToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "integer", "integer(1.0)");
    }

    public void testBigDecimalToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "long", "bigint(1.0)");
    }

    public void testBigDecimalToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "biginteger", "cast(1.0 AS numeric(31,0))");
    }

    public void testBigDecimalToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "float", "cast(1.0 AS real)");
    }

    public void testBigDecimalToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "double", "double(1.0)");
    }

    public void testDateToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)103, (int)10, (int)1), Date.class), "string", "varchar({d '2003-11-01'})");
    }

    public void testDateToTimestamp() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)103, (int)10, (int)1), Date.class), "timestamp", "timestamp({d '2003-11-01'}, '00:00:00')");
    }

    public void testTimeToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createTime((int)23, (int)59, (int)59), Time.class), "string", "varchar({t '23:59:59'})");
    }

    public void testTimeToTimestamp() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createTime((int)23, (int)59, (int)59), Time.class), "timestamp", "timestamp('1970-01-01', {t '23:59:59'})");
    }

    public void testTimestampToString() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)103, (int)10, (int)1, (int)12, (int)5, (int)2, (int)0);
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)ts, Timestamp.class), "string", "varchar({ts '2003-11-01 12:05:02.0'})");
    }

    public void testTimestampToDate() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)103, (int)10, (int)1, (int)12, (int)5, (int)2, (int)0);
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)ts, Timestamp.class), "date", "date({ts '2003-11-01 12:05:02.0'})");
    }

    public void testTimestampToTime() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)103, (int)10, (int)1, (int)12, (int)5, (int)2, (int)0);
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)ts, Timestamp.class), "time", "time({ts '2003-11-01 12:05:02.0'})");
    }
}

