/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import javax.sql.rowset.serial.SerialStruct;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.util.MixinProxy;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.core.util.StringUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Insert;
import org.teiid.language.IsNull;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.Not;
import org.teiid.language.Parameter;
import org.teiid.language.QueryExpression;
import org.teiid.language.SearchedCase;
import org.teiid.language.SearchedWhenClause;
import org.teiid.language.SetQuery;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.DefaultSQLDialect;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCDirectQueryExecution;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.JDBCProcedureExecution;
import org.teiid.translator.jdbc.JDBCQueryExecution;
import org.teiid.translator.jdbc.JDBCUpdateExecution;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.SQLDialect;
import org.teiid.util.Version;

@Translator(name="jdbc-ansi", description="JDBC ANSI translator, can used with any ANSI compatible JDBC Driver")
public class JDBCExecutionFactory
extends ExecutionFactory<DataSource, Connection> {
    public static final int DEFAULT_MAX_IN_CRITERIA = 1000;
    public static final int DEFAULT_MAX_DEPENDENT_PREDICATES = 50;
    private final ThreadLocal<MessageFormat> comment = new ThreadLocal<MessageFormat>(){

        @Override
        protected MessageFormat initialValue() {
            return new MessageFormat(JDBCExecutionFactory.this.commentFormat);
        }
    };
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    private Map<String, FunctionModifier> functionModifiers = new TreeMap<String, FunctionModifier>(String.CASE_INSENSITIVE_ORDER);
    private boolean useBindVariables = true;
    private String databaseTimeZone;
    private boolean trimStrings;
    private boolean useCommentsInSourceQuery;
    private Version version;
    private int maxInsertBatchSize = 2048;
    private DatabaseCalender databaseCalender;
    private boolean supportsGeneratedKeys;
    private StructRetrieval structRetrieval = StructRetrieval.OBJECT;
    protected SQLDialect dialect;
    private boolean enableDependentJoins;
    private boolean useBindingsForDependentJoin = true;
    private String commentFormat = "/*teiid sessionid:{0}, requestid:{1}.{2}*/ ";
    private AtomicBoolean initialConnection = new AtomicBoolean(true);

    public JDBCExecutionFactory() {
        this.setSupportsFullOuterJoins(true);
        this.setSupportsOrderBy(true);
        this.setSupportsOuterJoins(true);
        this.setSupportsSelectDistinct(true);
        this.setSupportsInnerJoins(true);
        this.setMaxInCriteriaSize(1000);
        this.setMaxDependentInPredicates(50);
    }

    public void start() throws TranslatorException {
        super.start();
        this.databaseCalender = new DatabaseCalender(this.databaseTimeZone);
        if (this.useCommentsInSourceQuery) {
            new MessageFormat(this.commentFormat);
        }
    }

    @TranslatorProperty(display="Database Version", description="Database Version")
    public String getDatabaseVersion() {
        return this.version.toString();
    }

    public void setDatabaseVersion(String version) {
        this.version = Version.getVersion((String)version);
    }

    public void setDatabaseVersion(Version version) {
        this.version = version;
    }

    protected Version getVersion() {
        if (this.version == null) {
            throw new IllegalStateException("version not set");
        }
        return this.version;
    }

    @TranslatorProperty(display="Use Bind Variables", description="Use prepared statements and bind variables", advanced=true)
    public boolean useBindVariables() {
        return this.useBindVariables;
    }

    public void setUseBindVariables(boolean useBindVariables) {
        this.useBindVariables = useBindVariables;
    }

    @TranslatorProperty(display="Database time zone", description="Time zone of the database, if different than Integration Server", advanced=true)
    public String getDatabaseTimeZone() {
        return this.databaseTimeZone;
    }

    public void setDatabaseTimeZone(String databaseTimeZone) {
        this.databaseTimeZone = databaseTimeZone;
    }

    @TranslatorProperty(display="Trim string flag", description="Right Trim fixed character types returned as Strings - note that the native type must be char or nchar and the source must support the rtrim function.", advanced=true)
    public boolean isTrimStrings() {
        return this.trimStrings;
    }

    public void setTrimStrings(boolean trimStrings) {
        this.trimStrings = trimStrings;
    }

    @TranslatorProperty(display="Use informational comments in Source Queries", description="This will embed a /*comment*/ leading comment with session/request id in source SQL query for informational purposes", advanced=true)
    public boolean useCommentsInSourceQuery() {
        return this.useCommentsInSourceQuery;
    }

    public void setUseCommentsInSourceQuery(boolean useCommentsInSourceQuery) {
        this.useCommentsInSourceQuery = useCommentsInSourceQuery;
    }

    public boolean isSourceRequired() {
        return true;
    }

    public boolean isSourceRequiredForCapabilities() {
        return this.isSourceRequired() && this.version == null && this.usesDatabaseVersion();
    }

    protected boolean usesDatabaseVersion() {
        return false;
    }

    public void initCapabilities(Connection connection) throws TranslatorException {
        DatabaseMetaData metadata;
        block7: {
            if (connection == null) {
                return;
            }
            metadata = null;
            try {
                metadata = connection.getMetaData();
                if (this.version == null) {
                    String fullVersion = metadata.getDatabaseProductVersion();
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Setting the database version to", (Object)fullVersion);
                    this.setDatabaseVersion(fullVersion);
                }
            }
            catch (SQLException e) {
                if (this.version != null) break block7;
                throw new TranslatorException((Throwable)e);
            }
        }
        if (metadata != null) {
            try {
                this.supportsGeneratedKeys = metadata.supportsGetGeneratedKeys();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        return new JDBCQueryExecution((Command)command, conn, executionContext, this);
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        return new JDBCDirectQueryExecution(arguments, command, conn, executionContext, this);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        return new JDBCProcedureExecution((Command)command, conn, executionContext, this);
    }

    public JDBCUpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        return new JDBCUpdateExecution(command, conn, executionContext, this);
    }

    public Connection getConnection(DataSource ds) throws TranslatorException {
        try {
            Connection c = ds.getConnection();
            this.obtainedConnection(c);
            return c;
        }
        catch (SQLException e) {
            throw new TranslatorException((BundleUtil.Event)JDBCPlugin.Event.TEIID11009, (Throwable)e);
        }
    }

    public void closeConnection(Connection connection, DataSource factory) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)e, (Object)"Error closing");
        }
    }

    public void getMetadata(MetadataFactory metadataFactory, Connection conn) throws TranslatorException {
        try {
            if (conn == null) {
                throw new TranslatorException((BundleUtil.Event)JDBCPlugin.Event.TEIID11018, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11018, new Object[0]));
            }
            JDBCMetadataProcessor metadataProcessor = this.createMetadataProcessor();
            PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)metadataFactory.getModelProperties(), (String)"importer");
            metadataProcessor.getConnectorMetadata(conn, metadataFactory);
        }
        catch (SQLException e) {
            throw new TranslatorException((BundleUtil.Event)JDBCPlugin.Event.TEIID11010, (Throwable)e);
        }
    }

    @Deprecated
    protected JDBCMetadataProcessor createMetadataProcessor() {
        return (JDBCMetadataProcessor)this.getMetadataProcessor();
    }

    public MetadataProcessor<Connection> getMetadataProcessor() {
        return new JDBCMetadataProcessor();
    }

    public List<String> getSupportedFunctions() {
        return this.getDefaultSupportedFunctions();
    }

    public List<String> getDefaultSupportedFunctions() {
        return Arrays.asList("+", "-", "*", "/");
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsAggregatesAvg() {
        return true;
    }

    public boolean supportsAggregatesCount() {
        return true;
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public boolean supportsAggregatesDistinct() {
        return true;
    }

    public boolean supportsAggregatesMax() {
        return true;
    }

    public boolean supportsAggregatesMin() {
        return true;
    }

    public boolean supportsAggregatesSum() {
        return true;
    }

    public boolean supportsAliasedTable() {
        return true;
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean supportsExistsCriteria() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsInCriteriaSubquery() {
        return true;
    }

    public boolean supportsIsNullCriteria() {
        return true;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsLikeCriteriaEscapeCharacter() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return true;
    }

    public boolean supportsQuantifiedCompareCriteriaAll() {
        return true;
    }

    public boolean supportsScalarSubqueries() {
        return true;
    }

    public boolean supportsSearchedCaseExpressions() {
        return true;
    }

    public boolean supportsSelfJoins() {
        return true;
    }

    public boolean supportsInlineViews() {
        return false;
    }

    public boolean supportsQuantifiedCompareCriteriaSome() {
        return true;
    }

    public boolean supportsSetQueryOrderBy() {
        return true;
    }

    public boolean supportsUnions() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return true;
    }

    public boolean supportsBatchedUpdates() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsHaving() {
        return true;
    }

    public boolean supportsSelectExpression() {
        return true;
    }

    public boolean supportsInsertWithQueryExpression() {
        return true;
    }

    @TranslatorProperty(display="Max Prepared Insert Batch Size", description="The max size of a prepared insert batch.  Default 2048.", advanced=true)
    public int getMaxPreparedInsertBatchSize() {
        return this.maxInsertBatchSize;
    }

    public void setMaxPreparedInsertBatchSize(int maxInsertBatchSize) {
        if (maxInsertBatchSize < 1) {
            throw new AssertionError((Object)"Max prepared batch insert size must be greater than 0");
        }
        this.maxInsertBatchSize = maxInsertBatchSize;
    }

    public Calendar getDatabaseCalendar() {
        return (Calendar)this.databaseCalender.get();
    }

    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        Condition c;
        Parameter p;
        List<?> parts = null;
        if (obj instanceof Function) {
            Function function = (Function)obj;
            if (this.functionModifiers != null) {
                String name = function.getName();
                while (true) {
                    FunctionModifier modifier;
                    if ((modifier = this.functionModifiers.get(name)) != null) {
                        parts = modifier.translate(function);
                    } else {
                        int index = name.indexOf(46);
                        if (index >= 0 && index != name.length() - 1) {
                            name = name.substring(index + 1);
                            continue;
                        }
                    }
                    break;
                }
            }
        } else if (obj instanceof Command) {
            parts = this.translateCommand((Command)obj, context);
        } else if (obj instanceof Limit) {
            parts = this.translateLimit((Limit)obj, context);
        } else if (obj instanceof ColumnReference) {
            ColumnReference elem = (ColumnReference)obj;
            if (this.isTrimStrings() && elem.getType() == TypeFacility.RUNTIME_TYPES.STRING && elem.getMetadataObject() != null && ("char".equalsIgnoreCase(elem.getMetadataObject().getNativeType()) || "nchar".equalsIgnoreCase(elem.getMetadataObject().getNativeType()))) {
                return Arrays.asList(this.getLanguageFactory().createFunction("rtrim", new Expression[]{elem}, TypeFacility.RUNTIME_TYPES.STRING));
            }
        } else if (obj instanceof DerivedColumn) {
            Expression expr;
            DerivedColumn dc = (DerivedColumn)obj;
            if (dc.isProjected() && (expr = dc.getExpression()).getType() == TypeFacility.RUNTIME_TYPES.GEOMETRY) {
                dc.setExpression(this.translateGeometrySelect(expr));
            }
        } else if (obj instanceof Literal) {
            Literal l = (Literal)obj;
            if (l.getType() == TypeFacility.RUNTIME_TYPES.GEOMETRY && l.getValue() != null) {
                return this.translateGeometryLiteral(l);
            }
        } else if (obj instanceof Parameter && (p = (Parameter)obj).getType() == TypeFacility.RUNTIME_TYPES.GEOMETRY) {
            return this.translateGeometryParameter(p);
        }
        if (!this.supportsBooleanExpressions() && obj instanceof Condition && (c = (Condition)obj).isExpression()) {
            if (c instanceof IsNull) {
                return Arrays.asList(new SearchedCase(Arrays.asList(new SearchedWhenClause(c, (Expression)new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER))), (Expression)new Literal((Object)0, TypeFacility.RUNTIME_TYPES.INTEGER), TypeFacility.RUNTIME_TYPES.BOOLEAN));
            }
            return Arrays.asList(new SearchedCase(Arrays.asList(new SearchedWhenClause(c, (Expression)new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER)), new SearchedWhenClause((Condition)new Not(c), (Expression)new Literal((Object)0, TypeFacility.RUNTIME_TYPES.INTEGER))), null, TypeFacility.RUNTIME_TYPES.BOOLEAN));
        }
        return parts;
    }

    protected boolean supportsBooleanExpressions() {
        return true;
    }

    public Expression translateGeometrySelect(Expression expr) {
        return new Function("st_asbinary", Arrays.asList(expr), TypeFacility.RUNTIME_TYPES.BLOB);
    }

    public List<?> translateGeometryLiteral(Literal l) {
        Literal srid = this.getLanguageFactory().createLiteral((Object)((GeometryType)l.getValue()).getSrid(), Integer.class);
        return Arrays.asList(this.getLanguageFactory().createFunction("st_geomfromwkb", new Expression[]{l, srid}, TypeFacility.RUNTIME_TYPES.GEOMETRY));
    }

    public List<?> translateGeometryParameter(Parameter p) {
        Parameter srid = new Parameter();
        srid.setType(TypeFacility.RUNTIME_TYPES.INTEGER);
        srid.setValueIndex(p.getValueIndex());
        return Arrays.asList(this.getLanguageFactory().createFunction("st_geomfromwkb", new Expression[]{p, srid}, TypeFacility.RUNTIME_TYPES.GEOMETRY));
    }

    public Object retrieveGeometryValue(ResultSet results, int paramIndex) throws SQLException {
        GeometryType geom = null;
        Blob val = results.getBlob(paramIndex);
        if (val != null) {
            geom = new GeometryType(val);
        }
        return geom;
    }

    public GeometryType retrieveGeometryValue(CallableStatement results, int parameterIndex) throws SQLException {
        throw new SQLException(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11022, new Object[0]));
    }

    public List<?> translateCommand(Command command, ExecutionContext context) {
        return null;
    }

    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        return null;
    }

    public Map<String, FunctionModifier> getFunctionModifiers() {
        return this.functionModifiers;
    }

    public void registerFunctionModifier(String name, FunctionModifier modifier) {
        this.functionModifiers.put(name, modifier);
    }

    public String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "1";
        }
        return "0";
    }

    public String translateLiteralDate(java.sql.Date dateValue) {
        return "{d '" + this.formatDateValue(dateValue) + "'}";
    }

    public String translateLiteralTime(Time timeValue) {
        return "{t '" + this.formatDateValue(timeValue) + "'}";
    }

    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "{ts '" + this.formatDateValue(timestampValue) + "'}";
    }

    public String formatDateValue(Date dateObject, boolean useTimezone) {
        if (dateObject instanceof Timestamp && this.getTimestampNanoPrecision() < 9) {
            Timestamp ts = (Timestamp)dateObject;
            Timestamp newTs = new Timestamp(ts.getTime());
            if (this.getTimestampNanoPrecision() > 0) {
                int mask = (int)Math.pow(10.0, 9 - this.getTimestampNanoPrecision());
                newTs.setNanos(ts.getNanos() / mask * mask);
            } else {
                newTs.setNanos(0);
            }
            dateObject = newTs;
        }
        if (!useTimezone) {
            return dateObject.toString();
        }
        return this.getTypeFacility().convertDate(dateObject, this.getDatabaseCalendar().getTimeZone(), TimestampWithTimezone.getCalendar(), dateObject.getClass()).toString();
    }

    public String formatDateValue(Date dateObject) {
        return this.formatDateValue(dateObject, true);
    }

    public String translateLiteralBinaryType(BinaryType obj) {
        return "X'" + obj + "'";
    }

    public boolean addSourceComment() {
        return this.useCommentsInSourceQuery();
    }

    public boolean useAsInGroupAlias() {
        return true;
    }

    public boolean usePreparedStatements() {
        return this.useBindVariables();
    }

    public boolean useParensForSetQueries() {
        return false;
    }

    public boolean hasTimeType() {
        return true;
    }

    public String getSetOperationString(SetQuery.Operation operation) {
        return operation.toString();
    }

    public String getSourceComment(ExecutionContext context, Command command) {
        if (this.addSourceComment() && context != null) {
            return this.comment.get().format(new Object[]{context.getConnectionId(), context.getRequestId(), context.getPartIdentifier(), context.getExecutionCountIdentifier(), context.getSession().getUserName(), context.getVdbName(), context.getVdbVersion(), context.isTransactional()});
        }
        return "";
    }

    public String replaceElementName(String group, String element) {
        return null;
    }

    public int getTimestampNanoPrecision() {
        return 9;
    }

    public ResultSet executeStoredProcedure(CallableStatement statement, List<Argument> preparedValues, Class<?> returnType) throws SQLException {
        int update_count;
        int index = 1;
        if (returnType != null) {
            this.registerSpecificTypeOfOutParameter(statement, returnType, index++);
        }
        for (Argument param : preparedValues) {
            if (param.getDirection() == Argument.Direction.INOUT) {
                this.registerSpecificTypeOfOutParameter(statement, param.getType(), index);
            } else if (param.getDirection() == Argument.Direction.OUT) {
                this.registerSpecificTypeOfOutParameter(statement, param.getType(), index++);
            }
            if (param.getDirection() != Argument.Direction.IN && param.getDirection() != Argument.Direction.INOUT) continue;
            this.bindValue(statement, param.getArgumentValue().getValue(), param.getType(), index++);
        }
        boolean resultSetNext = statement.execute();
        while (!resultSetNext && (update_count = statement.getUpdateCount()) != -1) {
            resultSetNext = statement.getMoreResults();
        }
        return statement.getResultSet();
    }

    protected void registerSpecificTypeOfOutParameter(CallableStatement statement, Class<?> runtimeType, int index) throws SQLException {
        int typeToSet = TypeFacility.getSQLTypeFromRuntimeType(runtimeType);
        statement.registerOutParameter(index, typeToSet);
    }

    public void bindValue(PreparedStatement stmt, Object param, Class<?> paramType, int i) throws SQLException {
        int type = TypeFacility.getSQLTypeFromRuntimeType(paramType);
        if (param == null) {
            if (type == 2000) {
                stmt.setNull(i, 1111);
            } else {
                stmt.setNull(i, type);
            }
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.DATE)) {
            stmt.setDate(i, (java.sql.Date)param, this.getDatabaseCalendar());
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.TIME)) {
            stmt.setTime(i, (Time)param, this.getDatabaseCalendar());
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.TIMESTAMP)) {
            stmt.setTimestamp(i, (Timestamp)param, this.getDatabaseCalendar());
            return;
        }
        if (TypeFacility.RUNTIME_TYPES.BIG_DECIMAL.equals(paramType)) {
            stmt.setBigDecimal(i, (BigDecimal)param);
            return;
        }
        if (paramType == TypeFacility.RUNTIME_TYPES.INTEGER && param instanceof GeometryType) {
            stmt.setInt(i, ((GeometryType)param).getSrid());
            return;
        }
        if (this.useStreamsForLobs()) {
            if (param instanceof Blob) {
                Blob blob = (Blob)param;
                long length = blob.length();
                if (length <= Integer.MAX_VALUE) {
                    stmt.setBinaryStream(i, blob.getBinaryStream(), (int)length);
                } else {
                    stmt.setBinaryStream(i, blob.getBinaryStream(), length);
                }
                return;
            }
            if (param instanceof Clob) {
                Clob clob = (Clob)param;
                long length = clob.length();
                if (length <= Integer.MAX_VALUE) {
                    stmt.setCharacterStream(i, clob.getCharacterStream(), (int)clob.length());
                } else {
                    stmt.setCharacterStream(i, clob.getCharacterStream(), length);
                }
                return;
            }
        }
        if (TypeFacility.RUNTIME_TYPES.BIG_INTEGER.equals(paramType)) {
            param = new BigDecimal((BigInteger)param);
        } else if (TypeFacility.RUNTIME_TYPES.FLOAT.equals(paramType)) {
            param = new Double(((Float)param).doubleValue());
        } else if (TypeFacility.RUNTIME_TYPES.CHAR.equals(paramType)) {
            param = ((Character)param).toString();
        } else if (paramType.equals(TypeFacility.RUNTIME_TYPES.VARBINARY)) {
            param = ((BinaryType)param).getBytesDirect();
        }
        if (type != 2000) {
            if (this.useUnicodePrefix()) {
                if (type == 12) {
                    if (SQLConversionVisitor.isNonAscii(param.toString())) {
                        type = -9;
                    }
                } else if (type == 2005) {
                    type = 2011;
                }
            }
            stmt.setObject(i, param, type);
        } else {
            stmt.setObject(i, param);
        }
    }

    public boolean useStreamsForLobs() {
        return false;
    }

    public Object retrieveValue(ResultSet results, int columnIndex, Class<?> expectedType) throws SQLException {
        Integer code = DataTypeManager.getTypeCode(expectedType);
        if (code != null) {
            switch (code) {
                case 5: {
                    int value = results.getInt(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 6: {
                    long value = results.getLong(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 9: {
                    double value = results.getDouble(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 10: {
                    return results.getBigDecimal(columnIndex);
                }
                case 4: {
                    short value = results.getShort(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 8: {
                    float value2 = results.getFloat(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return Float.valueOf(value2);
                }
                case 12: {
                    return results.getTime(columnIndex, this.getDatabaseCalendar());
                }
                case 11: {
                    return results.getDate(columnIndex, this.getDatabaseCalendar());
                }
                case 13: {
                    return results.getTimestamp(columnIndex, this.getDatabaseCalendar());
                }
                case 15: {
                    try {
                        return results.getBlob(columnIndex);
                    }
                    catch (SQLException value2) {
                        try {
                            return results.getBytes(columnIndex);
                        }
                        catch (SQLException value2) {
                            break;
                        }
                    }
                }
                case 20: {
                    return this.retrieveGeometryValue(results, columnIndex);
                }
                case 16: {
                    try {
                        return results.getClob(columnIndex);
                    }
                    catch (SQLException value2) {
                        break;
                    }
                }
                case 2: {
                    boolean result = results.getBoolean(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return result;
                }
                case 19: {
                    try {
                        return results.getBytes(columnIndex);
                    }
                    catch (SQLException result) {
                        // empty catch block
                    }
                }
            }
        }
        Object result = results.getObject(columnIndex);
        if (expectedType == TypeFacility.RUNTIME_TYPES.OBJECT) {
            return this.convertObject(result);
        }
        return result;
    }

    public Object retrieveValue(CallableStatement results, int parameterIndex, Class<?> expectedType) throws SQLException {
        Integer code = DataTypeManager.getTypeCode(expectedType);
        if (code != null) {
            switch (code) {
                case 5: {
                    int value = results.getInt(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 6: {
                    long value = results.getLong(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 9: {
                    double value = results.getDouble(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return new Double(value);
                }
                case 10: {
                    return results.getBigDecimal(parameterIndex);
                }
                case 4: {
                    short value = results.getShort(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 8: {
                    float value2 = results.getFloat(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return new Float(value2);
                }
                case 12: {
                    return results.getTime(parameterIndex, this.getDatabaseCalendar());
                }
                case 11: {
                    return results.getDate(parameterIndex, this.getDatabaseCalendar());
                }
                case 13: {
                    return results.getTimestamp(parameterIndex, this.getDatabaseCalendar());
                }
                case 15: {
                    try {
                        return results.getBlob(parameterIndex);
                    }
                    catch (SQLException value2) {
                        try {
                            return results.getBytes(parameterIndex);
                        }
                        catch (SQLException value2) {
                            // empty catch block
                        }
                    }
                }
                case 20: {
                    return this.retrieveGeometryValue(results, parameterIndex);
                }
                case 16: {
                    try {
                        return results.getClob(parameterIndex);
                    }
                    catch (SQLException value2) {
                        // empty catch block
                    }
                }
                case 2: {
                    boolean result = results.getBoolean(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return result;
                }
                case 19: {
                    try {
                        return results.getBytes(parameterIndex);
                    }
                    catch (SQLException result) {
                        // empty catch block
                    }
                }
            }
        }
        Object result = results.getObject(parameterIndex);
        if (expectedType == TypeFacility.RUNTIME_TYPES.OBJECT) {
            return this.convertObject(result);
        }
        return result;
    }

    protected Object convertObject(Object object) throws SQLException {
        if (object instanceof Struct) {
            switch (this.structRetrieval) {
                case OBJECT: {
                    return object;
                }
                case ARRAY: {
                    return new ArrayImpl(((Struct)object).getAttributes());
                }
                case COPY: {
                    return new SerialStruct((Struct)object, Collections.emptyMap());
                }
            }
        }
        return object;
    }

    protected void afterInitialConnectionObtained(Connection connection) {
        try {
            StringBuffer sb = new StringBuffer(((Object)((Object)this)).getClass().getSimpleName());
            DatabaseMetaData dbmd = connection.getMetaData();
            sb.append(" Commit=").append(connection.getAutoCommit());
            sb.append(";DatabaseProductName=").append(dbmd.getDatabaseProductName());
            sb.append(";DatabaseProductVersion=").append(dbmd.getDatabaseProductVersion());
            sb.append(";DriverMajorVersion=").append(dbmd.getDriverMajorVersion());
            sb.append(";DriverMajorVersion=").append(dbmd.getDriverMinorVersion());
            sb.append(";DriverName=").append(dbmd.getDriverName());
            sb.append(";DriverVersion=").append(dbmd.getDriverVersion());
            sb.append(";IsolationLevel=").append(dbmd.getDefaultTransactionIsolation());
            LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)sb.toString());
        }
        catch (SQLException e) {
            LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11002, new Object[0]));
        }
    }

    public void obtainedConnection(Connection connection) {
        if (this.initialConnection.compareAndSet(true, false)) {
            this.afterInitialConnectionObtained(connection);
        }
    }

    public SQLConversionVisitor getSQLConversionVisitor() {
        return new SQLConversionVisitor(this);
    }

    public boolean useParensForJoins() {
        return false;
    }

    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.LOW;
    }

    public boolean useSelectLimit() {
        return false;
    }

    public static List<String> parseName(String tableName, char escape, char delim) {
        boolean quoted = false;
        boolean escaped = false;
        LinkedList<String> nameParts = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            if (quoted) {
                if (c == escape) {
                    if (escaped) {
                        current.append(c);
                    }
                    escaped = !escaped;
                    continue;
                }
                if (c == delim) {
                    if (escaped) {
                        escaped = false;
                        quoted = false;
                        nameParts.add(current.toString());
                        current = new StringBuilder();
                        continue;
                    }
                    current.append(c);
                    continue;
                }
                current.append(c);
                continue;
            }
            if (c == escape) {
                if (current.length() == 0) {
                    quoted = true;
                    continue;
                }
                current.append(c);
                continue;
            }
            if (c == delim) {
                quoted = false;
                nameParts.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            nameParts.add(current.toString());
        }
        return nameParts;
    }

    public String getLikeRegexString() {
        return "LIKE_REGEX";
    }

    public void setFetchSize(Command command, ExecutionContext context, Statement statement, int fetchSize) throws SQLException {
        statement.setFetchSize(fetchSize);
    }

    public boolean supportsGeneratedKeys() {
        return this.supportsGeneratedKeys;
    }

    @TranslatorProperty(display="Struct retrieval", description="Struct retrieval mode (OBJECT, COPY, ARRAY)", advanced=true)
    public StructRetrieval getStructRetrieval() {
        return this.structRetrieval;
    }

    public void setStructRetrieval(StructRetrieval structRetrieval) {
        this.structRetrieval = structRetrieval;
    }

    protected boolean supportsGeneratedKeys(ExecutionContext context, Command command) {
        return this.supportsGeneratedKeys() && command instanceof Insert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTempTable(String prefix, List<ColumnReference> cols, ExecutionContext context, Connection connection) throws SQLException {
        String name = this.getTemporaryTableName(prefix);
        String sql = this.getCreateTempTableSQL(name, cols, !connection.getAutoCommit());
        Statement s = connection.createStatement();
        try {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"creating temporary table with:", (Object)sql);
            s.execute(sql);
        }
        finally {
            try {
                s.close();
            }
            catch (SQLException sQLException) {}
        }
        return name;
    }

    public String getCreateTempTableSQL(String name, List<ColumnReference> cols, boolean transactional) {
        SQLDialect d = this.getDialect();
        StringBuilder sb = new StringBuilder(this.getCreateTemporaryTableString(transactional)).append(" ");
        sb.append(name).append(" (");
        Iterator<ColumnReference> iter = cols.iterator();
        while (iter.hasNext()) {
            ColumnReference col = iter.next();
            sb.append(col.getName());
            sb.append(" ");
            Integer defaultValue = JDBCSQLTypeInfo.getDefaultPrecision((Class)col.getType());
            int precision = defaultValue == null ? 255 : defaultValue;
            int scale = col.getType() == TypeFacility.RUNTIME_TYPES.BIG_DECIMAL ? 2 : 0;
            long length = precision;
            if (col.getMetadataObject() != null) {
                precision = col.getMetadataObject().getPrecision();
                scale = col.getMetadataObject().getScale();
                length = col.getMetadataObject().getLength();
            }
            sb.append(d.getTypeName(TypeFacility.getSQLTypeFromRuntimeType((Class)col.getType()), length, precision, scale));
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(") ");
        if (this.getCreateTemporaryTablePostfix(transactional) != null) {
            sb.append(this.getCreateTemporaryTablePostfix(transactional));
        }
        String sql = sb.toString();
        return sql;
    }

    public String getTemporaryTableName(String prefix) {
        return prefix;
    }

    public String getCreateTemporaryTablePostfix(boolean inTransaction) {
        return this.getDialect().getDefaultMultiTableBulkIdStrategy().getIdTableSupport().getCreateIdTableStatementOptions();
    }

    public String getCreateTemporaryTableString(boolean inTransaction) {
        return this.getDialect().getDefaultMultiTableBulkIdStrategy().getIdTableSupport().getCreateIdTableCommand();
    }

    public SQLDialect getDialect() {
        if (this.dialect == null) {
            String name = this.getHibernateDialectClassName();
            if (name != null) {
                try {
                    Object impl = ReflectionHelper.create((String)name, null, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    MixinProxy handler = new MixinProxy(new Object[]{impl});
                    this.dialect = (SQLDialect)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{SQLDialect.class}, (InvocationHandler)handler);
                }
                catch (TeiidException e) {
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)((Object)e), (Object)name, (Object)"could not be loaded");
                }
            }
            if (this.dialect == null) {
                this.dialect = new DefaultSQLDialect();
            }
        }
        return this.dialect;
    }

    public String getHibernateDialectClassName() {
        return null;
    }

    public boolean supportsDependentJoins() {
        return this.enableDependentJoins && this.getDialect().getDefaultMultiTableBulkIdStrategy() != null;
    }

    public boolean supportsFullDependentJoins() {
        return this.supportsDependentJoins();
    }

    public boolean tempTableRequiresTransaction() {
        return false;
    }

    public void loadedTemporaryTable(String tableName, ExecutionContext context, Connection connection) throws SQLException {
    }

    @TranslatorProperty(display="Enable Dependent Joins", description="Enable Dependent Join Pushdown", advanced=true)
    public boolean isEnableDependentJoins() {
        return this.enableDependentJoins;
    }

    public void setEnableDependentJoins(boolean enableDependentJoins) {
        this.enableDependentJoins = enableDependentJoins;
    }

    public boolean useWithRollup() {
        return false;
    }

    @TranslatorProperty(display="Comment Format", description="Comment format string used with useCommentsInSourceQuery")
    public String getCommentFormat() {
        return this.commentFormat;
    }

    public void setCommentFormat(String commentFormat) {
        this.commentFormat = commentFormat;
    }

    public boolean useScientificNotation() {
        return false;
    }

    public boolean useUnicodePrefix() {
        return false;
    }

    protected boolean isNonAscii(Expression obj) {
        Function f;
        if (obj == null || obj.getType() != TypeFacility.RUNTIME_TYPES.STRING && obj.getType() != TypeFacility.RUNTIME_TYPES.CHAR && obj.getType() != TypeFacility.RUNTIME_TYPES.CLOB) {
            return false;
        }
        if (obj instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)obj;
            return cr.getMetadataObject() == null || StringUtil.startsWithIgnoreCase((String)cr.getMetadataObject().getNativeType(), (String)"N");
        }
        if (obj.getType() == TypeFacility.RUNTIME_TYPES.CLOB) {
            return true;
        }
        if (obj instanceof Literal) {
            Object value = ((Literal)obj).getValue();
            if (value != null) {
                return SQLConversionVisitor.isNonAscii(value.toString());
            }
            return false;
        }
        if (obj instanceof Parameter) {
            return true;
        }
        if (obj instanceof Function && this.isNonAsciiFunction(f = (Function)obj)) {
            return true;
        }
        final boolean[] result = new boolean[1];
        HierarchyVisitor v = new HierarchyVisitor(){

            public void visit(ColumnReference cr) {
                if (JDBCExecutionFactory.this.isNonAscii((Expression)cr)) {
                    result[0] = true;
                }
            }

            public void visit(Literal l) {
                if (JDBCExecutionFactory.this.isNonAscii((Expression)l)) {
                    result[0] = true;
                }
            }

            public void visit(Parameter p) {
                result[0] = true;
            }
        };
        v.visitNode((LanguageObject)obj);
        return result[0];
    }

    protected boolean isNonAsciiFunction(Function f) {
        return false;
    }

    public void intializeConnectionAfterCancel(Connection c) throws SQLException {
    }

    @TranslatorProperty(display="Use Bindings For Dependent Join", description="If PreparedStatement bindings should be used for dependent join values.")
    public boolean useBindingsForDependentJoin() {
        return this.useBindingsForDependentJoin;
    }

    public void setUseBindingsForDependentJoin(boolean useBindingsForDependentJoin) {
        this.useBindingsForDependentJoin = useBindingsForDependentJoin;
    }

    public boolean useColumnNamesForGeneratedKeys() {
        return false;
    }

    public String getLateralKeyword() {
        return "LATERAL";
    }

    static class DatabaseCalender
    extends ThreadLocal<Calendar> {
        private String timeZone;

        public DatabaseCalender(String tz) {
            this.timeZone = tz;
        }

        @Override
        protected Calendar initialValue() {
            if (this.timeZone != null && this.timeZone.trim().length() > 0) {
                TimeZone tz = TimeZone.getTimeZone(this.timeZone);
                if (!TimestampWithTimezone.getCalendar().getTimeZone().hasSameRules(tz)) {
                    return Calendar.getInstance(tz);
                }
            }
            return Calendar.getInstance();
        }
    }

    public static enum StructRetrieval {
        OBJECT,
        COPY,
        ARRAY;

    }
}

