/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.informix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.AggregateFunction;
import org.teiid.language.Expression;
import org.teiid.language.LanguageObject;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;

@Translator(name="informix", description="A translator for Informix Database")
public class InformixExecutionFactory
extends JDBCExecutionFactory {
    private ConvertModifier convertModifier;

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.convertModifier = new ConvertModifier();
        this.convertModifier.addTypeMapping("boolean", 2);
        this.convertModifier.addTypeMapping("smallint", 3, 4);
        this.convertModifier.addTypeMapping("integer", 5);
        this.convertModifier.addTypeMapping("int8", 6);
        this.convertModifier.addTypeMapping("decimal(32,0)", 7);
        this.convertModifier.addTypeMapping("decimal", 10);
        this.convertModifier.addTypeMapping("smallfloat", 8);
        this.convertModifier.addTypeMapping("float", 9);
        this.convertModifier.addTypeMapping("date", 11);
        this.convertModifier.addTypeMapping("datetime", 13);
        this.convertModifier.addTypeMapping("datetime hour to second", 13);
        this.convertModifier.addTypeMapping("varchar(255)", 0);
        this.convertModifier.addTypeMapping("varchar(1)", 1);
        this.convertModifier.addTypeMapping("byte", 19);
        this.convertModifier.addTypeMapping("blob", 15);
        this.convertModifier.addTypeMapping("clob", 16);
        this.convertModifier.setWideningNumericImplicit(true);
        this.registerFunctionModifier("convert", this.convertModifier);
    }

    public List getSupportedFunctions() {
        ArrayList<String> supportedFunctons = new ArrayList<String>();
        supportedFunctons.addAll(super.getSupportedFunctions());
        supportedFunctons.add("CAST");
        supportedFunctons.add("CONVERT");
        return supportedFunctons;
    }

    public boolean supportsConvert(int fromType, int toType) {
        if (!super.supportsConvert(fromType, toType)) {
            return false;
        }
        return this.convertModifier.hasTypeMapping(toType);
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        AggregateFunction agg;
        if (obj instanceof AggregateFunction && (agg = (AggregateFunction)obj).getParameters().size() == 1 && (agg.getName().equalsIgnoreCase("MIN") || agg.getName().equalsIgnoreCase("MAX")) && TypeFacility.RUNTIME_TYPES.BOOLEAN.equals(((Expression)agg.getParameters().get(0)).getType())) {
            return Arrays.asList("cast(", agg.getName(), "(cast(", agg.getParameters().get(0), " as char)) as boolean)");
        }
        return super.translate(obj, context);
    }
}

