/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.h2;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.h2.H2ExecutionFactory;

public class TestH2Translator {
    private static H2ExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        TRANSLATOR = new H2ExecutionFactory();
        TRANSLATOR.start();
    }

    @Test
    public void testTimestampDiff() throws Exception {
        String input = "select h2.timestampdiff('SQL_TSI_FRAC_SECOND', timestampvalue, {d '1970-01-01'}) from BQT1.Smalla";
        String output = "SELECT datediff('MILLISECOND', SmallA.TimestampValue, TIMESTAMP '1970-01-01 00:00:00.0') * 1000000 FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimestampAdd() throws Exception {
        String input = "select timestampadd(SQL_TSI_FRAC_SECOND, 2, datevalue) from BQT1.Smalla";
        String output = "SELECT cast(dateadd('MILLISECOND', (2 / 1000000), cast(SmallA.DateValue AS timestamp)) AS date) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimestampAdd1() throws Exception {
        String input = "select timestampadd(SQL_TSI_HOUR, intnum, {t '00:00:00'}) from BQT1.Smalla";
        String output = "SELECT cast(dateadd('HOUR', SmallA.IntNum, TIMESTAMP '1970-01-01 00:00:00.0') AS time) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLikeEscape() throws Exception {
        String input = "select 1 from BQT1.Smalla where stringkey like '_a*'";
        String output = "SELECT 1 FROM SmallA WHERE SmallA.StringKey LIKE '_a*' ESCAPE ''";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTempTable() throws Exception {
        Assert.assertEquals((Object)"create cached local temporary table if not exists foo (COL1 integer, COL2 varchar(100)) on commit drop transactional", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)TRANSLATOR, true));
    }

    @Test
    public void testJoinNesting() throws Exception {
        String input = "select a.intkey from (BQT1.Smalla a left outer join bqt1.smallb b on a.intkey = b.intkey) inner join (bqt1.mediuma ma inner join bqt1.mediumb mb on mb.intkey = ma.intkey) on a.intkey = mb.intkey";
        String output = "SELECT a.IntKey FROM SmallA AS a LEFT OUTER JOIN SmallB AS b ON a.IntKey = b.IntKey INNER JOIN (MediumA AS ma INNER JOIN MediumB AS mb ON mb.IntKey = ma.IntKey) ON a.IntKey = mb.IntKey";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }
}

