/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.sybase;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.sybase.SybaseIQExecutionFactory;
import org.teiid.util.Version;

public class TestSybaseIQConvertModifier {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();
    private static SybaseIQExecutionFactory trans = new SybaseIQExecutionFactory();

    @BeforeClass
    public static void setup() throws TranslatorException {
        trans.setDatabaseVersion(Version.DEFAULT_VERSION);
        trans.start();
    }

    public String helpGetString(Expression expr) throws Exception {
        SQLConversionVisitor sqlVisitor = trans.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)expr);
        return sqlVisitor.toString();
    }

    private void helpGetString1(Function func, String expectedStr) throws Exception {
        Assert.assertEquals((Object)expectedStr, (Object)this.helpGetString((Expression)func));
    }

    public void helpTest(Expression srcExpression, String tgtType, String expectedExpression) throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{srcExpression, LANG_FACTORY.createLiteral((Object)tgtType, String.class)}, DataTypeManager.getDataTypeClass((String)tgtType));
        Assert.assertEquals((String)("Error converting from " + DataTypeManager.getDataTypeName((Class)srcExpression.getType()) + " to " + tgtType), (Object)expectedExpression, (Object)this.helpGetString((Expression)func));
    }

    @Test
    public void testModDrop() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"5", String.class), LANG_FACTORY.createLiteral((Object)"integer", String.class)}, Integer.class);
        Assert.assertEquals((Object)"cast('5' AS int)", (Object)this.helpGetString((Expression)func));
    }

    @Test
    public void testStringToDate() throws Exception {
        String dateStr = "2003-12-31";
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)dateStr, String.class), LANG_FACTORY.createLiteral((Object)"date", String.class)}, Date.class);
        Assert.assertEquals((Object)"cast('2003-12-31' AS date)", (Object)this.helpGetString((Expression)func));
    }

    @Test
    public void testTimestampToDate() throws Exception {
        Literal c = LANG_FACTORY.createLiteral((Object)TimestampUtil.createTimestamp((int)89, (int)2, (int)3, (int)7, (int)8, (int)12, (int)99999), Timestamp.class);
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{c, LANG_FACTORY.createLiteral((Object)"date", String.class)}, Date.class);
        this.helpGetString1(func, "cast(CAST('1989-03-03 07:08:12.0' AS TIMESTAMP) AS date)");
    }

    @Test
    public void testStringToTime() throws Exception {
        String timeStr = "12:08:07";
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)timeStr, String.class), LANG_FACTORY.createLiteral((Object)"time", String.class)}, Time.class);
        this.helpGetString1(func, "cast('12:08:07' AS time)");
    }

    @Test
    public void testTimestampToTime() throws Exception {
        Literal c = LANG_FACTORY.createLiteral((Object)TimestampUtil.createTimestamp((int)89, (int)2, (int)3, (int)7, (int)8, (int)12, (int)99999), Timestamp.class);
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{c, LANG_FACTORY.createLiteral((Object)"time", String.class)}, Time.class);
        this.helpGetString1(func, "cast(CAST('1989-03-03 07:08:12.0' AS TIMESTAMP) AS time)");
    }

    @Test
    public void testStringToTimestamp() throws Exception {
        String timestampStr = "1989-07-09 12:08:07";
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)timestampStr, String.class), LANG_FACTORY.createLiteral((Object)"timestamp", String.class)}, Timestamp.class);
        this.helpGetString1(func, "cast('1989-07-09 12:08:07' AS timestamp)");
    }

    @Test
    public void testTimeToTimestamp() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)TimestampUtil.createTime((int)12, (int)2, (int)3), Time.class), LANG_FACTORY.createLiteral((Object)"timestamp", String.class)}, Timestamp.class);
        this.helpGetString1(func, "cast(CAST('12:02:03' AS TIME) AS timestamp)");
    }

    @Test
    public void testDateToTimestamp() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)89, (int)2, (int)3), Date.class), LANG_FACTORY.createLiteral((Object)"timestamp", String.class)}, Timestamp.class);
        this.helpGetString1(func, "cast(CAST('1989-03-03' AS DATE) AS timestamp)");
    }

    @Test
    public void testBooleanToStringa() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), LANG_FACTORY.createLiteral((Object)"string", String.class)}, String.class);
        this.helpGetString1(func, "CASE WHEN 1 = 0 THEN 'false' ELSE 'true' END");
    }

    @Test
    public void testTimestampToString() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)103, (int)10, (int)1, (int)12, (int)5, (int)2, (int)0);
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)ts, Timestamp.class), LANG_FACTORY.createLiteral((Object)"string", String.class)}, String.class);
        this.helpGetString1(func, "convert(varchar, CAST('2003-11-01 12:05:02.0' AS TIMESTAMP), 121)");
    }

    @Test
    public void testDateToString() throws Exception {
        Date d = TimestampUtil.createDate((int)103, (int)10, (int)1);
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)d, Date.class), LANG_FACTORY.createLiteral((Object)"string", String.class)}, String.class);
        this.helpGetString1(func, "stuff(stuff(convert(varchar, CAST('2003-11-01' AS DATE), 102), 5, 1, '-'), 8, 1, '-')");
    }

    @Test
    public void testTimeToString() throws Exception {
        Time t = TimestampUtil.createTime((int)3, (int)10, (int)1);
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)t, Time.class), LANG_FACTORY.createLiteral((Object)"string", String.class)}, String.class);
        this.helpGetString1(func, "convert(varchar, CAST('03:10:01' AS TIME), 8)");
    }

    @Test
    public void testBigDecimalToString() throws Exception {
        BigDecimal m = new BigDecimal("-123124534.3");
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)m, BigDecimal.class), LANG_FACTORY.createLiteral((Object)"string", String.class)}, String.class);
        this.helpGetString1(func, "cast(-123124534.3 AS varchar(4000))");
    }

    @Test
    public void testStringToChar() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"12", String.class), LANG_FACTORY.createLiteral((Object)"char", Character.class)}, Character.class);
        this.helpGetString1(func, "cast('12' AS char(1))");
    }

    @Test
    public void testStringToBoolean() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"true", String.class), LANG_FACTORY.createLiteral((Object)"boolean", Boolean.class)}, Boolean.class);
        this.helpGetString1(func, "CASE WHEN 'true' IN ('false', '0') THEN 0 WHEN 'true' IS NOT NULL THEN 1 END");
    }

    @Test
    public void testByteToBoolean() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), LANG_FACTORY.createLiteral((Object)"boolean", Boolean.class)}, Boolean.class);
        this.helpGetString1(func, "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testShortToBoolean() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Short(0), Short.class), LANG_FACTORY.createLiteral((Object)"boolean", Boolean.class)}, Boolean.class);
        this.helpGetString1(func, "CASE WHEN 0 = 0 THEN 0 WHEN 0 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testIntegerToBoolean() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), LANG_FACTORY.createLiteral((Object)"boolean", Boolean.class)}, Boolean.class);
        this.helpGetString1(func, "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testLongToBoolean() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), LANG_FACTORY.createLiteral((Object)"boolean", Boolean.class)}, Boolean.class);
        this.helpGetString1(func, "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testBigIntegerToBoolean() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), LANG_FACTORY.createLiteral((Object)"boolean", Boolean.class)}, Boolean.class);
        this.helpGetString1(func, "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testFloatToBoolean() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Float(1.0f), Float.class), LANG_FACTORY.createLiteral((Object)"boolean", Boolean.class)}, Boolean.class);
        this.helpGetString1(func, "CASE WHEN 1.0 = 0 THEN 0 WHEN 1.0 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testDoubleToBoolean() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Double(1.0), Double.class), LANG_FACTORY.createLiteral((Object)"boolean", Boolean.class)}, Boolean.class);
        this.helpGetString1(func, "CASE WHEN 1.0 = 0 THEN 0 WHEN 1.0 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testBigDecimalToBoolean() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), LANG_FACTORY.createLiteral((Object)"boolean", Boolean.class)}, Boolean.class);
        this.helpGetString1(func, "CASE WHEN 1.0 = 0 THEN 0 WHEN 1.0 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testStringToByte() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"12", String.class), LANG_FACTORY.createLiteral((Object)"byte", Byte.class)}, Byte.class);
        this.helpGetString1(func, "cast('12' AS smallint)");
    }

    @Test
    public void testBooleanToBytea() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), LANG_FACTORY.createLiteral((Object)"byte", Byte.class)}, Byte.class);
        this.helpGetString1(func, "1");
    }

    @Test
    public void testShortToByte() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Short(123), Short.class), LANG_FACTORY.createLiteral((Object)"byte", Byte.class)}, Byte.class);
        this.helpGetString1(func, "123");
    }

    @Test
    public void testIntegerToByte() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Integer(1232321), Integer.class), LANG_FACTORY.createLiteral((Object)"byte", Byte.class)}, Byte.class);
        this.helpGetString1(func, "cast(1232321 AS smallint)");
    }

    @Test
    public void testLongToByte() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Long(1231232341L), Long.class), LANG_FACTORY.createLiteral((Object)"byte", Byte.class)}, Byte.class);
        this.helpGetString1(func, "cast(1231232341 AS smallint)");
    }

    @Test
    public void testBigIntegerToByte() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new BigInteger("123"), BigInteger.class), LANG_FACTORY.createLiteral((Object)"byte", Byte.class)}, Byte.class);
        this.helpGetString1(func, "cast(123 AS smallint)");
    }

    @Test
    public void testFloatToByte() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Float(123.0f), Float.class), LANG_FACTORY.createLiteral((Object)"byte", Byte.class)}, Byte.class);
        this.helpGetString1(func, "cast(123.0 AS smallint)");
    }

    @Test
    public void testDoubleToByte() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Double(1.0), Double.class), LANG_FACTORY.createLiteral((Object)"byte", Byte.class)}, Byte.class);
        this.helpGetString1(func, "cast(1.0 AS smallint)");
    }

    @Test
    public void testBigDecimalToByte() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new BigDecimal("12.3"), BigDecimal.class), LANG_FACTORY.createLiteral((Object)"byte", Byte.class)}, Byte.class);
        this.helpGetString1(func, "cast(12.3 AS smallint)");
    }

    @Test
    public void testStringToShort() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"123", String.class), LANG_FACTORY.createLiteral((Object)"short", Short.class)}, Short.class);
        this.helpGetString1(func, "cast('123' AS smallint)");
    }

    @Test
    public void testBooleanToShorta() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), LANG_FACTORY.createLiteral((Object)"short", Short.class)}, Short.class);
        this.helpGetString1(func, "1");
    }

    @Test
    public void testByteToShort() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Byte(12), Byte.class), LANG_FACTORY.createLiteral((Object)"short", Short.class)}, Short.class);
        this.helpGetString1(func, "12");
    }

    @Test
    public void testIntegerToShort() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Integer(1232321), Integer.class), LANG_FACTORY.createLiteral((Object)"short", Short.class)}, Short.class);
        this.helpGetString1(func, "cast(1232321 AS smallint)");
    }

    @Test
    public void testLongToShort() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Long(1231232341L), Long.class), LANG_FACTORY.createLiteral((Object)"short", Short.class)}, Short.class);
        this.helpGetString1(func, "cast(1231232341 AS smallint)");
    }

    @Test
    public void testBigIntegerToShort() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new BigInteger("123"), BigInteger.class), LANG_FACTORY.createLiteral((Object)"short", Short.class)}, Short.class);
        this.helpGetString1(func, "cast(123 AS smallint)");
    }

    @Test
    public void testFloatToShort() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Float(123.0f), Float.class), LANG_FACTORY.createLiteral((Object)"short", Short.class)}, Short.class);
        this.helpGetString1(func, "cast(123.0 AS smallint)");
    }

    @Test
    public void testDoubleToShort() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Double(1.0), Double.class), LANG_FACTORY.createLiteral((Object)"short", Short.class)}, Short.class);
        this.helpGetString1(func, "cast(1.0 AS smallint)");
    }

    @Test
    public void testBigDecimalToShort() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new BigDecimal("12.3"), BigDecimal.class), LANG_FACTORY.createLiteral((Object)"short", Short.class)}, Short.class);
        this.helpGetString1(func, "cast(12.3 AS smallint)");
    }

    @Test
    public void testStringToInteger() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"12332", String.class), LANG_FACTORY.createLiteral((Object)"integer", Integer.class)}, Integer.class);
        this.helpGetString1(func, "cast('12332' AS int)");
    }

    @Test
    public void testBooleanToIntegera() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), LANG_FACTORY.createLiteral((Object)"integer", Integer.class)}, Integer.class);
        this.helpGetString1(func, "cast(1 AS int)");
    }

    @Test
    public void testBooleanToIntegerb() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), LANG_FACTORY.createLiteral((Object)"integer", Integer.class)}, Integer.class);
        this.helpGetString1(func, "cast(0 AS int)");
    }

    @Test
    public void testByteToInteger() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Byte(12), Byte.class), LANG_FACTORY.createLiteral((Object)"integer", Integer.class)}, Integer.class);
        this.helpGetString1(func, "cast(12 AS int)");
    }

    @Test
    public void testShortToInteger() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Short(1243), Short.class), LANG_FACTORY.createLiteral((Object)"integer", Integer.class)}, Integer.class);
        this.helpGetString1(func, "cast(1243 AS int)");
    }

    @Test
    public void testLongToInteger() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Long(1231232341L), Long.class), LANG_FACTORY.createLiteral((Object)"integer", Integer.class)}, Integer.class);
        this.helpGetString1(func, "cast(1231232341 AS int)");
    }

    @Test
    public void testBigIntegerToInteger() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new BigInteger("123"), BigInteger.class), LANG_FACTORY.createLiteral((Object)"integer", Integer.class)}, Integer.class);
        this.helpGetString1(func, "cast(123 AS int)");
    }

    @Test
    public void testFloatToInteger() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Float(123.0f), Float.class), LANG_FACTORY.createLiteral((Object)"integer", Integer.class)}, Integer.class);
        this.helpGetString1(func, "cast(123.0 AS int)");
    }

    @Test
    public void testDoubleToInteger() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new Double(1.0), Double.class), LANG_FACTORY.createLiteral((Object)"integer", Integer.class)}, Integer.class);
        this.helpGetString1(func, "cast(1.0 AS int)");
    }

    @Test
    public void testBigDecimalToInteger() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)new BigDecimal("12.3"), BigDecimal.class), LANG_FACTORY.createLiteral((Object)"integer", Integer.class)}, Integer.class);
        this.helpGetString1(func, "cast(12.3 AS int)");
    }

    @Test
    public void testStringToLong() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"12332131413", String.class), LANG_FACTORY.createLiteral((Object)"long", Long.class)}, Long.class);
        this.helpGetString1(func, "cast('12332131413' AS bigint)");
    }

    @Test
    public void testBooleanToLonga() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), LANG_FACTORY.createLiteral((Object)"long", Long.class)}, Long.class);
        this.helpGetString1(func, "cast(1 AS bigint)");
    }

    @Test
    public void testStringToBigInteger() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"12323143241414", String.class), LANG_FACTORY.createLiteral((Object)"biginteger", BigInteger.class)}, BigInteger.class);
        this.helpGetString1(func, "cast('12323143241414' AS numeric(38, 0))");
    }

    @Test
    public void testBooleanToBigIntegera() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), LANG_FACTORY.createLiteral((Object)"biginteger", BigInteger.class)}, BigInteger.class);
        this.helpGetString1(func, "cast(1 AS numeric(38, 0))");
    }

    @Test
    public void testStringToFloat() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"123", String.class), LANG_FACTORY.createLiteral((Object)"float", Float.class)}, Float.class);
        this.helpGetString1(func, "cast('123' AS real)");
    }

    @Test
    public void testBooleanToFloata() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), LANG_FACTORY.createLiteral((Object)"float", Float.class)}, Float.class);
        this.helpGetString1(func, "cast(1 AS real)");
    }

    @Test
    public void testBooleanToFloatb() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), LANG_FACTORY.createLiteral((Object)"float", Float.class)}, Float.class);
        this.helpGetString1(func, "cast(0 AS real)");
    }

    @Test
    public void testStringToDouble() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"123", String.class), LANG_FACTORY.createLiteral((Object)"double", Double.class)}, Double.class);
        this.helpGetString1(func, "cast('123' AS double)");
    }

    @Test
    public void testBooleanToDoublea() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), LANG_FACTORY.createLiteral((Object)"double", Double.class)}, Double.class);
        this.helpGetString1(func, "cast(1 AS double)");
    }

    @Test
    public void testBooleanToDoubleb() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), LANG_FACTORY.createLiteral((Object)"double", Double.class)}, Double.class);
        this.helpGetString1(func, "cast(0 AS double)");
    }

    @Test
    public void testStringToBigDecimal() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)"123", String.class), LANG_FACTORY.createLiteral((Object)"bigdecimal", BigDecimal.class)}, BigDecimal.class);
        this.helpGetString1(func, "cast('123' AS numeric(38, 19))");
    }

    @Test
    public void testBooleanToBigDecimala() throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", new Expression[]{LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), LANG_FACTORY.createLiteral((Object)"bigdecimal", BigDecimal.class)}, BigDecimal.class);
        this.helpGetString1(func, "cast(1 AS numeric(38, 19))");
    }

    @Test
    public void testCharToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Character('5'), Character.class), "string", "'5'");
    }

    @Test
    public void testBooleanToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "string", "CASE WHEN 1 = 0 THEN 'false' ELSE 'true' END");
    }

    @Test
    public void testBooleanToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "byte", "1");
    }

    @Test
    public void testBooleanToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "short", "1");
    }

    @Test
    public void testBooleanToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "integer", "cast(1 AS int)");
    }

    @Test
    public void testBooleanToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "long", "cast(1 AS bigint)");
    }

    @Test
    public void testBooleanToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "biginteger", "cast(1 AS numeric(38, 0))");
    }

    @Test
    public void testBooleanToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "float", "cast(1 AS real)");
    }

    @Test
    public void testBooleanToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "double", "cast(1 AS double)");
    }

    @Test
    public void testBooleanToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "bigdecimal", "cast(1 AS numeric(38, 19))");
    }

    @Test
    public void testByteToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testByteToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "long", "cast(1 AS bigint)");
    }

    @Test
    public void testByteToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "biginteger", "cast(1 AS numeric(38, 0))");
    }

    @Test
    public void testByteToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "float", "cast(1 AS real)");
    }

    @Test
    public void testByteToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "double", "cast(1 AS double)");
    }

    @Test
    public void testByteToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "bigdecimal", "cast(1 AS numeric(38, 19))");
    }

    @Test
    public void testShortToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testShortToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "long", "cast(1 AS bigint)");
    }

    @Test
    public void testShortToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "biginteger", "cast(1 AS numeric(38, 0))");
    }

    @Test
    public void testShortToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "float", "cast(1 AS real)");
    }

    @Test
    public void testShortToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "double", "cast(1 AS double)");
    }

    @Test
    public void testShortToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "bigdecimal", "cast(1 AS numeric(38, 19))");
    }

    @Test
    public void testIntegerToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testIntegerToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "long", "cast(1 AS bigint)");
    }

    @Test
    public void testIntegerToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "biginteger", "cast(1 AS numeric(38, 0))");
    }

    @Test
    public void testIntegerToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "float", "cast(1 AS real)");
    }

    @Test
    public void testIntegerToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "double", "cast(1 AS double)");
    }

    @Test
    public void testIntegerToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "bigdecimal", "cast(1 AS numeric(38, 19))");
    }

    @Test
    public void testLongToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testLongToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "biginteger", "cast(1 AS numeric(38, 0))");
    }

    @Test
    public void testLongToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "float", "cast(1 AS real)");
    }

    @Test
    public void testLongToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "double", "cast(1 AS double)");
    }

    @Test
    public void testLongToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "bigdecimal", "cast(1 AS numeric(38, 19))");
    }

    @Test
    public void testBigIntegerToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testBigIntegerToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "long", "cast(1 AS bigint)");
    }

    @Test
    public void testBigIntegerToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "float", "cast(1 AS real)");
    }

    @Test
    public void testBigIntegerToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "double", "cast(1 AS double)");
    }

    @Test
    public void testBigIntegerToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "bigdecimal", "cast(1 AS numeric(38, 19))");
    }

    @Test
    public void testFloatToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "string", "cast(1.2 AS varchar(4000))");
    }

    @Test
    public void testFloatToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "long", "cast(1.2 AS bigint)");
    }

    @Test
    public void testFloatToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "biginteger", "cast(1.2 AS numeric(38, 0))");
    }

    @Test
    public void testFloatToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "double", "cast(1.2 AS double)");
    }

    @Test
    public void testFloatToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "bigdecimal", "cast(1.2 AS numeric(38, 19))");
    }

    @Test
    public void testDoubleToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "string", "cast(1.2 AS varchar(4000))");
    }

    @Test
    public void testDoubleToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "long", "cast(1.2 AS bigint)");
    }

    @Test
    public void testDoubleToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "biginteger", "cast(1.2 AS numeric(38, 0))");
    }

    @Test
    public void testDoubleToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "float", "cast(1.2 AS real)");
    }

    @Test
    public void testDoubleToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "bigdecimal", "cast(1.2 AS numeric(38, 19))");
    }

    @Test
    public void testBigDecimalToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "long", "cast(1.0 AS bigint)");
    }

    @Test
    public void testBigDecimalToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "biginteger", "cast(1.0 AS numeric(38, 0))");
    }

    @Test
    public void testBigDecimalToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "float", "cast(1.0 AS real)");
    }

    @Test
    public void testBigDecimalToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "double", "cast(1.0 AS double)");
    }
}

