/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.sqlserver;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.teiid.core.util.StringUtil;
import org.teiid.language.AggregateFunction;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.OrderBy;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.SetQuery;
import org.teiid.language.WindowFunction;
import org.teiid.language.WindowSpecification;
import org.teiid.language.With;
import org.teiid.language.WithItem;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;
import org.teiid.translator.jdbc.TemplateFunctionModifier;
import org.teiid.translator.jdbc.sybase.SybaseExecutionFactory;
import org.teiid.util.Version;

@Translator(name="sqlserver", description="A translator for Microsoft SQL Server Database")
public class SQLServerExecutionFactory
extends SybaseExecutionFactory {
    public static final String V_2000 = "2000";
    public static final String V_2005 = "2005";
    public static final String V_2008 = "2008";
    public static final String V_2012 = "2012";
    public static final Version SEVEN_0 = Version.getVersion((String)"7.0");
    public static final Version NINE_0 = Version.getVersion((String)"9.0");
    public static final Version TEN_0 = Version.getVersion((String)"10.0");
    public static final Version ELEVEN_0 = Version.getVersion((String)"11.0");

    public SQLServerExecutionFactory() {
        this.setSupportsFullOuterJoins(true);
        this.setMaxInCriteriaSize(1000);
        this.setMaxDependentInPredicates(2);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("week", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("DATEPART(ISO_WEEK, ", function.getParameters().get(0), ")");
            }
        });
        this.registerFunctionModifier("locate", new AliasModifier("CHARINDEX"));
        this.registerFunctionModifier("md5", new TemplateFunctionModifier("HASHBYTES('MD5', ", 0, ")"));
        this.registerFunctionModifier("sha1", new TemplateFunctionModifier("HASHBYTES('SHA1', ", 0, ")"));
        this.registerFunctionModifier("sha2_256", new TemplateFunctionModifier("HASHBYTES('SHA2_256', ", 0, ")"));
        this.registerFunctionModifier("sha2_512", new TemplateFunctionModifier("HASHBYTES('SHA2_512', ", 0, ")"));
        this.registerFunctionModifier("ucase", new UpperLowerFunctionModifier("upper"));
        this.registerFunctionModifier("lcase", new UpperLowerFunctionModifier("lower"));
    }

    @Override
    public void initCapabilities(Connection connection) throws TranslatorException {
        super.initCapabilities(connection);
        if (this.getVersion().compareTo(TEN_0) >= 0) {
            this.convertModifier.addTypeMapping("date", 11);
            this.formatMap.put("yyyy-MM-dd", "DATE");
            this.convertModifier.addConvert(13, 11, new FunctionModifier(){

                @Override
                public List<?> translate(Function function) {
                    ArrayList<String> result = new ArrayList<String>();
                    result.add("cast(");
                    result.add((String)function.getParameters().get(0));
                    result.add(" AS DATE)");
                    return result;
                }
            });
            this.convertModifier.addTypeMapping("datetime2", 13);
            this.registerFunctionModifier("parsetimestamp", new SybaseExecutionFactory.SybaseFormatFunctionModifier("CONVERT(DATETIME2, ", this.formatMap));
        }
    }

    @Override
    protected void populateDateFormats() {
        this.formatMap.put("MM/dd/yy", 1);
        this.formatMap.put("yy.MM.dd", 2);
        this.formatMap.put("dd/MM/yy", 3);
        this.formatMap.put("dd.MM.yy", 4);
        this.formatMap.put("dd-MM-yy", 5);
        this.formatMap.put("dd MMM yy", 6);
        this.formatMap.put("MMM dd, yy", 7);
        this.formatMap.put("MM-dd-yy", 10);
        this.formatMap.put("yy/MM/dd", 11);
        this.formatMap.put("yyMMdd", 12);
        for (Map.Entry entry : new HashSet(this.formatMap.entrySet())) {
            this.formatMap.put(((String)entry.getKey()).replace("yy", "yyyy"), (Integer)entry.getValue() + 100);
        }
        this.formatMap.put("MMM d yyyy hh:mma", 100);
        this.formatMap.put("HH:mm:ss", 8);
        this.formatMap.put("MMM d yyyy hh:mm:ss:SSSa", 109);
        this.formatMap.put("dd MMM yyyy HH:mm:ss:SSS", 113);
        this.formatMap.put("kk:MM:ss:SSS", 14);
        this.formatMap.put("yyyy-MM-dd HH:mm:ss", 120);
        this.formatMap.put("yyyy-MM-dd HH:mm:ss.SSS", 121);
        this.formatMap.put("yyyy-MM-dd'T'HH:mm:ss.SSS", 126);
    }

    @Override
    protected List<Object> convertDateToString(Function function) {
        if (this.getVersion().compareTo(TEN_0) >= 0) {
            return Arrays.asList("convert(varchar, ", function.getParameters().get(0), ")");
        }
        return Arrays.asList("replace(convert(varchar, ", function.getParameters().get(0), ", 102), '.', '-')");
    }

    @Override
    protected List<?> convertTimestampToString(Function function) {
        return Arrays.asList("convert(varchar, ", function.getParameters().get(0), ", 21)");
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        block10: {
            WithItem withItem;
            block11: {
                AggregateFunction af;
                block14: {
                    block13: {
                        block12: {
                            block9: {
                                if (!(obj instanceof ColumnReference)) break block9;
                                ColumnReference elem = (ColumnReference)obj;
                                if (this.getVersion().compareTo(SEVEN_0) <= 0 && TypeFacility.RUNTIME_TYPES.STRING.equals(elem.getType()) && elem.getMetadataObject() != null && "uniqueidentifier".equalsIgnoreCase(elem.getMetadataObject().getNativeType())) {
                                    return Arrays.asList("cast(", elem, " as char(36))");
                                }
                                break block10;
                            }
                            if (!(obj instanceof AggregateFunction)) break block11;
                            af = (AggregateFunction)obj;
                            if (!af.getName().equals("STDDEV_POP")) break block12;
                            af.setName("STDDEVP");
                            break block10;
                        }
                        if (!af.getName().equals("STDDEV_SAMP")) break block13;
                        af.setName("STDDEV");
                        break block10;
                    }
                    if (!af.getName().equals("VAR_POP")) break block14;
                    af.setName("VARP");
                    break block10;
                }
                if (!af.getName().equals("VAR_SAMP")) break block10;
                af.setName("VAR");
                break block10;
            }
            if (obj instanceof WithItem && (withItem = (WithItem)obj).isRecusive()) {
                List derivedColumns = withItem.getSubquery().getProjectedQuery().getDerivedColumns();
                List derivedColumnsRecurse = ((SetQuery)withItem.getSubquery()).getRightQuery().getProjectedQuery().getDerivedColumns();
                for (int i = 0; i < derivedColumns.size(); ++i) {
                    Column c;
                    DerivedColumn dcR;
                    Column c2;
                    String nativeType = null;
                    boolean castLeft = true;
                    boolean castRight = true;
                    DerivedColumn dc = (DerivedColumn)derivedColumns.get(i);
                    if (dc.getExpression() instanceof ColumnReference && (c2 = ((ColumnReference)dc.getExpression()).getMetadataObject()) != null && c2.getNativeType() != null) {
                        nativeType = c2.getNativeType();
                        castLeft = false;
                    }
                    if ((dcR = (DerivedColumn)derivedColumnsRecurse.get(i)).getExpression() instanceof ColumnReference && (c = ((ColumnReference)dcR.getExpression()).getMetadataObject()) != null) {
                        if (nativeType == null) {
                            if (c.getNativeType() != null) {
                                nativeType = c.getNativeType();
                                castRight = false;
                            }
                        } else if (nativeType.equals(c.getNativeType())) continue;
                    }
                    if (castLeft) {
                        this.addCast(nativeType, dc);
                    }
                    if (!castRight) continue;
                    this.addCast(nativeType, dcR);
                }
            }
        }
        return super.translate(obj, context);
    }

    private void addCast(String nativeType, DerivedColumn dc) {
        if (nativeType != null) {
            Function cast = ConvertModifier.createConvertFunction(this.getLanguageFactory(), dc.getExpression(), nativeType);
            cast.setName("cast");
            dc.setExpression((Expression)cast);
        } else {
            dc.setExpression((Expression)ConvertModifier.createConvertFunction(this.getLanguageFactory(), dc.getExpression(), TypeFacility.getDataTypeName((Class)dc.getExpression().getType())));
        }
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getDefaultSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        if (this.getVersion().compareTo(TEN_0) >= 0) {
            supportedFunctions.add("coalesce");
        }
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("PI");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("ASCII");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("||");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("locate");
        supportedFunctions.add("LOWER");
        supportedFunctions.add("LPAD");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("REPEAT");
        supportedFunctions.add("REPLACE");
        supportedFunctions.add("RIGHT");
        supportedFunctions.add("RPAD");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SPACE");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("UPPER");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("TIMESTAMPADD");
        supportedFunctions.add("TIMESTAMPDIFF");
        supportedFunctions.add("WEEK");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        supportedFunctions.add("formattimestamp");
        supportedFunctions.add("parsetimestamp");
        if (this.getVersion().compareTo(TEN_0) >= 0) {
            supportedFunctions.add("sha2_256");
            supportedFunctions.add("sha2_512");
        }
        if (this.getVersion().compareTo(NINE_0) >= 0) {
            supportedFunctions.add("md5");
            supportedFunctions.add("sha1");
        }
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    @Override
    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    @Override
    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return this.getVersion().compareTo(TEN_0) >= 0;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    @Override
    public int getMaxFromGroups() {
        return -1;
    }

    @Override
    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean booleanNullable() {
        return true;
    }

    @Override
    public void setDatabaseVersion(String version) {
        if (version != null) {
            if (version.equals(V_2000)) {
                this.setDatabaseVersion(SEVEN_0);
                return;
            }
            if (version.equals(V_2005)) {
                this.setDatabaseVersion(NINE_0);
                return;
            }
            if (version.equals(V_2008)) {
                this.setDatabaseVersion(TEN_0);
                return;
            }
            if (version.equals(V_2012)) {
                this.setDatabaseVersion(ELEVEN_0);
                return;
            }
        }
        super.setDatabaseVersion(version);
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        if (this.getVersion().compareTo(TEN_0) >= 0) {
            return super.translateLiteralDate(dateValue);
        }
        return super.translateLiteralTimestamp(new Timestamp(dateValue.getTime()));
    }

    @Override
    public boolean hasTimeType() {
        return this.getVersion().compareTo(TEN_0) >= 0;
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "cast('" + this.formatDateValue(timeValue) + "' as time)";
    }

    public boolean supportsCommonTableExpressions() {
        return true;
    }

    public boolean supportsSubqueryCommonTableExpressions() {
        return false;
    }

    public boolean supportsRecursiveCommonTableExpressions() {
        return this.getVersion().compareTo(TEN_0) >= 0;
    }

    @Override
    protected boolean supportsCrossJoin() {
        return true;
    }

    public boolean supportsElementaryOlapOperations() {
        return true;
    }

    public boolean supportsWindowDistinctAggregates() {
        return false;
    }

    public boolean supportsWindowOrderByWithAggregates() {
        return false;
    }

    @Override
    public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
        if (format == ExecutionFactory.Format.NUMBER) {
            return false;
        }
        return this.formatMap.containsKey(literal);
    }

    @Override
    public boolean supportsOnlyFormatLiterals() {
        return true;
    }

    @Override
    protected boolean setFetchSize() {
        return true;
    }

    @Override
    @Deprecated
    protected JDBCMetadataProcessor createMetadataProcessor() {
        return (JDBCMetadataProcessor)this.getMetadataProcessor();
    }

    @Override
    public MetadataProcessor<Connection> getMetadataProcessor() {
        return new JDBCMetadataProcessor(){

            @Override
            protected Column addColumn(ResultSet columns, Table table, MetadataFactory metadataFactory, int rsColumns) throws SQLException {
                Column c = super.addColumn(columns, table, metadataFactory, rsColumns);
                if (!c.isAutoIncremented() && c.getNativeType() != null && StringUtil.endsWithIgnoreCase((String)c.getNativeType(), (String)" identity")) {
                    c.setAutoIncremented(true);
                }
                return c;
            }

            @Override
            protected ResultSet executeSequenceQuery(Connection conn) throws SQLException {
                if (SQLServerExecutionFactory.this.getVersion().compareTo(ELEVEN_0) < 0) {
                    return null;
                }
                String query = "select db_name() as sequence_catalog, SCHEMA_NAME(schema_id) as sequence_schema, name as sequence_name from sys.sequenceswhere db_name() like ? and SCHEMA_NAME(schema_id) like ? and name like ?";
                PreparedStatement ps = conn.prepareStatement(query);
                ps.setString(1, this.getCatalog() == null ? "%" : this.getCatalog());
                ps.setString(2, this.getSchemaPattern() == null ? "%" : this.getSchemaPattern());
                ps.setString(3, this.getSequenceNamePattern() == null ? "%" : this.getSequenceNamePattern());
                return ps.executeQuery();
            }
        };
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }

    @Override
    public boolean useStreamsForLobs() {
        return true;
    }

    @Override
    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public String getHibernateDialectClassName() {
        if (this.getVersion().compareTo(NINE_0) >= 0) {
            if (this.getVersion().compareTo(TEN_0) >= 0) {
                return "org.hibernate.dialect.SQLServer2008Dialect";
            }
            return "org.hibernate.dialect.SQLServer2005Dialect";
        }
        return "org.hibernate.dialect.SQLServerDialect";
    }

    @Override
    public boolean supportsGroupByRollup() {
        return this.getVersion().compareTo(NINE_0) >= 0;
    }

    @Override
    public boolean useWithRollup() {
        return this.getVersion().compareTo(TEN_0) < 0;
    }

    public boolean supportsConvert(int fromType, int toType) {
        if (fromType == 14 && this.convertModifier.hasTypeMapping(toType)) {
            return true;
        }
        return super.supportsConvert(fromType, toType);
    }

    @Override
    public boolean supportsLiteralOnlyWithGrouping() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<?> translateCommand(Command command, ExecutionContext context) {
        Select select;
        QueryExpression queryCommand;
        QueryExpression qe;
        Insert insert;
        if (command instanceof Insert && (insert = (Insert)command).getValueSource() instanceof QueryExpression && (qe = (QueryExpression)insert.getValueSource()).getWith() != null) {
            With with = qe.getWith();
            qe.setWith(null);
            return Arrays.asList(with, insert);
        }
        boolean useRowNumber = false;
        if (this.getVersion().compareTo(ELEVEN_0) >= 0 || !(command instanceof QueryExpression)) {
            if (this.getVersion().compareTo(ELEVEN_0) >= 0 && command instanceof QueryExpression && (queryCommand = (QueryExpression)command).getLimit() != null) {
                if (queryCommand.getOrderBy() != null) {
                    ArrayList<Object> parts = new ArrayList<Object>();
                    Limit limit = queryCommand.getLimit();
                    queryCommand.setLimit(null);
                    parts.add(queryCommand);
                    parts.add(" ");
                    parts.add(limit);
                    return parts;
                }
                if (queryCommand instanceof Select && ((Select)queryCommand).isDistinct() || queryCommand instanceof SetQuery && !((SetQuery)queryCommand).isAll()) {
                    useRowNumber = true;
                } else {
                    ArrayList<Object> parts = new ArrayList<Object>();
                    Limit limit = queryCommand.getLimit();
                    queryCommand.setLimit(null);
                    parts.add(queryCommand);
                    parts.add(" ORDER BY @@version ");
                    parts.add(limit);
                    return parts;
                }
            }
            if (!useRowNumber) {
                return super.translateCommand(command, context);
            }
        }
        queryCommand = (QueryExpression)command;
        if (!(useRowNumber || queryCommand.getLimit() != null && queryCommand.getLimit().getRowOffset() != 0)) {
            return super.translateCommand(command, context);
        }
        Limit limit = queryCommand.getLimit();
        queryCommand.setLimit(null);
        ArrayList<Object> parts = new ArrayList<Object>();
        if (queryCommand.getWith() != null) {
            With with = queryCommand.getWith();
            queryCommand.setWith(null);
            parts.add(with);
        }
        OrderBy orderBy = queryCommand.getOrderBy();
        queryCommand.setOrderBy(null);
        parts.add("SELECT ");
        boolean allAliased = true;
        for (DerivedColumn selectSymbol : queryCommand.getProjectedQuery().getDerivedColumns()) {
            if (selectSymbol.getAlias() != null) continue;
            allAliased = false;
            break;
        }
        if (allAliased) {
            String[] columnNames = queryCommand.getColumnNames();
            for (int i = 0; i < columnNames.length; ++i) {
                if (i > 0) {
                    parts.add(", ");
                }
                parts.add(columnNames[i]);
            }
        } else {
            parts.add("*");
        }
        boolean addedToSelect = false;
        if (orderBy != null && queryCommand instanceof Select && !(select = (Select)queryCommand).isDistinct() && select.getGroupBy() == null) {
            WindowFunction expression = new WindowFunction();
            expression.setFunction(new AggregateFunction("ROW_NUMBER", false, Collections.EMPTY_LIST, TypeFacility.RUNTIME_TYPES.INTEGER));
            WindowSpecification windowSpecification = new WindowSpecification();
            windowSpecification.setOrderBy(orderBy);
            expression.setWindowSpecification(windowSpecification);
            select.getDerivedColumns().add(new DerivedColumn("ROWNUM_", (Expression)expression));
            parts.add(" FROM (");
            parts.add(select);
            addedToSelect = true;
        }
        if (!addedToSelect) {
            parts.add(" FROM (SELECT v.*, ROW_NUMBER() OVER (");
            if (orderBy != null) {
                parts.add(orderBy);
            } else {
                parts.add("ORDER BY @@version");
            }
            parts.add(") ROWNUM_ FROM (");
            parts.add(queryCommand);
            parts.add(") v");
        }
        parts.add(") v WHERE ROWNUM_ ");
        if (limit.getRowLimit() != Integer.MAX_VALUE) {
            parts.add("<= ");
            parts.add((long)limit.getRowLimit() + (long)limit.getRowOffset());
            parts.add(" AND ROWNUM_ ");
        }
        parts.add("> ");
        parts.add(limit.getRowOffset());
        if (orderBy != null) {
            parts.add(" ORDER BY ROWNUM_");
        }
        return parts;
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        if (this.getVersion().compareTo(ELEVEN_0) >= 0) {
            return Arrays.asList("OFFSET ", limit.getRowOffset(), " ROWS FETCH NEXT ", limit.getRowLimit(), " ROWS ONLY");
        }
        return super.translateLimit(limit, context);
    }

    @Override
    public boolean useSelectLimit() {
        return this.getVersion().compareTo(ELEVEN_0) < 0;
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        if (this.getVersion().compareTo(TEN_0) < 0) {
            return super.translateLiteralTimestamp(timestampValue);
        }
        return "{ts '" + this.formatDateValue(timestampValue) + "'}";
    }

    private final class UpperLowerFunctionModifier
    extends AliasModifier {
        private UpperLowerFunctionModifier(String alias) {
            super(alias);
        }

        @Override
        public List<?> translate(Function function) {
            ColumnReference cr;
            String nativeType;
            if (function.getParameters().get(0) instanceof ColumnReference && (nativeType = (cr = (ColumnReference)function.getParameters().get(0)).getMetadataObject().getNativeType()) != null && StringUtil.indexOfIgnoreCase((String)nativeType, (String)"char") == -1) {
                Function cast = ConvertModifier.createConvertFunction(SQLServerExecutionFactory.this.getLanguageFactory(), (Expression)cr, (StringUtil.startsWithIgnoreCase((String)nativeType.trim(), (String)"n") ? "n" : "") + "varchar(max)");
                cast.setName("cast");
                function.getParameters().set(0, cast);
            }
            return super.translate(function);
        }
    }
}

