/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.dqp.internal.datamgr.ExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.TestDeleteImpl;
import org.teiid.dqp.internal.datamgr.TestInsertImpl;
import org.teiid.dqp.internal.datamgr.TestProcedureImpl;
import org.teiid.dqp.internal.datamgr.TestQueryImpl;
import org.teiid.dqp.internal.datamgr.TestUpdateImpl;
import org.teiid.language.LanguageObject;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCQueryExecution;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.TranslatedCommand;
import org.teiid.translator.jdbc.TranslationHelper;

public class TestSQLConversionVisitor {
    public static final ExecutionContextImpl context = new ExecutionContextImpl("VDB", (Object)1, (Serializable)((Object)"Payload"), "ConnectionID", "Connector", 1L, "PartID", "ExecCount");
    private static JDBCExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void oneTimeSetup() throws TranslatorException {
        TRANSLATOR = new JDBCExecutionFactory();
        TRANSLATOR.setTrimStrings(true);
        TRANSLATOR.setUseBindVariables(false);
        TRANSLATOR.start();
    }

    public String getTestVDB() {
        return "/PartsSupplier.vdb";
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput) {
        this.helpTestVisitor(vdb, input, expectedOutput, false);
    }

    public TranslatedCommand helpTestVisitor(String vdb, String input, String expectedOutput, boolean usePreparedStatement) {
        JDBCExecutionFactory trans = new JDBCExecutionFactory();
        trans.setUseBindVariables(usePreparedStatement);
        try {
            trans.start();
            return TranslationHelper.helpTestVisitor(vdb, input, expectedOutput, trans);
        }
        catch (TranslatorException e) {
            throw new RuntimeException(e);
        }
    }

    private String getStringWithContext(LanguageObject obj) throws TranslatorException {
        return this.getStringWithContext(obj, null);
    }

    private String getStringWithContext(LanguageObject obj, String comment) throws TranslatorException {
        JDBCExecutionFactory env = new JDBCExecutionFactory();
        env.setUseCommentsInSourceQuery(true);
        env.setUseBindVariables(false);
        if (comment != null) {
            env.setCommentFormat(comment);
        }
        env.start();
        SQLConversionVisitor visitor = env.getSQLConversionVisitor();
        visitor.setExecutionContext((ExecutionContext)context);
        visitor.append(obj);
        return visitor.toString();
    }

    @Test
    public void testSimple() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts", "SELECT PARTS.PART_NAME FROM PARTS");
    }

    @Test
    public void testAliasInSelect() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name as x from parts", "SELECT PARTS.PART_NAME AS x FROM PARTS");
    }

    @Test
    public void testAliasedGroup() {
        this.helpTestVisitor(this.getTestVDB(), "select y.part_name from parts y", "SELECT y.PART_NAME FROM PARTS AS y");
    }

    @Test
    public void testAliasedGroupAndElement() {
        this.helpTestVisitor(this.getTestVDB(), "select y.part_name AS z from parts y", "SELECT y.PART_NAME AS z FROM PARTS AS y");
    }

    @Test
    public void testLiteralString() {
        this.helpTestVisitor(this.getTestVDB(), "select 'x' from parts", "SELECT 'x' FROM PARTS");
    }

    @Test
    public void testLiteralInteger() {
        this.helpTestVisitor(this.getTestVDB(), "select 5 from parts", "SELECT 5 FROM PARTS");
    }

    @Test
    public void testLiteralFloat() {
        this.helpTestVisitor(this.getTestVDB(), "select 5.2 from parts", "SELECT 5.2 FROM PARTS");
    }

    @Test
    public void testLiteralLowFloat() {
        this.helpTestVisitor(this.getTestVDB(), "select 0.012 from parts", "SELECT 0.012 FROM PARTS");
    }

    @Test
    public void testLiteralLowFloat2() {
        this.helpTestVisitor(this.getTestVDB(), "select 0.00012 from parts", "SELECT 0.00012 FROM PARTS");
    }

    @Test
    public void testLiteralHighFloat() {
        this.helpTestVisitor(this.getTestVDB(), "select 12345.123 from parts", "SELECT 12345.123 FROM PARTS");
    }

    @Test
    public void testLiteralHighFloat2() {
        this.helpTestVisitor(this.getTestVDB(), "select 1234567890.1234567 from parts", "SELECT 1234567890.1234567 FROM PARTS");
    }

    @Test
    public void testLiteralBoolean() {
        this.helpTestVisitor(this.getTestVDB(), "select {b'true'}, {b'false'} from parts", "SELECT 1, 0 FROM PARTS");
    }

    @Test
    public void testLiteralDate() {
        this.helpTestVisitor(this.getTestVDB(), "select {d '2003-12-31'} from parts", "SELECT {d '2003-12-31'} FROM PARTS");
    }

    @Test
    public void testLiteralTime() {
        this.helpTestVisitor(this.getTestVDB(), "select {t '23:59:59'} from parts", "SELECT {t '23:59:59'} FROM PARTS");
    }

    @Test
    public void testLiteralNull() {
        this.helpTestVisitor(this.getTestVDB(), "select null from parts", "SELECT NULL FROM PARTS");
    }

    @Test
    public void testLiteralTimestamp() {
        this.helpTestVisitor(this.getTestVDB(), "select {ts '2003-12-31 23:59:59.123'} from parts", "SELECT {ts '2003-12-31 23:59:59.123'} FROM PARTS");
    }

    @Test
    public void testSQL89Join() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p, supplier_parts s where p.part_id = s.part_id", "SELECT p.PART_NAME FROM PARTS AS p, SUPPLIER_PARTS AS s WHERE p.PART_ID = s.PART_ID");
    }

    @Test
    public void testSQL92Join() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p join supplier_parts s on p.part_id = s.part_id", "SELECT p.PART_NAME FROM PARTS AS p INNER JOIN SUPPLIER_PARTS AS s ON p.PART_ID = s.PART_ID");
    }

    @Test
    public void testSelfJoin() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p join parts p2 on p.part_id = p2.part_id", "SELECT p.PART_NAME FROM PARTS AS p INNER JOIN PARTS AS p2 ON p.PART_ID = p2.PART_ID");
    }

    @Test
    public void testRightOuterJoin() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p right join supplier_parts s on p.part_id = s.part_id", "SELECT p.PART_NAME FROM SUPPLIER_PARTS AS s LEFT OUTER JOIN PARTS AS p ON p.PART_ID = s.PART_ID");
    }

    @Test
    public void testLeftOuterJoin() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p left join supplier_parts s on p.part_id = s.part_id", "SELECT p.PART_NAME FROM PARTS AS p LEFT OUTER JOIN SUPPLIER_PARTS AS s ON p.PART_ID = s.PART_ID");
    }

    @Test
    public void testFullOuterJoin() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p full join supplier_parts s on p.part_id = s.part_id", "SELECT p.PART_NAME FROM PARTS AS p FULL OUTER JOIN SUPPLIER_PARTS AS s ON p.PART_ID = s.PART_ID");
    }

    @Test
    public void testCompare1() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id = 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID = 'x'");
    }

    @Test
    public void testCompare2() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id <> 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID <> 'x'");
    }

    @Test
    public void testCompare3() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id < 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID < 'x'");
    }

    @Test
    public void testCompare4() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id <= 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID <= 'x'");
    }

    @Test
    public void testCompare5() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id > 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID > 'x'");
    }

    @Test
    public void testCompare6() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id >= 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID >= 'x'");
    }

    @Test
    public void testIn1() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id in ('x')", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID = 'x'");
    }

    @Test
    public void testIn2() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id in ('x', 'y')", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID IN ('x', 'y')");
    }

    @Test
    public void testIn3() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id not in ('x', 'y')", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID NOT IN ('x', 'y')");
    }

    @Test
    public void testIsNull1() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id is null", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID IS NULL");
    }

    @Test
    public void testIsNull2() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id is not null", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID IS NOT NULL");
    }

    @Test
    public void testInsertNull() {
        this.helpTestVisitor(this.getTestVDB(), "insert into parts (part_id, part_name, part_color, part_weight) values ('a', null, 'c', 'd')", "INSERT INTO PARTS (PART_ID, PART_NAME, PART_COLOR, PART_WEIGHT) VALUES ('a', NULL, 'c', 'd')");
    }

    @Test
    public void testUpdateNull() {
        this.helpTestVisitor(this.getTestVDB(), "update parts set part_weight = null where part_color = 'b'", "UPDATE PARTS SET PART_WEIGHT = NULL WHERE PARTS.PART_COLOR = 'b'");
    }

    @Test
    public void testUpdateWhereNull() {
        this.helpTestVisitor(this.getTestVDB(), "update parts set part_weight = 'a' where part_weight = null", "UPDATE PARTS SET PART_WEIGHT = 'a' WHERE NULL <> NULL");
    }

    @Test
    public void testPreparedStatementCreationWithUpdate() {
        this.helpTestVisitor(this.getTestVDB(), "update parts set part_weight = 'a' || 'b' where part_weight < 50/10", "UPDATE PARTS SET PART_WEIGHT = ? WHERE PARTS.PART_WEIGHT < ?", true);
    }

    @Test
    public void testPreparedStatementCreationWithInsert() {
        this.helpTestVisitor(this.getTestVDB(), "insert into parts (part_weight) values (50/10)", "INSERT INTO PARTS (PART_WEIGHT) VALUES (?)", true);
    }

    @Test
    public void testPreparedStatementCreationWithSelect() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id not in ('x' || 'a', 'y' || 'b') and part_weight < '6'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID NOT IN (?, ?) AND PARTS.PART_WEIGHT < '6'", true);
    }

    @Test
    public void testPreparedStatementCreationWithLike() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_name like '%foo' || '_'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_NAME LIKE ?", true);
    }

    public void defer_testPreparedStatementCreationWithLeftConstant() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where 'x' = 'y'", "SELECT PARTS.PART_NAME FROM PARTS WHERE 1 = ?", true);
    }

    @Test
    public void testPreparedStatementCreationWithFunction() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where concat(part_name, 'x') = concat('y', part_weight)", "SELECT PARTS.PART_NAME FROM PARTS WHERE concat(PARTS.PART_NAME, 'x') = concat('y', PARTS.PART_WEIGHT)", true);
    }

    @Test
    public void testPreparedStatementCreationWithCase() {
        this.helpTestVisitor(this.getTestVDB(), "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_WEIGHT = CASE WHEN PARTS.PART_NAME='a' || 'b' THEN 'b' ELSE 'c' END", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_WEIGHT = CASE WHEN PARTS.PART_NAME = ? THEN 'b' ELSE 'c' END", true);
    }

    @Test
    public void testVisitIDeleteWithComment() throws Exception {
        String expected = "DELETE /*teiid sessionid:ConnectionID, requestid:ConnectionID.1.PartID*/ FROM g1 WHERE 100 >= 200 AND 500 < 600";
        Assert.assertEquals((Object)expected, (Object)this.getStringWithContext((LanguageObject)TestDeleteImpl.example()));
    }

    @Test
    public void testVisitIInsertWithComment() throws Exception {
        String expected = "INSERT /*teiid sessionid:ConnectionID, requestid:ConnectionID.1.PartID*/ INTO g1 (e1, e2, e3, e4) VALUES (1, 2, 3, 4)";
        Assert.assertEquals((Object)expected, (Object)this.getStringWithContext((LanguageObject)TestInsertImpl.example((String)"g1")));
    }

    @Test
    public void testVisitISelectWithComment() throws Exception {
        String expected = "SELECT /*teiid sessionid:ConnectionID, requestid:ConnectionID.1.PartID*/ g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC";
        Assert.assertEquals((Object)expected, (Object)this.getStringWithContext((LanguageObject)TestQueryImpl.example((boolean)false)));
        expected = "SELECT /*teiid sessionid:ConnectionID, requestid:ConnectionID.1.PartID*/ DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC";
        Assert.assertEquals((Object)expected, (Object)this.getStringWithContext((LanguageObject)TestQueryImpl.example((boolean)true)));
    }

    @Test
    public void testVisitSelectWithCustomComment() throws Exception {
        String expected = "SELECT /* foo ConnectionID ConnectionID.1 PartID ExecCount null VDB 1 false */g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC";
        Assert.assertEquals((Object)expected, (Object)this.getStringWithContext((LanguageObject)TestQueryImpl.example((boolean)false), "/* foo {0} {1} {2} {3} {4} {5} {6} {7} */"));
    }

    @Test
    public void testVisitIUpdateWithComment() throws Exception {
        String expected = "UPDATE /*teiid sessionid:ConnectionID, requestid:ConnectionID.1.PartID*/ g1 SET e1 = 1, e2 = 1, e3 = 1, e4 = 1 WHERE 1 = 1";
        Assert.assertEquals((Object)expected, (Object)this.getStringWithContext((LanguageObject)TestUpdateImpl.example()));
    }

    @Test
    public void testVisitIProcedureWithComment() throws Exception {
        String expected = "/*teiid sessionid:ConnectionID, requestid:ConnectionID.1.PartID*/ {call sq3(?,?)}";
        Assert.assertEquals((Object)expected, (Object)this.getStringWithContext((LanguageObject)TestProcedureImpl.example()));
    }

    @Test
    public void testTrimStrings() throws Exception {
        TranslationHelper.helpTestVisitor("/bqt.vdb", "select stringkey from bqt1.smalla", "SELECT rtrim(SmallA.StringKey) FROM SmallA", TRANSLATOR);
    }

    @Test
    public void testNestedSetQuery() throws Exception {
        String input = "select part_id id FROM parts UNION ALL (select part_name FROM parts UNION select part_id FROM parts)";
        String output = "SELECT rtrim(PARTS.PART_ID) AS id FROM PARTS UNION ALL (SELECT PARTS.PART_NAME FROM PARTS UNION SELECT rtrim(PARTS.PART_ID) FROM PARTS)";
        TranslationHelper.helpTestVisitor("/PartsSupplier.vdb", input, output, TRANSLATOR);
    }

    @Test
    public void testNestedSetQuery1() throws Exception {
        String input = "select part_id id FROM parts UNION (select part_name FROM parts EXCEPT select part_id FROM parts)";
        String output = "SELECT rtrim(PARTS.PART_ID) AS id FROM PARTS UNION (SELECT PARTS.PART_NAME FROM PARTS EXCEPT SELECT rtrim(PARTS.PART_ID) FROM PARTS)";
        TranslationHelper.helpTestVisitor("/PartsSupplier.vdb", input, output, TRANSLATOR);
    }

    @Test
    public void testNestedSetQuery2() throws Exception {
        String input = "select part_id id FROM parts UNION select part_name FROM parts EXCEPT select part_id FROM parts";
        String output = "SELECT rtrim(PARTS.PART_ID) AS id FROM PARTS UNION SELECT PARTS.PART_NAME FROM PARTS EXCEPT SELECT rtrim(PARTS.PART_ID) FROM PARTS";
        TranslationHelper.helpTestVisitor("/PartsSupplier.vdb", input, output, TRANSLATOR);
    }

    @Test
    public void testNestedSetQuery3() throws Exception {
        String input = "select part_id id FROM parts UNION (select part_name FROM parts Union ALL select part_id FROM parts)";
        String output = "SELECT rtrim(PARTS.PART_ID) AS id FROM PARTS UNION SELECT PARTS.PART_NAME FROM PARTS UNION SELECT rtrim(PARTS.PART_ID) FROM PARTS";
        TranslationHelper.helpTestVisitor("/PartsSupplier.vdb", input, output, TRANSLATOR);
    }

    @Test
    public void testUpdateTrimStrings() throws Exception {
        String input = "UPDATE PARTS SET PART_ID = NULL WHERE PARTS.PART_COLOR = 'b'";
        String output = "UPDATE PARTS SET PART_ID = NULL WHERE PARTS.PART_COLOR = 'b'";
        TranslationHelper.helpTestVisitor("/PartsSupplier.vdb", input, output, TRANSLATOR);
        input = "insert into parts (part_id) values ('a')";
        output = "INSERT INTO PARTS (PART_ID) VALUES ('a')";
        TranslationHelper.helpTestVisitor("/PartsSupplier.vdb", input, output, TRANSLATOR);
    }

    @Test
    public void testOrderByUnrelated() throws Exception {
        String input = "select part_id id FROM parts order by part_name";
        String output = "SELECT rtrim(PARTS.PART_ID) AS id FROM PARTS ORDER BY PARTS.PART_NAME";
        TranslationHelper.helpTestVisitor("/PartsSupplier.vdb", input, output, TRANSLATOR);
    }

    @Test
    public void testVarbinary() throws Exception {
        String input = "select X'AB' FROM parts";
        String output = "SELECT X'AB' FROM PARTS";
        TranslationHelper.helpTestVisitor("/PartsSupplier.vdb", input, output, TRANSLATOR);
    }

    @Test
    public void testConcat2() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where concat2(part_name, 'x') = concat2(part_weight, part_id)", "SELECT PARTS.PART_NAME FROM PARTS WHERE concat(ifnull(PARTS.PART_NAME, ''), 'x') = CASE WHEN PARTS.PART_WEIGHT IS NULL AND PARTS.PART_ID IS NULL THEN NULL ELSE concat(ifnull(PARTS.PART_WEIGHT, ''), ifnull(PARTS.PART_ID, '')) END", true);
    }

    @Test
    public void testSelectWithoutFrom() {
        this.helpTestVisitor(this.getTestVDB(), "select 1", "SELECT 1", true);
    }

    @Test
    public void testFunctionNativeQuery() throws SQLException {
        String ddl = "create foreign table t (x integer, y integer); create foreign function bsl (arg1 integer, arg2 integer) returns integer OPTIONS (\"teiid_rel:native-query\" '$1 << $2');";
        this.helpTestVisitor(ddl, "select bsl(x, y) from t", "SELECT t.x << t.y FROM t", true);
        this.helpTestVisitor(ddl, "select bsl(x, y) from t where x = 1 + 1", "SELECT t.x << t.y FROM t WHERE t.x = ?", true);
        TranslatedCommand tc = this.helpTestVisitor(ddl, "select bsl(1, y) from t where x = y", "SELECT ? << t.y FROM t WHERE t.x = t.y", true);
        JDBCQueryExecution qe = new JDBCQueryExecution(null, null, (ExecutionContext)Mockito.mock(ExecutionContext.class), TRANSLATOR);
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        qe.bind(ps, tc.getPreparedValues(), null);
        ((PreparedStatement)Mockito.verify((Object)ps, (VerificationMode)Mockito.times((int)1))).setObject(1, (Object)1, 4);
    }

    @Test
    public void testGroupByRollup() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name, max(part_weight) from parts group by rollup(part_name)", "SELECT PARTS.PART_NAME, MAX(PARTS.PART_WEIGHT) FROM PARTS GROUP BY ROLLUP(PARTS.PART_NAME)", true);
    }

    @Test
    public void testDoubleFormat() {
        this.helpTestVisitor(this.getTestVDB(), "select 1.0e10, -1.0e2", "SELECT 10000000000.0, -100.0", true);
    }

    @Test
    public void testDecimalFormat() {
        this.helpTestVisitor(this.getTestVDB(), "select 100000000000.0, -.0000001", "SELECT 100000000000.0, -0.0000001", true);
    }

    @Test
    public void testProcedureTable() {
        this.helpTestVisitor("create foreign table smallb (intkey integer, stringkey string); create foreign procedure spTest5 (param integer) returns table(stringkey string options (nameinsource 'other'), intkey integer)", "select smallb.intkey, x.stringkey, x.intkey from smallb left outer join lateral (exec spTest5(smallb.intkey)) as x on (true)", "SELECT smallb.intkey, x.other, x.intkey FROM smallb LEFT OUTER JOIN LATERAL (EXEC spTest5(smallb.intkey)) AS x ON 1 = 1", true);
    }

    @Test
    public void testSTInsert() throws Exception {
        String input = "insert into cola_markets(name,shape) values('foo124', ST_GeomFromText('POINT (300 100)', 8307))";
        String output = "INSERT INTO COLA_MARKETS (NAME, SHAPE) VALUES ('foo124', st_geomfromwkb(?, 8307))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, TRANSLATOR);
    }

    static {
        context.setSession((Session)new SessionMetadata());
    }
}

