/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.sap;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.EscapeSyntaxModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.TemplateFunctionModifier;
import org.teiid.translator.jdbc.hsql.AddDiffModifier;
import org.teiid.translator.jdbc.oracle.ConcatFunctionModifier;
import org.teiid.translator.jdbc.sybase.BaseSybaseExecutionFactory;
import org.teiid.util.Version;

@Translator(name="sap-iq", description="A translator for hte Sybase/SAP IQ and Database")
public class SAPIQExecutionFactory
extends BaseSybaseExecutionFactory {
    public static final Version FIFTEEN_4 = Version.getVersion((String)"15.4");
    protected Map<String, Integer> formatMap = new HashMap<String, Integer>();
    private Boolean jConnectDriver;

    public SAPIQExecutionFactory() {
        this.setSupportsFullOuterJoins(false);
        this.setMaxInCriteriaSize(250);
        this.setMaxDependentInPredicates(7);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("concat", new ConcatFunctionModifier(this.getLanguageFactory()){

            @Override
            public List<?> translate(Function function) {
                function.setName("||");
                return super.translate(function);
            }
        });
        this.registerFunctionModifier("concat2", new AliasModifier("STRING"));
        this.registerFunctionModifier("dayofweek", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayofyear", new TemplateFunctionModifier("DATEPART(dy,", 0, ")"));
        this.registerFunctionModifier("dayofmonth", new EscapeSyntaxModifier());
        this.registerFunctionModifier("week", new EscapeSyntaxModifier());
        this.registerFunctionModifier("timestampadd", new AddDiffModifier(true, this.getLanguageFactory()).supportsQuarter(true));
        this.registerFunctionModifier("timestampdiff", new AddDiffModifier(false, this.getLanguageFactory()).supportsQuarter(true));
        this.registerFunctionModifier("ifnull", new AliasModifier("coalesce"));
        this.registerFunctionModifier("locate", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                List params = function.getParameters();
                Expression param1 = (Expression)params.get(0);
                Expression param2 = params.set(1, param1);
                params.set(0, param2);
                return null;
            }
        });
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.setBooleanNullable(this.booleanNullable());
        convertModifier.addNumericBooleanConversions();
        convertModifier.addTypeMapping("smallint", 3, 4);
        convertModifier.addTypeMapping("bigint", 6);
        convertModifier.addTypeMapping("int", 5);
        convertModifier.addTypeMapping("double", 9);
        convertModifier.addTypeMapping("real", 8);
        convertModifier.addTypeMapping("numeric(38, 0)", 7);
        convertModifier.addTypeMapping("numeric(38, 19)", 10);
        convertModifier.addTypeMapping("char(1)", 1);
        convertModifier.addTypeMapping("varchar(4000)", 0);
        convertModifier.addTypeMapping("varbinary", 19);
        convertModifier.addTypeMapping("date", 11);
        convertModifier.addTypeMapping("time", 12);
        convertModifier.addTypeMapping("timestamp", 13);
        convertModifier.addConvert(12, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return SAPIQExecutionFactory.this.convertTimeToString(function);
            }
        });
        convertModifier.addConvert(11, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return SAPIQExecutionFactory.this.convertDateToString(function);
            }
        });
        convertModifier.addConvert(13, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return SAPIQExecutionFactory.this.convertTimestampToString(function);
            }
        });
        this.registerFunctionModifier("convert", convertModifier);
    }

    private List<Object> convertTimeToString(Function function) {
        return Arrays.asList("convert(varchar, ", function.getParameters().get(0), ", 8)");
    }

    protected List<Object> convertDateToString(Function function) {
        return Arrays.asList("stuff(stuff(convert(varchar, ", function.getParameters().get(0), ", 102), 5, 1, '-'), 8, 1, '-')");
    }

    protected List<?> convertTimestampToString(Function function) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.addAll(this.convertDateToString(function));
        result.add(Character.valueOf('+'));
        result.addAll(this.convertTimeToString(function));
        return result;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASCII");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("concat");
        supportedFunctions.add("concat2");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("locate");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("lcase");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("PI");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("repeat");
        supportedFunctions.add("RIGHT");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SPACE");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("ucase");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("TIMESTAMPADD");
        supportedFunctions.add("TIMESTAMPDIFF");
        supportedFunctions.add("WEEK");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("convert");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("nullif");
        supportedFunctions.add("trim");
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    public int getMaxFromGroups() {
        return 50;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    @Override
    public boolean booleanNullable() {
        return false;
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "CAST('" + this.formatDateValue(timeValue) + "' AS TIME)";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "CAST('" + this.formatDateValue(timestampValue) + "' AS TIMESTAMP)";
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "CAST('" + this.formatDateValue(dateValue) + "' AS DATE)";
    }

    public boolean supportsRowLimit() {
        return this.getVersion().compareTo(FIFTEEN_4) >= 0;
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public String getHibernateDialectClassName() {
        return "org.hibernate.dialect.SybaseAnywhereDialect";
    }

    public boolean supportsGroupByRollup() {
        return true;
    }

    @Override
    public boolean useUnicodePrefix() {
        return true;
    }

    @Override
    public boolean hasTimeType() {
        return true;
    }

    @Override
    public boolean useAsInGroupAlias() {
        return true;
    }

    @Override
    public void initCapabilities(Connection connection) throws TranslatorException {
        try {
            this.jConnectDriver = connection.getMetaData().getDriverName().contains("jConnect");
            if (this.jConnectDriver.booleanValue()) {
                this.setUseBindVariables(false);
                this.setUseBindingsForDependentJoin(false);
            }
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
        super.initCapabilities(connection);
    }

    @Override
    public boolean isSourceRequiredForCapabilities() {
        return super.isSourceRequiredForCapabilities() || this.jConnectDriver == null;
    }
}

