/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.access;

import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.language.Command;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslatedCommand;
import org.teiid.translator.jdbc.access.AccessExecutionFactory;

public class TestAccessSQLTranslator
extends TestCase {
    private static JDBCExecutionFactory TRANSLATOR;

    public void helpTestVisitor(String input, String expectedOutput) throws TranslatorException {
        Command obj = FakeTranslationFactory.getInstance().getBQTTranslationUtility().parseCommand(input);
        TranslatedCommand tc = new TranslatedCommand((ExecutionContext)Mockito.mock(ExecutionContext.class), TRANSLATOR);
        tc.translateCommand(obj);
        TestAccessSQLTranslator.assertEquals((String)"Did not get correct sql", (String)expectedOutput, (String)tc.getSql());
    }

    public void testRowLimit() throws Exception {
        String input = "select intkey from bqt1.smalla limit 100";
        String output = "SELECT TOP 100 SmallA.IntKey FROM SmallA";
        this.helpTestVisitor(input, output);
    }

    public void testRowLimit1() throws Exception {
        String input = "select distinct intkey from bqt1.smalla limit 100";
        String output = "SELECT DISTINCT TOP 100 SmallA.IntKey FROM SmallA";
        this.helpTestVisitor(input, output);
    }

    static {
        try {
            TRANSLATOR = new AccessExecutionFactory();
            TRANSLATOR.start();
        }
        catch (TranslatorException e) {
            e.printStackTrace();
        }
    }
}

