/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.postgresql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.teiid.core.util.StringUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;

public final class PostgreSQLMetadataProcessor
extends JDBCMetadataProcessor {
    @Override
    protected String getRuntimeType(int type, String typeName, int precision) {
        if ("geometry".equalsIgnoreCase(typeName)) {
            return "geometry";
        }
        if ("uuid".equalsIgnoreCase(typeName)) {
            return "string";
        }
        return super.getRuntimeType(type, typeName, precision);
    }

    @Override
    protected Column addColumn(ResultSet columns, Table table, MetadataFactory metadataFactory, int rsColumns) throws SQLException {
        Column result = super.addColumn(columns, table, metadataFactory, rsColumns);
        if ("uuid".equalsIgnoreCase(result.getNativeType())) {
            result.setLength(36);
            result.setCaseSensitive(false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getGeometryMetadata(Column c, Connection conn, String tableCatalog, String tableSchema, String tableName, String columnName) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (tableCatalog == null) {
                tableCatalog = conn.getCatalog();
            }
            ps = conn.prepareStatement("select coord_dimension, srid, type from public.geometry_columns where f_table_catalog=? and f_table_schema=? and f_table_name=? and f_geometry_column=?");
            ps.setString(1, tableCatalog);
            ps.setString(2, tableSchema);
            ps.setString(3, tableName);
            ps.setString(4, columnName);
            rs = ps.executeQuery();
            if (rs.next()) {
                c.setProperty("{http://www.teiid.org/translator/spatial/2015}coord_dimension", rs.getString(1));
                c.setProperty("{http://www.teiid.org/translator/spatial/2015}srid", rs.getString(2));
                c.setProperty("{http://www.teiid.org/translator/spatial/2015}type", rs.getString(3));
            }
        }
        catch (SQLException e) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Throwable)e, (Object[])new Object[]{"Could not get geometry metadata for column", tableSchema, tableName, columnName});
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    protected ResultSet executeSequenceQuery(Connection conn) throws SQLException {
        String query = "select null::varchar as sequence_catalog, nspname as sequence_schema, relname as sequence_name from pg_class, pg_namespace where relkind='S' and pg_namespace.oid = relnamespace and nspname like ? escape '' and relname like ? escape ''";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, this.getSchemaPattern() == null ? "%" : this.getSchemaPattern());
        ps.setString(2, this.getSequenceNamePattern() == null ? "%" : this.getSequenceNamePattern());
        return ps.executeQuery();
    }

    @Override
    protected String getSequenceNextSQL(String fullyQualifiedName) {
        return "nextval('" + StringUtil.replaceAll((String)fullyQualifiedName, (String)"'", (String)"''") + "')";
    }

    @Override
    protected Table addTable(MetadataFactory metadataFactory, String tableCatalog, String tableSchema, String tableName, String remarks, String fullName, ResultSet tables) throws SQLException {
        String type = tables.getString(4);
        if (type == null || type.contains("INDEX") || type.equalsIgnoreCase("TYPE") || type.equalsIgnoreCase("SEQUENCE")) {
            return null;
        }
        return super.addTable(metadataFactory, tableCatalog, tableSchema, tableName, remarks, fullName, tables);
    }
}

