/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.sybase;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.core.types.BinaryType;
import org.teiid.core.util.StringUtil;
import org.teiid.language.Command;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.EscapeSyntaxModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.ModFunctionModifier;
import org.teiid.translator.jdbc.ParseFormatFunctionModifier;
import org.teiid.translator.jdbc.oracle.ConcatFunctionModifier;
import org.teiid.translator.jdbc.sybase.BaseSybaseExecutionFactory;
import org.teiid.translator.jdbc.sybase.SubstringFunctionModifier;
import org.teiid.util.Version;

@Translator(name="sybase", description="A translator for Sybase Database")
public class SybaseExecutionFactory
extends BaseSybaseExecutionFactory {
    public static final Version TWELVE_5_3 = Version.getVersion((String)"12.5.3");
    public static final Version TWELVE_5 = Version.getVersion((String)"12.5");
    public static final Version FIFTEEN_0_2 = Version.getVersion((String)"15.0.2");
    public static final Version FIFTEEN_5 = Version.getVersion((String)"15.5");
    protected Map<String, Object> formatMap = new HashMap<String, Object>();
    protected boolean jtdsDriver;
    protected ConvertModifier convertModifier = new ConvertModifier();

    public SybaseExecutionFactory() {
        this.setSupportsFullOuterJoins(false);
        this.setMaxInCriteriaSize(250);
        this.setMaxDependentInPredicates(7);
        this.populateDateFormats();
    }

    protected void populateDateFormats() {
        this.formatMap.put("MM/dd/yy", 1);
        this.formatMap.put("yy.MM.dd", 2);
        this.formatMap.put("dd/MM/yy", 3);
        this.formatMap.put("dd.MM.yy", 4);
        this.formatMap.put("dd-MM-yy", 5);
        this.formatMap.put("dd MMM yy", 6);
        this.formatMap.put("MMM dd, yy", 7);
        this.formatMap.put("MM-dd-yy", 10);
        this.formatMap.put("yy/MM/dd", 11);
        this.formatMap.put("yyMMdd", 12);
        this.formatMap.put("yyddMM", 13);
        this.formatMap.put("MM/yy/dd", 14);
        this.formatMap.put("dd/yy/MM", 15);
        this.formatMap.put("MMM dd yy HH:mm:ss", 16);
        for (Map.Entry<String, Object> entry : new HashSet<Map.Entry<String, Object>>(this.formatMap.entrySet())) {
            this.formatMap.put(entry.getKey().replace("yy", "yyyy"), (Integer)entry.getValue() + 100);
        }
        this.formatMap.put("MMM d yyyy hh:mma", 100);
        this.formatMap.put("HH:mm:ss", 8);
        this.formatMap.put("MMM d yyyy hh:mm:ss:SSSa", 109);
        this.formatMap.put("hh:mma", 17);
        this.formatMap.put("HH:mm", 18);
        this.formatMap.put("hh:mm:ss:SSSa", 19);
        this.formatMap.put("HH:mm:ss:SSS", 20);
        this.formatMap.put("yy/MM/dd HH:mm:ss", 21);
        this.formatMap.put("yy/MM/dd hh:mm:ssa", 22);
        this.formatMap.put("yyyy-MM-dd'T'HH:mm:ss", 23);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("mod", new ModFunctionModifier("%", this.getLanguageFactory()));
        if (this.nullPlusNonNullIsNull()) {
            this.registerFunctionModifier("concat", new AliasModifier("+"));
        } else {
            this.registerFunctionModifier("concat", new ConcatFunctionModifier(this.getLanguageFactory()){

                @Override
                public List<?> translate(Function function) {
                    function.setName("+");
                    return super.translate(function);
                }
            });
        }
        this.registerFunctionModifier("lpad", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                List params = function.getParameters();
                return Arrays.asList("RIGHT(REPLICATE(", params.size() > 2 ? params.get(2) : new Literal((Object)" ", TypeFacility.RUNTIME_TYPES.STRING), ", ", params.get(1), ") + ", params.get(0), ", ", params.get(1), ")");
            }
        });
        this.registerFunctionModifier("rpad", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                List params = function.getParameters();
                return Arrays.asList("LEFT(", params.get(0), " + REPLICATE(", params.size() > 2 ? params.get(2) : new Literal((Object)" ", TypeFacility.RUNTIME_TYPES.STRING), ", ", params.get(1), "), ", params.get(1), ")");
            }
        });
        this.registerFunctionModifier("lcase", new AliasModifier("lower"));
        this.registerFunctionModifier("ifnull", new AliasModifier("isnull"));
        this.registerFunctionModifier("ucase", new AliasModifier("upper"));
        this.registerFunctionModifier("repeat", new AliasModifier("replicate"));
        this.registerFunctionModifier("substring", new SubstringFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("dayname", new EscapeSyntaxModifier());
        this.registerFunctionModifier("monthname", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayofweek", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayofyear", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayofmonth", new EscapeSyntaxModifier());
        this.registerFunctionModifier("hour", new EscapeSyntaxModifier());
        this.registerFunctionModifier("minute", new EscapeSyntaxModifier());
        this.registerFunctionModifier("quarter", new EscapeSyntaxModifier());
        this.registerFunctionModifier("second", new EscapeSyntaxModifier());
        this.registerFunctionModifier("week", new EscapeSyntaxModifier());
        this.registerFunctionModifier("length", new EscapeSyntaxModifier());
        this.registerFunctionModifier("atan2", new EscapeSyntaxModifier());
        this.registerFunctionModifier("timestampadd", new EscapeSyntaxModifier(){

            @Override
            public List<?> translate(Function function) {
                if (!SybaseExecutionFactory.this.isFracSeconds(function)) {
                    return super.translate(function);
                }
                return Arrays.asList("dateadd(millisecond, ", function.getParameters().get(1), "/1000000, ", function.getParameters().get(2), ")");
            }
        });
        this.registerFunctionModifier("timestampdiff", new EscapeSyntaxModifier(){

            @Override
            public List<?> translate(Function function) {
                if (!SybaseExecutionFactory.this.isFracSeconds(function)) {
                    return super.translate(function);
                }
                return Arrays.asList("datediff(millisecond, ", function.getParameters().get(1), ",", function.getParameters().get(2), ")*1000000");
            }
        });
        this.convertModifier.setBooleanNullable(this.booleanNullable());
        this.convertModifier.addTypeMapping("smallint", 3, 4);
        this.convertModifier.addTypeMapping("int", 5);
        this.convertModifier.addTypeMapping("numeric(19,0)", 6);
        this.convertModifier.addTypeMapping("real", 8);
        this.convertModifier.addTypeMapping("double precision", 9);
        this.convertModifier.addTypeMapping("numeric(38, 0)", 7);
        this.convertModifier.addTypeMapping("numeric(38, 19)", 10);
        this.convertModifier.addTypeConversion(new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                if (SybaseExecutionFactory.this.isNonAscii((Expression)function.getParameters().get(0))) {
                    ((Literal)function.getParameters().get(1)).setValue((Object)"nchar(1)");
                } else {
                    ((Literal)function.getParameters().get(1)).setValue((Object)"char(1)");
                }
                return null;
            }
        }, 1);
        this.convertModifier.addTypeConversion(new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                if (SybaseExecutionFactory.this.isNonAscii((Expression)function.getParameters().get(0))) {
                    ((Literal)function.getParameters().get(1)).setValue((Object)"nvarchar(4000)");
                } else {
                    ((Literal)function.getParameters().get(1)).setValue((Object)"varchar(4000)");
                }
                return null;
            }
        }, 0);
        this.convertModifier.addConvert(13, 11, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                ArrayList<Object> result = new ArrayList<Object>();
                result.add("cast(");
                result.addAll(SybaseExecutionFactory.this.convertDateToString(function));
                result.add(" AS datetime)");
                return result;
            }
        });
        this.convertModifier.addConvert(12, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return SybaseExecutionFactory.this.convertTimeToString(function);
            }
        });
        this.convertModifier.addConvert(11, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return SybaseExecutionFactory.this.convertDateToString(function);
            }
        });
        this.convertModifier.addConvert(13, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return SybaseExecutionFactory.this.convertTimestampToString(function);
            }
        });
        this.convertModifier.addNumericBooleanConversions();
        this.registerFunctionModifier("convert", this.convertModifier);
        this.registerFunctionModifier("parsetimestamp", new SybaseFormatFunctionModifier("CONVERT(DATETIME, ", this.formatMap));
        this.registerFunctionModifier("formattimestamp", new SybaseFormatFunctionModifier("CONVERT(VARCHAR, ", this.formatMap));
    }

    private void handleTimeConversions() {
        if (!this.hasTimeType()) {
            this.convertModifier.addTypeMapping("datetime", 11, 12, 13);
            this.convertModifier.addConvert(13, 12, new FunctionModifier(){

                @Override
                public List<?> translate(Function function) {
                    ArrayList<String> result = new ArrayList<String>();
                    result.add("cast(");
                    boolean needsEnd = false;
                    if (!SybaseExecutionFactory.this.nullPlusNonNullIsNull() && !ConcatFunctionModifier.isNotNull((Expression)function.getParameters().get(0))) {
                        result.add("CASE WHEN ");
                        result.add((String)function.getParameters().get(0));
                        result.add(" IS NOT NULL THEN ");
                        needsEnd = true;
                    }
                    result.add("'1970-01-01 ' + ");
                    result.addAll(SybaseExecutionFactory.this.convertTimeToString(function));
                    if (needsEnd) {
                        result.add(" END");
                    }
                    result.add(" AS datetime)");
                    return result;
                }
            });
        } else {
            this.convertModifier.addTypeMapping("datetime", 11, 13);
            this.convertModifier.addTypeMapping("time", 12);
        }
    }

    private List<Object> convertTimeToString(Function function) {
        return Arrays.asList("convert(varchar, ", function.getParameters().get(0), ", 8)");
    }

    protected List<Object> convertDateToString(Function function) {
        return Arrays.asList("stuff(stuff(convert(varchar, ", function.getParameters().get(0), ", 102), 5, 1, '-'), 8, 1, '-')");
    }

    protected List<?> convertTimestampToString(Function function) {
        if (this.getVersion().compareTo(FIFTEEN_5) >= 0) {
            return Arrays.asList("stuff(convert(varchar, ", function.getParameters().get(0), ", 23), 11, 1, ' ')");
        }
        LinkedList<Object> result = new LinkedList<Object>();
        result.addAll(this.convertDateToString(function));
        result.add("+' '+");
        result.addAll(this.convertTimeToString(function));
        return result;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("PI");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("ASCII");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("||");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LOWER");
        supportedFunctions.add("LPAD");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("REPEAT");
        supportedFunctions.add("RIGHT");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SPACE");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("UPPER");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("RPAD");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("TIMESTAMPADD");
        supportedFunctions.add("TIMESTAMPDIFF");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        supportedFunctions.add("parsetimestamp");
        supportedFunctions.add("formattimestamp");
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    public int getMaxFromGroups() {
        return 50;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return this.getVersion().compareTo(FIFTEEN_0_2) >= 0;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean booleanNullable() {
        return false;
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "CAST('" + this.formatDateValue(timestampValue) + "' AS DATETIME)";
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "CAST('" + this.formatDateValue(dateValue) + "' AS DATE)";
    }

    private boolean isFracSeconds(Function function) {
        Expression e = (Expression)function.getParameters().get(0);
        return e instanceof Literal && "SQL_TSI_FRAC_SECOND".equalsIgnoreCase((String)((Literal)e).getValue());
    }

    public boolean supportsRowLimit() {
        return this.getVersion().getMajorVersion() == 12 && this.getVersion().compareTo(TWELVE_5_3) >= 0 || this.getVersion().compareTo(FIFTEEN_0_2) >= 0;
    }

    @TranslatorProperty(display="JTDS Driver", description="True if the driver is the JTDS driver", advanced=true)
    public boolean isJtdsDriver() {
        return this.jtdsDriver;
    }

    public void setJtdsDriver(boolean jtdsDriver) {
        this.jtdsDriver = jtdsDriver;
    }

    protected boolean setFetchSize() {
        return this.isJtdsDriver();
    }

    @Override
    public void setFetchSize(Command command, ExecutionContext context, Statement statement, int fetchSize) throws SQLException {
        if (!this.setFetchSize()) {
            return;
        }
        super.setFetchSize(command, context, statement, fetchSize);
    }

    @Override
    public void initCapabilities(Connection connection) throws TranslatorException {
        super.initCapabilities(connection);
        if (!this.jtdsDriver && connection != null) {
            try {
                this.jtdsDriver = StringUtil.indexOfIgnoreCase((String)connection.getMetaData().getDriverName(), (String)"jtds") != -1;
            }
            catch (SQLException e) {
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)e, (Object)"Could not automatically determine if the jtds driver is in use");
            }
        }
        this.handleTimeConversions();
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public String getHibernateDialectClassName() {
        if (this.getVersion().compareTo(FIFTEEN_0_2) >= 0) {
            return "org.hibernate.dialect.SybaseASE15Dialect";
        }
        return "org.hibernate.dialect.Sybase11Dialect";
    }

    public boolean supportsGroupByRollup() {
        return false;
    }

    @Override
    public boolean useUnicodePrefix() {
        return true;
    }

    public boolean supportsOnlyFormatLiterals() {
        return true;
    }

    public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
        if (format == ExecutionFactory.Format.NUMBER) {
            return false;
        }
        return this.formatMap.containsKey(literal);
    }

    @Override
    public List<?> translateCommand(Command command, ExecutionContext context) {
        DerivedColumn dc;
        Select select;
        if (!this.supportsLiteralOnlyWithGrouping() && command instanceof Select && (select = (Select)command).getGroupBy() != null && select.getDerivedColumns().size() == 1 && (dc = (DerivedColumn)select.getDerivedColumns().get(0)).getExpression() instanceof Literal) {
            dc.setExpression((Expression)select.getGroupBy().getElements().get(0));
        }
        return super.translateCommand(command, context);
    }

    public boolean supportsLiteralOnlyWithGrouping() {
        return false;
    }

    @Override
    public String translateLiteralBinaryType(BinaryType obj) {
        return "0x" + obj;
    }

    public static final class SybaseFormatFunctionModifier
    extends ParseFormatFunctionModifier {
        private Map<String, Object> formatMap;

        public SybaseFormatFunctionModifier(String prefix, Map<String, Object> formatMap) {
            super(prefix);
            this.formatMap = formatMap;
        }

        @Override
        protected void translateFormat(List<Object> result, Expression expression, String value) {
            Object format = this.translateFormat(value);
            if (format instanceof String) {
                result.add("convert(");
                result.add(format);
                result.add(", ");
                result.add(expression);
                result.add(")");
            } else {
                super.translateFormat(result, expression, value);
            }
        }

        @Override
        protected Object translateFormat(String format) {
            return this.formatMap.get(format);
        }
    }
}

