/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.hsql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.Literal;
import org.teiid.translator.jdbc.FunctionModifier;

public class AddDiffModifier
extends FunctionModifier {
    private static Map<String, String> INTERVAL_MAP = new HashMap<String, String>();
    private boolean add;
    private boolean supportsQuarter;
    private boolean literalPart = true;

    public AddDiffModifier(boolean add, LanguageFactory factory) {
        this.add = add;
    }

    public AddDiffModifier supportsQuarter(boolean b) {
        this.supportsQuarter = b;
        return this;
    }

    public AddDiffModifier literalPart(boolean b) {
        this.literalPart = b;
        return this;
    }

    @Override
    public List<?> translate(Function function) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.add) {
            result.add("dateadd(");
        } else {
            result.add("datediff(");
        }
        for (int i = 0; i < function.getParameters().size(); ++i) {
            if (i > 0) {
                result.add(", ");
            }
            result.add(function.getParameters().get(i));
        }
        result.add(")");
        Literal intervalType = (Literal)function.getParameters().get(0);
        String interval = ((String)intervalType.getValue()).toUpperCase();
        String newInterval = INTERVAL_MAP.get(interval);
        if (newInterval != null) {
            intervalType.setValue((Object)newInterval);
        } else if (this.supportsQuarter && interval.equals("SQL_TSI_QUARTER")) {
            intervalType.setValue((Object)"QUARTER");
        } else if (this.add) {
            if (interval.equals("SQL_TSI_FRAC_SECOND")) {
                intervalType.setValue((Object)"MILLISECOND");
                result.add(4, " / 1000000");
            } else if (interval.equals("SQL_TSI_QUARTER")) {
                intervalType.setValue((Object)"DAY");
                result.add(4, " * 91");
            } else {
                intervalType.setValue((Object)"DAY");
                result.add(4, " * 7");
            }
        } else if (interval.equals("SQL_TSI_FRAC_SECOND")) {
            intervalType.setValue((Object)"MILLISECOND");
            result.add(" * 1000000");
        } else if (interval.equals("SQL_TSI_QUARTER")) {
            intervalType.setValue((Object)"DAY");
            result.add(" / 91");
        } else {
            intervalType.setValue((Object)"DAY");
            result.add(" / 7");
        }
        if (!this.literalPart) {
            result.set(1, intervalType.getValue());
        }
        return result;
    }

    static {
        INTERVAL_MAP.put("SQL_TSI_DAY", "DAY");
        INTERVAL_MAP.put("SQL_TSI_HOUR", "HOUR");
        INTERVAL_MAP.put("SQL_TSI_MINUTE", "MINUTE");
        INTERVAL_MAP.put("SQL_TSI_MONTH", "MONTH");
        INTERVAL_MAP.put("SQL_TSI_SECOND", "SECOND");
        INTERVAL_MAP.put("SQL_TSI_YEAR", "YEAR");
    }
}

